/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.MethodCall;
import edu.stanford.smi.protege.util.CacheMap;
import java.lang.reflect.Method;
import java.util.Collection;

public class CallCachingFrameStore
extends AbstractFrameStoreInvocationHandler {
    private static final int MAX_SIZE = 100000;
    private CacheMap _cache = new CacheMap(100000);
    private MethodCall _lookupMethodCall = new MethodCall();
    private int hit = 0;
    private int miss = 0;

    protected Object handleInvoke(Method method, Object[] objectArray) {
        Object object;
        if (CallCachingFrameStore.isGetEvents(method)) {
            object = this.invoke(method, objectArray);
            Collection collection = (Collection)object;
            if (!collection.isEmpty()) {
                this.clearCache();
            }
        } else if (CallCachingFrameStore.isQuery(method)) {
            object = this.query(method, objectArray);
        } else {
            this._cache.clear();
            object = this.invoke(method, objectArray);
        }
        return object;
    }

    private static boolean isGetEvents(Method method) {
        return method.getName().equals("getEvents");
    }

    private Object query(Method method, Object[] objectArray) {
        this._lookupMethodCall.set(method, objectArray);
        Object object = this._cache.get(this._lookupMethodCall);
        if (object == null) {
            ++this.miss;
            object = this.invoke(method, objectArray);
            this._cache.put(new MethodCall(method, objectArray), object);
        } else {
            ++this.hit;
        }
        return object;
    }

    private void clearCache() {
        this._cache.clear();
    }

    public void handleClose() {
        this._cache.clear();
        this._cache = null;
    }

    protected void handleReinitialize() {
        this._cache.clear();
    }
}

