/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.test.APITestCase;

public class DefaultCls_Test
extends APITestCase {
    public void testHasDirectlyOverriddenTemplateFacet() {
        Cls cls = this.getCls(":STANDARD-SLOT");
        Cls cls2 = this.createSubCls(cls);
        Slot slot = this.createSingleValuedSlot(ValueType.STRING);
        Facet facet = this.createFacet();
        slot.setAssociatedFacet(facet);
        cls2.addDirectTemplateSlot(slot);
        Slot slot2 = (Slot)this.createInstance(cls2);
        slot2.setOwnSlotValue(slot, "foo");
        Cls cls3 = this.createCls();
        cls3.addDirectTemplateSlot(slot2);
        DefaultCls_Test.assertTrue((String)"attached", (!cls3.hasDirectlyOverriddenTemplateFacet(slot2, facet) ? 1 : 0) != 0);
        cls3.setTemplateFacetValue(slot2, facet, "bar");
        DefaultCls_Test.assertTrue((String)"overridden", (boolean)cls3.hasDirectlyOverriddenTemplateFacet(slot2, facet));
        Cls cls4 = this.createSubCls(cls3);
        DefaultCls_Test.assertTrue((String)"not overridden in subclass", (!cls4.hasDirectlyOverriddenTemplateFacet(slot2, facet) ? 1 : 0) != 0);
        Cls cls5 = this.createSubCls(cls4);
        DefaultCls_Test.assertTrue((String)"not overridden in subsubclass", (!cls5.hasDirectlyOverriddenTemplateFacet(slot2, facet) ? 1 : 0) != 0);
        cls4.setTemplateFacetValue(slot2, facet, "baz");
        DefaultCls_Test.assertTrue((String)"overridden in subclass", (boolean)cls4.hasDirectlyOverriddenTemplateFacet(slot2, facet));
        DefaultCls_Test.assertTrue((String)"not overridden in subsubclass - 2", (!cls5.hasDirectlyOverriddenTemplateFacet(slot2, facet) ? 1 : 0) != 0);
        cls5.setTemplateFacetValue(slot2, facet, "bat");
        DefaultCls_Test.assertTrue((String)"overridden in subsubclass", (boolean)cls5.hasDirectlyOverriddenTemplateFacet(slot2, facet));
    }

    public void testHasOverriddenTemplateFacet() {
        Facet facet = this.getFacet(":VALUE-TYPE");
        Cls cls = this.createCls();
        Slot slot = this.createMultiValuedSlot(ValueType.ANY);
        cls.addDirectTemplateSlot(slot);
        Cls cls2 = this.createSubCls(cls);
        DefaultCls_Test.assertTrue((String)"subclass not overridden", (!cls2.hasOverriddenTemplateFacet(slot, facet) ? 1 : 0) != 0);
        cls.setTemplateSlotValueType(slot, ValueType.INTEGER);
        DefaultCls_Test.assertTrue((String)"class overridden", (boolean)cls.hasOverriddenTemplateFacet(slot, facet));
        DefaultCls_Test.assertTrue((String)"subclass overridden", (boolean)cls2.hasOverriddenTemplateFacet(slot, facet));
    }
}

