/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.resource.Files;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class BackwardsCompatibilityProjectFixups {
    BackwardsCompatibilityProjectFixups() {
    }

    private static void addWidgetDescriptor(Instance instance, String string) {
        Object object;
        Object object2;
        Instance instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance, "property_list");
        Iterator iterator = ModelUtilities.getDirectOwnSlotValues(instance2, "properties").iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            object2 = (Instance)iterator.next();
            object = (String)ModelUtilities.getDirectOwnSlotValue((Frame)object2, "name");
            if (!((String)object).equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            object2 = instance.getKnowledgeBase();
            object = WidgetDescriptor.create((KnowledgeBase)object2);
            ModelUtilities.setOwnSlotValue(((WidgetDescriptor)object).getInstance(), "name", string);
            ModelUtilities.addOwnSlotValue(instance2, "properties", ((WidgetDescriptor)object).getInstance());
        }
    }

    public static void fix(KnowledgeBase knowledgeBase) {
        if (BackwardsCompatibilityProjectFixups.shouldUpdate(knowledgeBase)) {
            BackwardsCompatibilityProjectFixups.updateStandardForms(knowledgeBase);
        }
    }

    private static boolean shouldUpdate(KnowledgeBase knowledgeBase) {
        return !BackwardsCompatibilityProjectFixups.isCurrentBuild(knowledgeBase) && !BackwardsCompatibilityProjectFixups.isOwl(knowledgeBase);
    }

    private static boolean isOwl(KnowledgeBase knowledgeBase) {
        Slot slot;
        Instance instance = knowledgeBase.getInstance("PROJECT");
        String string = (String)instance.getOwnSlotValue(slot = knowledgeBase.getSlot("default_cls_metaclass"));
        return string.indexOf("owl:") != -1;
    }

    private static Instance getClsWidgetInstance(String string, KnowledgeBase knowledgeBase) {
        Instance instance = null;
        List list = ModelUtilities.getDirectOwnSlotValues(BackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase), "customized_instance_widgets");
        for (Instance instance2 : list) {
            String string2 = (String)ModelUtilities.getDirectOwnSlotValue(instance2, "name");
            if (!string.equals(string2)) continue;
            instance = instance2;
            break;
        }
        return instance;
    }

    private static KnowledgeBaseFactory getFactory(KnowledgeBase knowledgeBase) {
        KnowledgeBaseFactory knowledgeBaseFactory = null;
        Instance instance = BackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase);
        Instance instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance, "sources");
        for (Instance instance3 : ModelUtilities.getDirectOwnSlotValues(instance2, "properties")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue(instance3, "name");
            if (!string.equals("factory_class_name")) continue;
            String string2 = (String)ModelUtilities.getDirectOwnSlotValue(instance3, "string_value");
            knowledgeBaseFactory = (KnowledgeBaseFactory)SystemUtilities.newInstance(string2);
            break;
        }
        return knowledgeBaseFactory;
    }

    private static Instance getProjectInstance(KnowledgeBase knowledgeBase) {
        Instance instance = knowledgeBase.getInstance("PROJECT");
        Assert.assertNotNull("instance", instance);
        return instance;
    }

    private static KnowledgeBase getTemplateKnowledgeBase(KnowledgeBase knowledgeBase) {
        ArrayList arrayList = new ArrayList();
        Reader reader = Files.getSystemClsesReader();
        KnowledgeBaseFactory knowledgeBaseFactory = BackwardsCompatibilityProjectFixups.getFactory(knowledgeBase);
        String string = knowledgeBaseFactory == null ? (String)null : knowledgeBaseFactory.getProjectFilePath();
        Reader reader2 = string == null ? Files.getSystemInstancesReader() : FileUtilities.getResourceReader(knowledgeBaseFactory.getClass(), string);
        return new ClipsKnowledgeBaseFactory().loadKnowledgeBase(reader, reader2, arrayList);
    }

    private static boolean isClsMetaclass(Instance instance) {
        boolean bl = false;
        Instance instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance, "property_list");
        for (Instance instance3 : ModelUtilities.getDirectOwnSlotValues(instance2, "properties")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue(instance3, "name");
            if (!string.equals(":DIRECT-TEMPLATE-SLOTS")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean isCurrentBuild(KnowledgeBase knowledgeBase) {
        String string;
        String string2 = Text.getBuildInfo();
        return string2.equals(string = knowledgeBase.getBuildString()) || string == null;
    }

    private static boolean isSlotMetaclass(Instance instance) {
        boolean bl = false;
        Instance instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance, "property_list");
        for (Instance instance3 : ModelUtilities.getDirectOwnSlotValues(instance2, "properties")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue(instance3, "name");
            if (!string.equals(":SLOT-VALUE-TYPE")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean replaceFormWidget(String string, KnowledgeBase knowledgeBase, KnowledgeBase knowledgeBase2) {
        Instance instance;
        Instance instance2;
        Instance instance3 = BackwardsCompatibilityProjectFixups.getClsWidgetInstance(string, knowledgeBase2);
        Instance instance4 = BackwardsCompatibilityProjectFixups.getClsWidgetInstance(string, knowledgeBase);
        if (instance4 == null) {
            instance2 = knowledgeBase.getCls("Widget");
            instance4 = knowledgeBase.createInstance(null, (Cls)instance2);
            ModelUtilities.setOwnSlotValue(instance4, "name", string);
            instance = BackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase);
            ModelUtilities.addOwnSlotValue(instance, "customized_instance_widgets", instance4);
        }
        instance2 = (Instance)ModelUtilities.getDirectOwnSlotValue(instance3, "property_list");
        instance = (Instance)instance2.deepCopy(knowledgeBase, null);
        ModelUtilities.setOwnSlotValue(instance4, "property_list", instance);
        return instance3 != null;
    }

    private static void updateStandardForms(KnowledgeBase knowledgeBase) {
        KnowledgeBase knowledgeBase2 = BackwardsCompatibilityProjectFixups.getTemplateKnowledgeBase(knowledgeBase);
        Instance instance = BackwardsCompatibilityProjectFixups.getProjectInstance(knowledgeBase2);
        for (Instance instance2 : ModelUtilities.getDirectOwnSlotValues(instance, "customized_instance_widgets")) {
            String string = (String)ModelUtilities.getDirectOwnSlotValue(instance2, "name");
            boolean bl = BackwardsCompatibilityProjectFixups.replaceFormWidget(string, knowledgeBase, knowledgeBase2);
            if (bl) continue;
            if (BackwardsCompatibilityProjectFixups.isClsMetaclass(instance2)) {
                BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-TYPE");
                continue;
            }
            if (!BackwardsCompatibilityProjectFixups.isSlotMetaclass(instance2)) continue;
            BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-TEMPLATE-SLOTS");
            BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":SLOT-CONSTRAINTS");
            BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-SUBSLOTS");
            BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-SUPERSLOTS");
            BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":DIRECT-DOMAIN");
            BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":SLOT-INVERSE");
            BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":SLOT-VALUES");
            BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":SLOT-MINIMUM-CARDINALITY");
            BackwardsCompatibilityProjectFixups.addWidgetDescriptor(instance2, ":ASSOCIATED-FACET");
        }
    }
}

