/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.action;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.DeleteAction;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import javax.swing.JComponent;

public class DeleteInstancesAction
extends DeleteAction {
    public DeleteInstancesAction(Selectable selectable) {
        this(ResourceKey.INSTANCE_DELETE, selectable);
    }

    public DeleteInstancesAction(ResourceKey resourceKey, Selectable selectable) {
        super(resourceKey, selectable);
    }

    public DeleteInstancesAction(String string, Selectable selectable) {
        super(string, selectable);
    }

    private boolean canDelete(Instance instance) {
        boolean bl = true;
        if (instance instanceof Cls) {
            Cls cls = (Cls)instance;
            int n = cls.getInstanceCount();
            boolean bl2 = bl = n == 0;
            if (!bl) {
                String string = LocalizedText.getText(ResourceKey.DELETE_CLASS_FAILED_DIALOG_TEXT);
                ModalDialog.showMessageDialog((JComponent)((Object)this.getSelectable()), string);
            }
        }
        return bl;
    }

    protected void onAboutToDelete(Object object) {
    }

    protected void onAfterDelete(Object object) {
    }

    public void onDelete(Object object) {
        Instance instance = (Instance)object;
        if (this.canDelete(instance)) {
            this.onAboutToDelete(instance);
            this.deleteInstance(instance);
            this.onAfterDelete(object);
        }
    }

    public void deleteInstance(Instance instance) {
        instance.getKnowledgeBase().deleteFrame(instance);
    }

    public void onSelectionChange() {
        boolean bl = true;
        for (Instance instance : this.getSelection()) {
            if (instance.isEditable()) continue;
            bl = false;
            break;
        }
        this.setAllowed(bl);
    }
}

