/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl.ccsg;

import org.apache.ws.jaxme.generator.sg.AttributeSG;
import org.apache.ws.jaxme.generator.sg.ComplexTypeSG;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.ObjectSG;
import org.apache.ws.jaxme.generator.sg.ParticleSG;
import org.apache.ws.jaxme.generator.sg.PropertySG;
import org.apache.ws.jaxme.generator.sg.PropertySGChain;
import org.apache.ws.jaxme.generator.sg.TypeSG;
import org.apache.ws.jaxme.generator.sg.impl.PropertySGChainImpl;
import org.apache.ws.jaxme.generator.sg.impl.PropertySGImpl;
import org.apache.ws.jaxme.generator.sg.impl.ccsg.GroupUtil;
import org.apache.ws.jaxme.generator.sg.impl.ccsg.ParticleVisitorImpl;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaInnerClass;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaSource;
import org.xml.sax.SAXException;

public class BeanGeneratingVisitor
extends ParticleVisitorImpl {
    private final JavaSource js;
    private JavaMethod mixedContentMethod;
    private boolean isMixed;
    private ComplexTypeSG ct;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;

    public BeanGeneratingVisitor(JavaSource pJs) {
        this.js = pJs;
    }

    private JavaSource getJavaSource() {
        return this.js;
    }

    private boolean isInheritedAttribute(AttributeSG pAttr, AttributeSG[] pInheritedAttributes) throws SAXException {
        if (pInheritedAttributes != null) {
            String p = pAttr.getPropertySG().getPropertyName();
            for (int i = 0; i < pInheritedAttributes.length; ++i) {
                if (!pInheritedAttributes[i].getPropertySG().getPropertyName().equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    private void generateAttributes(ComplexTypeSG pType) throws SAXException {
        TypeSG tSG;
        JavaSource js = this.getJavaSource();
        AttributeSG[] myAttributes = pType.getAttributes();
        AttributeSG[] inheritedAttributes = null;
        if (pType.getTypeSG().isExtension() && (tSG = pType.getTypeSG().getExtendedType()).isComplex()) {
            inheritedAttributes = tSG.getComplexTypeSG().getAttributes();
        }
        for (int i = 0; i < myAttributes.length; ++i) {
            AttributeSG attr = myAttributes[i];
            if (this.isInheritedAttribute(attr, inheritedAttributes)) continue;
            attr.getPropertySG().generate(js);
        }
    }

    public void emptyType(ComplexTypeSG pType) throws SAXException {
        this.generateAttributes(pType);
    }

    public void simpleContent(ComplexTypeSG pType) throws SAXException {
        this.generateAttributes(pType);
        pType.getSimpleContentSG().getPropertySG().generate(this.getJavaSource());
    }

    protected JavaMethod getGetMixedContentMethod() {
        if (this.mixedContentMethod == null) {
            JavaSource js = this.getJavaSource();
            JavaMethod jm = js.newJavaMethod("getContent", class$java$util$List == null ? (class$java$util$List = BeanGeneratingVisitor.class$("java.util.List")) : class$java$util$List, JavaSource.PUBLIC);
            if (!js.isInterface()) {
                JavaField mixedContentList = this.getJavaSource().newJavaField("content", class$java$util$List == null ? (class$java$util$List = BeanGeneratingVisitor.class$("java.util.List")) : class$java$util$List, JavaSource.PRIVATE);
                mixedContentList.setFinal(true);
                mixedContentList.addLine((Object)"new ", (Object)(class$java$util$ArrayList == null ? (class$java$util$ArrayList = BeanGeneratingVisitor.class$("java.util.ArrayList")) : class$java$util$ArrayList), (Object)"()");
                jm.addLine((Object)"return ", (Object)mixedContentList, (Object)";");
            }
        }
        return this.mixedContentMethod;
    }

    public void startComplexContent(ComplexTypeSG pType) throws SAXException {
        pType.getComplexContentSG().getElementParticles();
        this.ct = pType;
        this.generateAttributes(pType);
        if (pType.getComplexContentSG().isMixed()) {
            this.isMixed = true;
            this.getGetMixedContentMethod();
        }
    }

    private boolean isInheritedParticle(ParticleSG pParticle) throws SAXException {
        TypeSG extType;
        String propertyName = pParticle.getPropertySG().getPropertyName();
        if (this.ct.getTypeSG().isExtension() && (extType = this.ct.getTypeSG().getExtendedType()).isComplex() && !extType.getComplexTypeSG().hasSimpleContent()) {
            ParticleSG[] inheritedParticles = extType.getComplexTypeSG().getComplexContentSG().getElementParticles();
            for (int i = 0; i < inheritedParticles.length; ++i) {
                if (!inheritedParticles[i].getPropertySG().getPropertyName().equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    private void elementParticle(GroupSG pGroupSG, ParticleSG pParticle) throws SAXException {
        ObjectSG oSG;
        TypeSG typeSG;
        if (this.isInheritedParticle(pParticle)) {
            return;
        }
        JavaSource pJs = this.js;
        PropertySG elementSG = pParticle.getPropertySG();
        if (this.isMixed) {
            if (!pParticle.getObjectSG().getTypeSG().isComplex()) {
                JavaInnerClass js;
                JavaQName qName = GroupUtil.getContentClass(pGroupSG, pParticle, pJs.getQName());
                if (qName.isInnerClass()) {
                    js = pJs.newJavaInnerClass(qName.getInnerClassName(), JavaSource.PUBLIC);
                    if (!pJs.isInterface()) {
                        js.setStatic(true);
                    }
                } else {
                    js = pJs.getFactory().newJavaSource(qName, JavaSource.PUBLIC);
                }
                if (pJs.isInterface()) {
                    js.setType(JavaSource.INTERFACE);
                } else {
                    js.addImplements(GroupUtil.getContentClass(pGroupSG, pParticle, this.ct.getClassContext().getXMLInterfaceName()));
                }
                PropertySGChain chain = ((PropertySGImpl)elementSG).getHeadOfChain();
                PropertySGChainImpl head = new PropertySGChainImpl(chain){

                    public String getXMLFieldName(PropertySG pController) throws SAXException {
                        return "_value";
                    }

                    public String getPropertyName(PropertySG pController) throws SAXException {
                        return "value";
                    }
                };
                PropertySGImpl pSG = new PropertySGImpl(head);
                pSG.generate((JavaSource)js);
            }
        } else {
            elementSG.generate(pJs);
        }
        if (!(typeSG = (oSG = pParticle.getObjectSG()).getTypeSG()).isGlobalType() && !typeSG.isGlobalClass() && typeSG.isComplex()) {
            ComplexTypeSG complexTypeSG = typeSG.getComplexTypeSG();
            if (pJs.isInterface()) {
                complexTypeSG.getXMLInterface(pJs);
            } else {
                complexTypeSG.getXMLImplementation(pJs);
            }
        }
    }

    public void simpleElementParticle(GroupSG pGroup, ParticleSG pParticle) throws SAXException {
        this.elementParticle(pGroup, pParticle);
    }

    public void complexElementParticle(GroupSG pGroup, ParticleSG pParticle) throws SAXException {
        this.elementParticle(pGroup, pParticle);
    }

    public void wildcardParticle(ParticleSG particle) {
        throw new IllegalStateException("TODO: Add support for wildcards");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

