/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.generator.sg.Context;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.util.JavaNamer;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.xs.jaxb.JAXBSchemaBindings;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public abstract class AbstractContext
implements Context {
    private XsQName name;
    private JavaQName xmlInterfaceName;
    private JavaQName xmlImplementationName;
    private JavaQName xmlHandlerName;
    private JavaQName xmlSerializerName;
    private JavaQName xmlValidatorName;
    private JavaQName pmName;

    public XsQName getName() {
        return this.name;
    }

    protected void setName(XsQName pName) {
        this.name = pName;
    }

    public JavaQName getXMLHandlerName() {
        return this.xmlHandlerName;
    }

    protected void setXMLHandlerName(JavaQName pXmlHandlerName) {
        this.xmlHandlerName = pXmlHandlerName;
    }

    public JavaQName getXMLImplementationName() {
        return this.xmlImplementationName;
    }

    protected void setXMLImplementationName(JavaQName pXmlImplementationName) {
        this.xmlImplementationName = pXmlImplementationName;
    }

    public JavaQName getXMLInterfaceName() {
        return this.xmlInterfaceName;
    }

    protected void setXMLInterfaceName(JavaQName pXmlInterfaceName) {
        this.xmlInterfaceName = pXmlInterfaceName;
    }

    public JavaQName getXMLSerializerName() {
        return this.xmlSerializerName;
    }

    protected void setXMLSerializerName(JavaQName pXmlSerializerName) {
        this.xmlSerializerName = pXmlSerializerName;
    }

    protected void setXMLValidatorName(JavaQName pXmlValidatorName) {
        this.xmlValidatorName = pXmlValidatorName;
    }

    public JavaQName getXMLValidatorName() {
        return this.xmlValidatorName;
    }

    protected void setPMName(JavaQName pPMName) {
        this.pmName = pPMName;
    }

    public JavaQName getPMName() {
        return this.pmName;
    }

    protected static String getClassNameFromLocalName(Locator pLocator, String pLocalName, SchemaSG pSchemaSG) throws SAXException {
        if (pLocalName == null || pLocalName.length() == 0) {
            throw new LocSAXException("Invalid local name: " + pLocalName, pLocator);
        }
        return JavaNamer.convert(pLocalName, pSchemaSG);
    }

    protected static String getPackageName(SchemaSG pSchemaSG, JAXBSchemaBindings pSchemaBindings, Locator pLocator, XsQName pQName) throws SAXException {
        JAXBSchemaBindings.Package jaxbPackage;
        String packageName = pSchemaSG.getFactory().getGenerator().getProperty("jaxme.package.name");
        if (packageName == null && pSchemaBindings != null && (jaxbPackage = pSchemaBindings.getPackage()) != null) {
            packageName = jaxbPackage.getName();
        }
        if (packageName == null) {
            packageName = AbstractContext.getPackageNameFromURI(pLocator, pQName.getNamespaceURI());
        }
        return packageName;
    }

    protected static String getPackageNameFromURL(URL pURL) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(pURL.getHost(), ".");
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        Collections.reverse(tokens);
        st = new StringTokenizer(pURL.getPath(), "/");
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        if (tokens.size() == 0) {
            throw new IllegalArgumentException("Could not parse URL " + pURL);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tokens.size(); ++i) {
            String tok;
            if (i > 0) {
                sb.append('.');
            }
            if ((tok = (String)tokens.get(i)).length() == 0) {
                throw new IllegalArgumentException("Could not parse URL " + pURL);
            }
            for (int j = 0; j < tok.length(); ++j) {
                char c = Character.toLowerCase(tok.charAt(j));
                if (j == 0 && Character.isJavaIdentifierStart(c) || j > 0 && Character.isJavaIdentifierPart(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append('_');
            }
        }
        return sb.toString();
    }

    protected static String getPackageNameFromURI(Locator pLocator, String pURI) throws SAXException {
        if (pURI == null || pURI.length() == 0) {
            throw new LocSAXException("Unable to derive package name from an empty namespace URI. Use the schemaBindings to specify a package name.", pLocator);
        }
        try {
            URL url = new URL(pURI);
            return AbstractContext.getPackageNameFromURL(url);
        }
        catch (MalformedURLException e) {
            throw new LocSAXException("Unable to derive package name from an URI, which is no URL: " + pURI, pLocator);
        }
    }

    public String toString() {
        return super.toString() + " [" + this.getName() + "," + this.getXMLInterfaceName() + "," + this.getXMLImplementationName() + "]";
    }
}

