/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.jaxme.generator.Generator;
import org.apache.ws.jaxme.generator.SchemaReader;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GeneratorImpl
implements Generator {
    private static final Logger log = LoggerAccess.getLogger((Class)(class$org$apache$ws$jaxme$generator$impl$GeneratorImpl == null ? (class$org$apache$ws$jaxme$generator$impl$GeneratorImpl = GeneratorImpl.class$("org.apache.ws.jaxme.generator.impl.GeneratorImpl")) : class$org$apache$ws$jaxme$generator$impl$GeneratorImpl));
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private SchemaReader schemaReader;
    private File targetDirectory;
    private File resourceTargetDirectory;
    private Map properties = new HashMap();
    private int nextKey;
    private boolean isValidating;
    private boolean isForcingOverwrite;
    private boolean isSettingReadOnly;
    private EntityResolver entityResolver;
    private final List bindings = new ArrayList();
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$impl$GeneratorImpl;

    public void setEntityResolver(EntityResolver pEntityResolver) {
        this.entityResolver = pEntityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public boolean isForcingOverwrite() {
        return this.isForcingOverwrite;
    }

    public void setForcingOverwrite(boolean pIsForcingOverwrite) {
        this.isForcingOverwrite = pIsForcingOverwrite;
    }

    public boolean isSettingReadOnly() {
        return this.isSettingReadOnly;
    }

    public void setSettingReadOnly(boolean pIsSettingReadOnly) {
        this.isSettingReadOnly = pIsSettingReadOnly;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void setValidating(boolean pIsValidating) {
        this.isValidating = pIsValidating;
    }

    public void setSchemaReader(SchemaReader pReader) {
        this.schemaReader = pReader;
    }

    public SchemaReader getSchemaReader() {
        return this.schemaReader;
    }

    public void setTargetDirectory(File pDirectory) {
        this.targetDirectory = pDirectory;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setResourceTargetDirectory(File pDirectory) {
        this.resourceTargetDirectory = pDirectory;
    }

    public File getResourceTargetDirectory() {
        return this.resourceTargetDirectory;
    }

    public SchemaSG generate(InputSource pSource) throws Exception {
        SchemaReader sr = this.getSchemaReader();
        sr.setGenerator(this);
        SchemaSG s = sr.parse(pSource);
        s.generate();
        File targetDir = this.getTargetDirectory();
        File resourceTargetDir = this.getResourceTargetDirectory();
        if (resourceTargetDir == null) {
            resourceTargetDir = targetDir;
        }
        JavaSourceFactory jsf = s.getJavaSourceFactory();
        Iterator iter = jsf.getJavaSources();
        while (iter.hasNext()) {
            ((JavaSource)iter.next()).setForcingFullyQualifiedName(true);
        }
        s.getJavaSourceFactory().write(targetDir, resourceTargetDir);
        return s;
    }

    public SchemaSG generate(File pFile) throws Exception {
        String mName = "generate(File)";
        log.finer("generate(File)", "->", (Object)pFile);
        String path = pFile.getAbsolutePath();
        if (!pFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!pFile.isFile()) {
            throw new FileNotFoundException("Not a file: " + path);
        }
        InputSource isource = new InputSource(new FileInputStream(pFile));
        isource.setSystemId(pFile.toURL().toString());
        SchemaSG s = this.generate(isource);
        log.finer("generate(File)", "<-", (Object)s);
        return s;
    }

    public SchemaSG generate(URL pURL) throws Exception {
        String mName = "generate(URL)";
        log.entering("generate(URL)", (Object)pURL);
        URLConnection conn = pURL.openConnection();
        InputSource isource = new InputSource(conn.getInputStream());
        isource.setSystemId(pURL.toString());
        SchemaSG s = this.generate(isource);
        log.exiting("generate(URL)", (Object)s);
        return s;
    }

    public String getProperty(String pName) {
        return (String)this.properties.get(pName);
    }

    public String getProperty(String pName, String pDefault) {
        String result = (String)this.properties.get(pName);
        return result == null ? pDefault : result;
    }

    public void setProperty(String pName, String pValue) {
        this.properties.put(pName, pValue);
    }

    public String getKey() {
        return Integer.toString(this.nextKey++);
    }

    public void addBindings(InputSource pSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db = dbf.newDocumentBuilder();
        EntityResolver er = this.getEntityResolver();
        if (er != null) {
            db.setEntityResolver(er);
        }
        this.bindings.add(db.parse(pSource));
    }

    public Document[] getBindings() {
        return this.bindings.toArray(new Document[this.bindings.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
    }
}

