/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.ws.jaxme.generator.SchemaReader;
import org.apache.ws.jaxme.generator.impl.GeneratorImpl;
import org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaReader;
import org.xml.sax.InputSource;

public class Main {
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$Main;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$SGFactoryChain;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$SchemaReader;

    public static void Usage(String msg) {
        if (msg != null) {
            System.err.println(msg);
            System.err.println();
        }
        PrintStream ps = System.err;
        ps.println("Usage: " + (class$org$apache$ws$jaxme$generator$Main == null ? (class$org$apache$ws$jaxme$generator$Main = Main.class$("org.apache.ws.jaxme.generator.Main")) : class$org$apache$ws$jaxme$generator$Main).getName() + " <inputfile> [options]");
        ps.println();
        ps.println("Reads a schema definition from the given <inputfile>");
        ps.println("Possible options are:");
        ps.println("  --bindingFile=<filename> Adds an external binding file.");
        ps.println("                           Multiple external binding files may");
        ps.println("                           be used by repeating this option.");
        ps.println("  --force                  Force overwriting files");
        ps.println("  --schemaReader=<class>   Sets the SchemaReader class; defaults to");
        ps.println("                           " + (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader == null ? (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader = Main.class$("org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaReader")) : class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader).getName());
        ps.println("  --sgFactoryChain=<class> Adds an instance of <class> to the");
        ps.println("                           generation process.");
        ps.println("  --logFile=<filename>     Sets a logfile for debugging purposes.");
        ps.println("                           By default System.err is used.");
        ps.println("  --logLevel=<level>       Sets the default logging level.");
        ps.println("                           Possible levels are fatal, error (default),");
        ps.println("                           warn, info and debug");
        ps.println("  --option=<name=value>    Sets the option <name> to the given <value>.");
        ps.println("  --package=<name>         Sets the package of the generated sources to");
        ps.println("                           <name>.");
        ps.println("  --resourceTarget=<dir>   Sets the directory where to generate");
        ps.println("                           resource files. By default, the same directory");
        ps.println("                           is used for Java sources and resource files.");
        ps.println("  --target=<dir>           Sets the directory where to generate Java");
        ps.println("                           sources. By default the current directory");
        ps.println("                           is used.");
        ps.println("  --validating             Turns the XML parsers validation on.");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        File schemaFile = null;
        GeneratorImpl g = new GeneratorImpl();
        String schemaReaderClass = (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader == null ? (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader = Main.class$("org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaReader")) : class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader).getName();
        String target = null;
        String resourceTarget = null;
        String logFile = null;
        String logLevel = null;
        String packageName = null;
        ArrayList sgFactoryChains = new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--")) {
                for (int j = i; j < args.length; ++j) {
                    if (schemaFile != null) {
                        Main.Usage("Only one input file may be specified.");
                    }
                    schemaFile = new File(args[j]);
                }
                break;
            }
            if (arg.startsWith("--")) {
                arg = arg.substring(1);
            }
            if (arg.startsWith("-")) {
                arg = arg.substring(1);
                int optIndex = arg.indexOf(61);
                String opt = null;
                if (optIndex > 0) {
                    opt = arg.substring(optIndex + 1);
                    arg = arg.substring(0, optIndex);
                }
                if (arg.equalsIgnoreCase("bindingFile")) {
                    File f;
                    if (opt == null) {
                        if (i == args.length) {
                            Main.Usage("Missing argument for option " + arg);
                        }
                        opt = args[++i];
                    }
                    if ((f = new File(opt)).isFile()) {
                        try {
                            g.addBindings(new InputSource(f.toURL().toExternalForm()));
                        }
                        catch (Exception e) {
                            System.err.println("The external binding file " + f.getAbsolutePath() + " could not be read: " + e.getMessage());
                            e.printStackTrace();
                            System.exit(1);
                        }
                        continue;
                    }
                    System.err.println("The external binding file " + f.getAbsolutePath() + " does not exist.");
                    System.exit(1);
                    continue;
                }
                if (arg.equalsIgnoreCase("force")) {
                    g.setForcingOverwrite(true);
                    continue;
                }
                if (arg.equalsIgnoreCase("schemaReader")) {
                    if (logLevel != null) {
                        Main.Usage("The option " + arg + " may be used only once.");
                    }
                    if (opt == null) {
                        if (i == args.length) {
                            Main.Usage("Missing argument for option " + arg);
                        }
                        opt = args[++i];
                    }
                    schemaReaderClass = opt;
                    continue;
                }
                if (arg.equalsIgnoreCase("logFile")) {
                    if (logFile != null) {
                        Main.Usage("The option " + arg + " may be used only once.");
                    }
                    if (opt == null) {
                        if (i == args.length) {
                            Main.Usage("Missing argument for option " + arg);
                        }
                        opt = args[++i];
                    }
                    logFile = opt;
                    continue;
                }
                if (arg.equalsIgnoreCase("package")) {
                    if (packageName != null) {
                        Main.Usage("The option " + arg + " may be used only once.");
                    }
                    if (opt == null) {
                        if (i == args.length) {
                            Main.Usage("Missing argument for option " + arg);
                        }
                        opt = args[++i];
                    }
                    packageName = opt;
                    g.setProperty("jaxme.package.name", packageName);
                    continue;
                }
                if (arg.equalsIgnoreCase("logLevel")) {
                    if (logLevel != null) {
                        Main.Usage("The option " + arg + " may be used only once.");
                    }
                    if (opt == null) {
                        if (i == args.length) {
                            Main.Usage("Missing argument for option " + arg);
                        }
                        opt = args[++i];
                    }
                    logLevel = opt;
                    continue;
                }
                if (arg.equalsIgnoreCase("target")) {
                    if (target != null) {
                        Main.Usage("The option " + arg + " may be used only once.");
                    }
                    if (opt == null) {
                        if (i == args.length) {
                            Main.Usage("Missing argument for option " + arg);
                        }
                        opt = args[++i];
                    }
                    target = opt;
                    continue;
                }
                if (arg.equalsIgnoreCase("resourceTarget")) {
                    if (resourceTarget != null) {
                        Main.Usage("The option " + arg + " may be used only once.");
                    }
                    if (opt == null) {
                        if (i == args.length) {
                            Main.Usage("Missing argument for option " + arg);
                        }
                        opt = args[++i];
                    }
                    resourceTarget = opt;
                    continue;
                }
                if (arg.equalsIgnoreCase("option")) {
                    int offset;
                    if (opt == null) {
                        if (i == args.length) {
                            Main.Usage("Missing argument for option " + arg);
                        }
                        opt = args[++i];
                    }
                    if ((offset = opt.indexOf(61)) < 1) {
                        System.err.println("Failed to parse option definition " + opt);
                        System.err.println("Must be like --option=name=value or");
                        System.err.println("--option=name=target=value");
                        System.err.println();
                        Main.Usage(null);
                    }
                    String optName = opt.substring(0, offset);
                    String optValue = opt.substring(offset + 1);
                    g.setProperty(optName, optValue);
                    continue;
                }
                if (arg.equalsIgnoreCase("validating")) {
                    g.setValidating(true);
                    continue;
                }
                if ("sgFactoryChain".equals(arg)) {
                    Class<?> c;
                    block67: {
                        if (opt == null) {
                            if (i == args.length) {
                                Main.Usage("Missing argument for option " + arg);
                            }
                            opt = args[++i];
                        }
                        c = null;
                        try {
                            c = Class.forName(opt);
                        }
                        catch (ClassNotFoundException e) {
                            ClassLoader cl = Thread.currentThread().getContextClassLoader();
                            if (cl != null) {
                                try {
                                    c = cl.loadClass(opt);
                                }
                                catch (ClassNotFoundException f) {
                                    // empty catch block
                                }
                            }
                            if (c == null) break block67;
                            System.err.println("Failed to load class " + opt);
                            System.exit(1);
                        }
                    }
                    if (!(class$org$apache$ws$jaxme$generator$sg$SGFactoryChain == null ? Main.class$("org.apache.ws.jaxme.generator.sg.SGFactoryChain") : class$org$apache$ws$jaxme$generator$sg$SGFactoryChain).isAssignableFrom(c)) {
                        System.err.println("The SGFactoryChain implementation " + c.getName() + " is not implementing " + (class$org$apache$ws$jaxme$generator$sg$SGFactoryChain == null ? Main.class$("org.apache.ws.jaxme.generator.sg.SGFactoryChain") : class$org$apache$ws$jaxme$generator$sg$SGFactoryChain).getName());
                    }
                    sgFactoryChains.add(c);
                    continue;
                }
                if (arg.equalsIgnoreCase("h") || arg.equalsIgnoreCase("help") || arg.equalsIgnoreCase("?")) {
                    Main.Usage(null);
                    continue;
                }
                Main.Usage("Unknown option name: " + arg);
                continue;
            }
            if (schemaFile != null) {
                Main.Usage("Only one input file may be specified.");
                continue;
            }
            schemaFile = new File(args[i]);
        }
        if (schemaFile == null) {
            Main.Usage("A Schema file must be specified");
        }
        SchemaReader sr = null;
        try {
            Class<?> c = Class.forName(schemaReaderClass);
            sr = (SchemaReader)c.newInstance();
            g.setSchemaReader(sr);
            sr.setGenerator(g);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Could not find SchemaReader class " + schemaReaderClass);
            System.exit(1);
        }
        catch (ClassCastException e) {
            System.err.println("Class " + schemaReaderClass + " is not implementing " + (class$org$apache$ws$jaxme$generator$SchemaReader == null ? (class$org$apache$ws$jaxme$generator$SchemaReader = Main.class$("org.apache.ws.jaxme.generator.SchemaReader")) : class$org$apache$ws$jaxme$generator$SchemaReader).getName());
            System.exit(1);
        }
        catch (InstantiationException e) {
            System.err.println("Failed to instantiate SchemaReader class " + schemaReaderClass);
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            System.err.println("Illegal access to SchemaReader class " + schemaReaderClass);
            System.exit(1);
        }
        if (sgFactoryChains.size() > 0) {
            if (!(sr instanceof JAXBSchemaReader)) {
                System.err.println("Additional instances of " + (class$org$apache$ws$jaxme$generator$sg$SGFactoryChain == null ? (class$org$apache$ws$jaxme$generator$sg$SGFactoryChain = Main.class$("org.apache.ws.jaxme.generator.sg.SGFactoryChain")) : class$org$apache$ws$jaxme$generator$sg$SGFactoryChain).getName() + " may be specified only, if the schema reader is an instance of " + (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader == null ? (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader = Main.class$("org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaReader")) : class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader).getName());
                System.exit(1);
            }
            JAXBSchemaReader jsr = (JAXBSchemaReader)sr;
            for (int i = 0; i < sgFactoryChains.size(); ++i) {
                jsr.addSGFactoryChain((Class)sgFactoryChains.get(i));
            }
        }
        if (target != null) {
            g.setTargetDirectory(new File(target));
        }
        if (resourceTarget != null) {
            g.setResourceTargetDirectory(new File(target));
        }
        try {
            g.generate(schemaFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

