/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella.javalib;

import edu.isi.stella.BadArgumentException;
import edu.isi.stella.CalendarDate;
import edu.isi.stella.Cons;
import edu.isi.stella.InputOutputException;
import edu.isi.stella.NoSuchFileException;
import edu.isi.stella.NoSuchObjectException;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.javalib.PrintStringStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Random;

public class Native {
    public static boolean $BREAK_ON_CERROR$ = true;
    public static Random RNG = new Random();

    public static int ceiling(int n) {
        return n;
    }

    public static int ceiling(double n) {
        return (int)Math.ceil(n);
    }

    public static int floor(int n) {
        return n;
    }

    public static int floor(double n) {
        return (int)Math.floor(n);
    }

    public static int round(int n) {
        return n;
    }

    public static int round(double n) {
        return (int)Math.round(n);
    }

    public static int truncate(int n) {
        return n;
    }

    public static int truncate(double n) {
        return (int)n;
    }

    public static double exp(double n) {
        return Math.exp(n);
    }

    public static int integerLength(int x) {
        int ilength = 0;
        if (x < 0) {
            x = -x;
            ++ilength;
        }
        if (((long)x ^ 0xFFFF0000L) != 0L) {
            x >>= 16;
            ilength += 16;
        }
        if ((x ^ 0xFF00) != 0) {
            x >>= 8;
            ilength += 8;
        }
        if ((x ^ 0xF0) != 0) {
            x >>= 4;
            ilength += 4;
        }
        if ((x ^ 0xC) != 0) {
            x >>= 2;
            ilength += 2;
        }
        switch (x) {
            case 0: {
                return ilength;
            }
            case 1: {
                return ilength + 1;
            }
            case 2: 
            case 3: {
                return ilength + 2;
            }
        }
        throw (StellaException)StellaException.newStellaException("Error in integerLength(" + x + "):  Shouldn't get here!").fillInStackTrace();
    }

    public static String makeString(int size, char initialElement) {
        StringBuffer newstring = new StringBuffer(size);
        newstring.setLength(size);
        for (int i = 0; i < size; ++i) {
            newstring.setCharAt(i, initialElement);
        }
        return newstring.toString();
    }

    public static StringBuffer makeMutableString(int size, char initialElement) {
        StringBuffer newstring = new StringBuffer(size);
        newstring.setLength(size);
        for (int i = 0; i < size; ++i) {
            newstring.setCharAt(i, initialElement);
        }
        return newstring;
    }

    public static String stringConcatenate(String string1, String string2) {
        return string1 + string2;
    }

    public static String stringUpcase(String string) {
        return string.toUpperCase();
    }

    public static String stringDowncase(String string) {
        return string.toLowerCase();
    }

    public static String stringCapitalize(String string) {
        StringBuffer newstring = new StringBuffer(Native.stringDowncase(string));
        boolean capitalizeFlag = true;
        for (int i = 0; i < newstring.length(); ++i) {
            if (!Character.isLetter(newstring.charAt(i))) {
                capitalizeFlag = true;
                continue;
            }
            if (!capitalizeFlag) continue;
            newstring.setCharAt(i, Character.toTitleCase(newstring.charAt(i)));
            capitalizeFlag = false;
        }
        return newstring.toString();
    }

    public static String string_copy(String string) {
        return new String(string);
    }

    public static String string_remove(String s, char c) {
        if (s.indexOf(c) == -1) {
            return s;
        }
        char[] original = s.toCharArray();
        char[] culled = new char[s.length()];
        int j = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (original[i] == c) continue;
            culled[j] = original[i];
            ++j;
        }
        return new String(culled, 0, j);
    }

    public static String string_substitute(String self, char newchar, char oldchar) {
        return self.replace(oldchar, newchar);
    }

    public static StringBuffer mutableString_substitute(StringBuffer self, char newchar, char oldchar) {
        for (int i = 0; i < self.length(); ++i) {
            if (self.charAt(i) != oldchar) continue;
            self.setCharAt(i, newchar);
        }
        return self;
    }

    public static boolean string_memberP(String self, char character) {
        return -1 != self.indexOf(character);
    }

    public static char mutableString_nthSetter(StringBuffer self, char c, int pos) {
        self.setCharAt(pos, c);
        return c;
    }

    public static String string_rest(String self) {
        return self.substring(1);
    }

    public static int string_position(String string, char character, int start) {
        int pos = start == Integer.MIN_VALUE ? string.indexOf(character) : string.indexOf(character, start);
        if (pos == -1) {
            return Integer.MIN_VALUE;
        }
        return pos;
    }

    public static int string_lastPosition(String string, char character, int end) {
        int pos = end == Integer.MIN_VALUE ? string.lastIndexOf(character) : string.lastIndexOf(character, end);
        if (pos == -1) {
            return Integer.MIN_VALUE;
        }
        return pos;
    }

    public static int stringSearch(String string, String substring, int start) {
        int pos = start == Integer.MIN_VALUE ? string.indexOf(substring) : string.indexOf(substring, start);
        if (pos > -1) {
            return pos;
        }
        return Integer.MIN_VALUE;
    }

    public static String string_subsequence(String string, int start, int end) {
        if (end == Integer.MIN_VALUE) {
            return string.substring(start);
        }
        return string.substring(start, end);
    }

    public static String mutableString_subsequence(StringBuffer string, int start, int end) {
        if (end == Integer.MIN_VALUE) {
            return string.substring(start);
        }
        return string.substring(start, end);
    }

    public static String stringify_via_print(Stella_Object expression) {
        ByteArrayOutputStream s = new ByteArrayOutputStream(1024);
        PrintStream ps = new PrintStream(s);
        expression.printObject(ps);
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringify(Stella_Object expression) {
        String newstring;
        if (expression == null) {
            return "NULL";
        }
        Object old_printreadablyp = Stella.$PRINTREADABLYp$.get();
        Object old_printprettyp = Stella.$PRINTPRETTYp$.get();
        try {
            Stella.$PRINTREADABLYp$.set(Boolean.TRUE);
            Stella.$PRINTPRETTYp$.set(Boolean.FALSE);
            newstring = Native.stringify_via_print(expression);
        }
        finally {
            Stella.$PRINTREADABLYp$.set(old_printreadablyp);
            Stella.$PRINTPRETTYp$.set(old_printprettyp);
        }
        return newstring;
    }

    public static String integerToString(int i) {
        return Integer.toString(i);
    }

    public static String integerToHexString(int i) {
        return Integer.toHexString(i);
    }

    public static String integerToStringInBase(int i, int base) {
        return Integer.toString(i, base);
    }

    public static String floatToString(double f) {
        return Double.toString(f);
    }

    public static String formatFloat(double v, int n) {
        DecimalFormat formatter = new DecimalFormat();
        formatter.setMinimumFractionDigits(n);
        formatter.setMaximumFractionDigits(n);
        return formatter.format(v);
    }

    public static int stringToInteger(String string) {
        return Integer.parseInt(string);
    }

    public static double stringToFloat(String string) {
        return Double.valueOf(string);
    }

    public static BufferedInputStream openInputFileStream(String filename) {
        try {
            return new BufferedInputStream(new FileInputStream(filename));
        }
        catch (FileNotFoundException e) {
            throw (NoSuchFileException)NoSuchFileException.newNoSuchFileException("openInputFileStream: " + e.getMessage()).fillInStackTrace();
        }
    }

    public static BufferedOutputStream openOutputFileStream(String filename, boolean append) {
        try {
            return new BufferedOutputStream(new FileOutputStream(filename, append));
        }
        catch (IOException e) {
            throw (InputOutputException)InputOutputException.newInputOutputException("openOutputFileStream: " + e.getMessage()).fillInStackTrace();
        }
    }

    public static String readLine(PushbackInputStream stream) {
        DataInputStream s = new DataInputStream(stream);
        try {
            return s.readLine();
        }
        catch (IOException e) {
            throw (InputOutputException)InputOutputException.newInputOutputException("readLine: " + e.getMessage()).fillInStackTrace();
        }
    }

    public static char readCharacter(PushbackInputStream stream, Stella_Object[] return_values) {
        char return_char;
        try {
            int return_int = stream.read();
            if (return_int == -1) {
                return_char = '\u0000';
                return_values[0] = Stella.TRUE_WRAPPER;
            } else {
                return_char = (char)return_int;
                return_values[0] = Stella.FALSE_WRAPPER;
            }
        }
        catch (IOException e) {
            throw (InputOutputException)InputOutputException.newInputOutputException("readCharacter: " + e.getMessage()).fillInStackTrace();
        }
        return return_char;
    }

    public static void unreadCharacter(char c, PushbackInputStream stream) {
        try {
            stream.unread(c);
        }
        catch (IOException e) {
            throw (InputOutputException)InputOutputException.newInputOutputException("unreadCharacter: " + e.getMessage()).fillInStackTrace();
        }
    }

    public static boolean probeFileP(String filename) {
        filename = Stella.translateLogicalPathname(filename);
        return new File(filename).exists();
    }

    public static CalendarDate fileWriteDate(String filename) {
        filename = Stella.translateLogicalPathname(filename);
        return CalendarDate.nativeDateTimeToCalendarDate(new File(filename).lastModified());
    }

    public static int fileLength(String filename) {
        filename = Stella.translateLogicalPathname(filename);
        return (int)new File(filename).length();
    }

    public static void deleteFile(String filename) {
        filename = Stella.translateLogicalPathname(filename);
        new File(filename).delete();
    }

    public static Cons arrayToCons(Stella_Object[] a) {
        Cons c = Stella.NIL;
        for (int i = a.length - 1; i >= 0; --i) {
            c = Cons.cons(a[i], c);
        }
        return c;
    }

    public static Cons arrayToCons(Stella_Object[][] a) {
        Cons c = Stella.NIL;
        for (int i = a.length - 1; i >= 0; --i) {
            c = Cons.cons(Native.arrayToCons(a[i]), c);
        }
        return c;
    }

    public static Object[] consToArray(Cons c) {
        int i = 0;
        Object[] arr = new Object[c.length()];
        Cons iter_000 = c;
        while (iter_000 != Stella.NIL) {
            arr[i] = iter_000.value;
            ++i;
            iter_000 = iter_000.rest;
        }
        return arr;
    }

    public static Object[][] consToArrayArray(Cons c) {
        int i = 0;
        Object[] arr = new Object[c.length()];
        Cons iter_000 = c;
        while (iter_000 != Stella.NIL) {
            arr[i] = Native.consToArray((Cons)iter_000.value);
            ++i;
            iter_000 = iter_000.rest;
        }
        return (Object[][])arr;
    }

    public static String formatArguments(Object[] argArray) {
        StringBuffer args = new StringBuffer(" (");
        for (int i = 0; i < argArray.length; ++i) {
            if (i != 0) {
                args.append(", ");
            }
            args.append(argArray[i]);
        }
        args.append(")");
        return args.toString();
    }

    public static String formatArgumentTypes(Object[] argArray) {
        StringBuffer args = new StringBuffer(" (");
        for (int i = 0; i < argArray.length; ++i) {
            if (i != 0) {
                args.append(", ");
            }
            args.append(argArray[i].getClass());
        }
        args.append(")");
        return args.toString();
    }

    public static Object funcall(Method x, Stella_Object y, Object[] z) {
        try {
            return x.invoke((Object)y, z);
        }
        catch (IllegalAccessException e) {
            if (y == null) {
                throw (StellaException)StellaException.newStellaException("Illegal Java Access in funcall of function:\n  " + x + Native.formatArguments(z)).fillInStackTrace();
            }
            throw (StellaException)StellaException.newStellaException("Illegal Java Access in funcall of:\n  " + x + " on " + y + Native.formatArguments(z)).fillInStackTrace();
        }
        catch (IllegalArgumentException e) {
            if (y == null) {
                throw (StellaException)BadArgumentException.newBadArgumentException("Illegal Java Arguments in funcall of function:\n  " + x + Native.formatArguments(z) + "\n  of types " + Native.formatArgumentTypes(z)).fillInStackTrace();
            }
            throw (StellaException)BadArgumentException.newBadArgumentException("Illegal Java Arguments in funcall of:\n  " + x + " on " + y + Native.formatArguments(z) + "\n  of types " + Native.formatArgumentTypes(z)).fillInStackTrace();
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof StellaException) {
                throw (StellaException)e.getTargetException();
            }
            PrintStringStream msg = new PrintStringStream();
            if (y == null) {
                msg.println("Invocation Target Exception in funcall of function:");
                msg.println("    " + x + Native.formatArguments(z));
            } else {
                msg.println("Invocation Target Exception in funcall of:");
                msg.println("    " + x + " on " + y + Native.formatArguments(z));
            }
            msg.println("    " + e.getTargetException());
            msg.println("    " + e.getTargetException().getMessage());
            e.getTargetException().printStackTrace(msg);
            String errorMessage = msg.toString();
            msg.close();
            throw (StellaException)StellaException.newStellaException(errorMessage).fillInStackTrace();
        }
    }

    public static Class find_java_class(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw (NoSuchObjectException)NoSuchObjectException.newNoSuchObjectException("Can't find class `" + className + "' in find_java_class").fillInStackTrace();
        }
    }

    public static Method find_java_method(String className, String methodName, Class[] parameterTypes) {
        try {
            Method theMethod = Class.forName(className).getDeclaredMethod(methodName, parameterTypes);
            theMethod.setAccessible(true);
            return theMethod;
        }
        catch (ClassNotFoundException e) {
            throw (NoSuchObjectException)NoSuchObjectException.newNoSuchObjectException("Can't find class `" + className + "' in find_java_method").fillInStackTrace();
        }
        catch (NoSuchMethodException e) {
            StringBuffer params = new StringBuffer(" [");
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i != 0) {
                    params.append(", ");
                }
                params.append(parameterTypes[i]);
            }
            params.append("]");
            throw (NoSuchObjectException)NoSuchObjectException.newNoSuchObjectException("Can't find method `" + methodName + "' on `" + className + "' for " + params + " in find_java_method").fillInStackTrace();
        }
    }

    public static long getTicktock() {
        return System.currentTimeMillis();
    }

    public static double ticktockDifference(long t1, long t2) {
        return (double)(t2 - t1) / 1000.0;
    }

    public static double ticktockResolution() {
        return 0.001;
    }

    public static Object setSpecial(ThreadLocal special, Object value) {
        special.set(value);
        return value;
    }

    public static int setIntSpecial(ThreadLocal special, int value) {
        special.set(new Integer(value));
        return value;
    }

    public static long setLongSpecial(ThreadLocal special, long value) {
        special.set(new Long(value));
        return value;
    }

    public static char setCharSpecial(ThreadLocal special, char value) {
        special.set(new Character(value));
        return value;
    }

    public static double setDoubleSpecial(ThreadLocal special, double value) {
        special.set(new Double(value));
        return value;
    }

    public static float setFloatSpecial(ThreadLocal special, float value) {
        special.set(new Float(value));
        return value;
    }

    public static boolean setBooleanSpecial(ThreadLocal special, boolean value) {
        if (value) {
            special.set(Boolean.TRUE);
        } else {
            special.set(Boolean.FALSE);
        }
        return value;
    }

    public static Object getSpecial(ThreadLocal special) {
        return special.get();
    }

    public static int getIntSpecial(ThreadLocal special) {
        Integer value = (Integer)special.get();
        return value == null ? Integer.MIN_VALUE : value;
    }

    public static long getLongSpecial(ThreadLocal special) {
        Long value = (Long)special.get();
        return value == null ? Long.MIN_VALUE : value;
    }

    public static char getCharSpecial(ThreadLocal special) {
        Character value = (Character)special.get();
        return value == null ? (char)'\u0000' : value.charValue();
    }

    public static double getDoubleSpecial(ThreadLocal special) {
        Double value = (Double)special.get();
        return value == null ? Double.NEGATIVE_INFINITY : value;
    }

    public static float getFloatSpecial(ThreadLocal special) {
        Float value = (Float)special.get();
        return value == null ? Float.NEGATIVE_INFINITY : value.floatValue();
    }

    public static boolean getBooleanSpecial(ThreadLocal special) {
        return special.get() == Boolean.TRUE;
    }

    public static void continuableError(String message) {
        if ($BREAK_ON_CERROR$) {
            throw (StellaException)StellaException.newStellaException(message).fillInStackTrace();
        }
        System.err.println(message);
    }

    public static void startupJavaNative() {
    }
}

