/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.GeneralizedSymbol;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;
import edu.isi.stella.javalib.Native;

public class TokenizerTable
extends StandardObject {
    public String transitions;
    public Vector uniqueStateNames;
    public Vector stateNames;
    public Vector legalEofStates;

    public static TokenizerTable newTokenizerTable() {
        TokenizerTable self = null;
        self = new TokenizerTable();
        self.legalEofStates = null;
        self.stateNames = null;
        self.uniqueStateNames = null;
        self.transitions = null;
        return self;
    }

    public static String stringifyTokenizerTable(TokenizerTable table) {
        OutputStringStream result = OutputStringStream.newOutputStringStream();
        int acode = 65;
        String transitions = table.transitions;
        StringBuffer encodedtransitions = Native.makeMutableString(2 * Stella.$MAX_TOKENIZER_STATES$ * Stella.$MAX_TOKENIZER_CHARACTERS$, '\u0000');
        int j = -1;
        Vector uniquestatenames = table.uniqueStateNames;
        Vector statenames = table.stateNames;
        Vector eofstates = table.legalEofStates;
        String separator = "|";
        result.nativeStream.print(2 * Stella.$MAX_TOKENIZER_STATES$ * Stella.$MAX_TOKENIZER_CHARACTERS$ + separator);
        int i = Integer.MIN_VALUE;
        int iter000 = 0;
        int upperBound000 = Stella.$MAX_TOKENIZER_STATES$ * Stella.$MAX_TOKENIZER_CHARACTERS$ - 1;
        while (iter000 <= upperBound000) {
            i = iter000++;
            Native.mutableString_nthSetter(encodedtransitions, (char)((transitions.charAt(i) & 0xF) + acode), ++j);
            Native.mutableString_nthSetter(encodedtransitions, (char)((transitions.charAt(i) >> 4) + acode), ++j);
        }
        result.nativeStream.print(encodedtransitions.toString() + separator);
        result.nativeStream.print(uniquestatenames.length() + separator);
        Stella_Object state = null;
        Vector vector000 = uniquestatenames;
        int length000 = vector000.length();
        for (int index000 = 0; index000 < length000; ++index000) {
            state = (GeneralizedSymbol)vector000.theArray[index000];
            result.nativeStream.print(state.symbolName + separator);
        }
        result.nativeStream.print(statenames.length() + separator);
        state = null;
        Vector vector001 = statenames;
        int length001 = vector001.length();
        for (int index001 = 0; index001 < length001; ++index001) {
            state = (GeneralizedSymbol)vector001.theArray[index001];
            result.nativeStream.print(state.symbolName + separator);
        }
        result.nativeStream.print(eofstates.length() + separator);
        state = null;
        Vector vector002 = eofstates;
        int length002 = vector002.length();
        for (int index002 = 0; index002 < length002; ++index002) {
            state = (BooleanWrapper)vector002.theArray[index002];
            result.nativeStream.print(BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)state) ? "T" : "F");
        }
        result.nativeStream.print(separator);
        return result.theStringReader();
    }

    public static Stella_Object accessTokenizerTableSlotValue(TokenizerTable self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_TRANSITIONS) {
            if (setvalueP) {
                self.transitions = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.transitions);
            }
        } else if (slotname == Stella.SYM_STELLA_UNIQUE_STATE_NAMES) {
            if (setvalueP) {
                self.uniqueStateNames = (Vector)value;
            } else {
                value = self.uniqueStateNames;
            }
        } else if (slotname == Stella.SYM_STELLA_STATE_NAMES) {
            if (setvalueP) {
                self.stateNames = (Vector)value;
            } else {
                value = self.stateNames;
            }
        } else if (slotname == Stella.SYM_STELLA_LEGAL_EOF_STATES) {
            if (setvalueP) {
                self.legalEofStates = (Vector)value;
            } else {
                value = self.legalEofStates;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        TokenizerTable self = this;
        return Stella.SGT_STELLA_TOKENIZER_TABLE;
    }
}

