/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.CalendarDate;
import edu.isi.stella.DateTimeObject;
import edu.isi.stella.DecodedTimeDuration;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.IncompatibleQuantityException;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Quantity;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class TimeDuration
extends DateTimeObject {
    public int days;
    public int millis;

    public static TimeDuration makeTimeDuration(int days, int millis) {
        while (millis < 0 - Stella.MILLIS_PER_DAY) {
            millis += Stella.MILLIS_PER_DAY;
            --days;
        }
        while (millis > Stella.MILLIS_PER_DAY) {
            millis -= Stella.MILLIS_PER_DAY;
            ++days;
        }
        if (days < 0) {
            if (millis > 0) {
                ++days;
                millis -= Stella.MILLIS_PER_DAY;
            }
        } else if (days > 0 && millis < 0) {
            --days;
            millis += Stella.MILLIS_PER_DAY;
        }
        TimeDuration self000 = TimeDuration.newTimeDuration();
        self000.days = days;
        self000.millis = millis;
        TimeDuration value000 = self000;
        return value000;
    }

    public static TimeDuration stringToTimeDuration(String duration) {
        int nDays = 0;
        int nMillis = 0;
        boolean negativeP = Native.stringSearch(duration, "minus", 0) != Integer.MIN_VALUE;
        int dayStartPosition = 0;
        int dayEndPosition = 0;
        int msStartPosition = 0;
        int msEndPosition = 0;
        dayStartPosition = negativeP ? 6 : (Native.stringSearch(duration, "plus", 0) != Integer.MIN_VALUE ? 5 : 0);
        dayEndPosition = Native.stringSearch(duration, "days", dayStartPosition);
        if (dayEndPosition == Integer.MIN_VALUE) {
            return null;
        }
        nDays = Native.stringToInteger(Native.string_subsequence(duration, dayStartPosition, dayEndPosition - 1));
        msStartPosition = Native.string_position(duration, ' ', dayEndPosition);
        if (msStartPosition != Integer.MIN_VALUE && (msEndPosition = Native.stringSearch(duration, "ms", msStartPosition)) != Integer.MIN_VALUE) {
            nMillis = Native.stringToInteger(Native.string_subsequence(duration, msStartPosition, msEndPosition - 1));
        }
        if (negativeP) {
            return TimeDuration.makeTimeDuration(0 - nDays, 0 - nMillis);
        }
        return TimeDuration.makeTimeDuration(nDays, nMillis);
    }

    public static TimeDuration newTimeDuration() {
        TimeDuration self = null;
        self = new TimeDuration();
        self.millis = Integer.MIN_VALUE;
        self.days = Integer.MIN_VALUE;
        return self;
    }

    public boolean greaterEqualP(Stella_Object t2) {
        TimeDuration t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_TIME_DURATION)) {
            TimeDuration t2000 = (TimeDuration)t2;
            if (t1.days == t2000.days) {
                return t1.millis >= t2000.millis;
            }
            return t1.days >= t2000.days;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't compare calendar date `" + t1 + "' with object `" + t2 + "'");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public boolean lessEqualP(Stella_Object t2) {
        TimeDuration t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_TIME_DURATION)) {
            TimeDuration t2000 = (TimeDuration)t2;
            if (t1.days == t2000.days) {
                return t1.millis <= t2000.millis;
            }
            return t1.days <= t2000.days;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't compare calendar date `" + t1 + "' with object `" + t2 + "'");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public boolean greaterP(Stella_Object t2) {
        TimeDuration t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_TIME_DURATION)) {
            TimeDuration t2000 = (TimeDuration)t2;
            if (t1.days == t2000.days) {
                return t1.millis > t2000.millis;
            }
            return t1.days > t2000.days;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't compare calendar date `" + t1 + "' with object `" + t2 + "'");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public boolean lessP(Stella_Object t2) {
        TimeDuration t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_TIME_DURATION)) {
            TimeDuration t2000 = (TimeDuration)t2;
            if (t1.days == t2000.days) {
                return t1.millis < t2000.millis;
            }
            return t1.days < t2000.days;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't compare calendar date `" + t1 + "' with object `" + t2 + "'");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public boolean objectEqlP(Stella_Object t2) {
        TimeDuration t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_TIME_DURATION)) {
            TimeDuration t2000 = (TimeDuration)t2;
            if (t1.days == t2000.days) {
                return t1.millis == t2000.millis;
            }
            return t1.days == t2000.days;
        }
        return false;
    }

    public static Stella_Object timeDivide(TimeDuration t1, Stella_Object t2) {
        Surrogate testValue000 = Stella_Object.safePrimaryType(t2);
        if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_CALENDAR_DATE)) {
            CalendarDate t2000 = (CalendarDate)t2;
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("Calendar dates cannot be involved in division:  `" + t1 + "'  `" + t2000 + "'");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_TIME_DURATION)) {
            TimeDuration t2000 = (TimeDuration)t2;
            return FloatWrapper.wrapFloat(((double)t1.days + (double)t1.millis / (double)Stella.MILLIS_PER_DAY) / ((double)t2000.days + (double)t2000.millis / (double)Stella.MILLIS_PER_DAY));
        }
        if (Surrogate.subtypeOfIntegerP(testValue000)) {
            IntegerWrapper t2000 = (IntegerWrapper)t2;
            return TimeDuration.makeTimeDuration(Native.round((double)t1.days / (double)t2000.wrapperValue), Native.round((double)t1.millis / (double)t2000.wrapperValue));
        }
        if (Surrogate.subtypeOfFloatP(testValue000)) {
            FloatWrapper t2000 = (FloatWrapper)t2;
            return TimeDuration.makeTimeDuration(Native.round((double)t1.days / t2000.wrapperValue), Native.round((double)t1.millis / t2000.wrapperValue));
        }
        OutputStringStream stream001 = OutputStringStream.newOutputStringStream();
        stream001.nativeStream.print("`" + testValue000 + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException(stream001.theStringReader()).fillInStackTrace();
    }

    public DecodedTimeDuration decodeTimeDuration() {
        TimeDuration duration = this;
        if (duration.millis > 0) {
            DecodedTimeDuration self000 = DecodedTimeDuration.newDecodedTimeDuration();
            self000.durationDays = duration.days;
            self000.durationHours = duration.millis / Stella.MILLIS_PER_HOUR;
            self000.durationMinutes = duration.millis % Stella.MILLIS_PER_HOUR / 60000;
            self000.durationSeconds = duration.millis % 60000 / 1000;
            self000.durationMillis = duration.millis % 1000;
            DecodedTimeDuration value000 = self000;
            return value000;
        }
        DecodedTimeDuration self001 = DecodedTimeDuration.newDecodedTimeDuration();
        self001.durationDays = duration.days;
        self001.durationHours = 0 - (0 - duration.millis) / Stella.MILLIS_PER_HOUR;
        self001.durationMinutes = 0 - (0 - duration.millis) % Stella.MILLIS_PER_HOUR / 60000;
        self001.durationSeconds = 0 - (0 - duration.millis) % 60000 / 1000;
        self001.durationMillis = 0 - (0 - duration.millis) % 1000;
        DecodedTimeDuration value001 = self001;
        return value001;
    }

    public void printTimeDuration(PrintStream stream) {
        TimeDuration date = this;
        stream.print("<" + date.timeDurationToString() + ">");
    }

    public String timeDurationToString() {
        TimeDuration date = this;
        int nDays = date.days;
        int nMillis = date.millis;
        if (nDays < 0) {
            if (nMillis <= 0) {
                return "minus " + Native.integerToString(0 - nDays) + " days; " + Native.integerToString(0 - nMillis) + " ms";
            }
            return "minus " + Native.integerToString(0 - (nDays + 1)) + " days; " + Native.integerToString(Stella.MILLIS_PER_DAY - nMillis) + " ms";
        }
        if (nMillis < 0) {
            if (nDays > 0) {
                return "plus " + Native.integerToString(nDays - 1) + " days; " + Native.integerToString(Stella.MILLIS_PER_DAY + nMillis) + " ms";
            }
            return "minus 0 days; " + Native.integerToString(0 - nMillis) + " ms";
        }
        return "plus " + Native.integerToString(nDays) + " days; " + Native.integerToString(nMillis) + " ms";
    }

    public int hashCode_() {
        TimeDuration self = this;
        return self.days ^ self.millis;
    }

    public Quantity coerceTo(Stella_Object y) {
        TimeDuration x = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(y), Stella.SGT_STELLA_TIME_DURATION)) {
            TimeDuration y000 = (TimeDuration)y;
            return y000;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't coerce `" + y + "' to a TIME-DURATION");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public void printObject(PrintStream stream) {
        TimeDuration self = this;
        self.printTimeDuration(stream);
    }

    public static Stella_Object accessTimeDurationSlotValue(TimeDuration self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_DAYS) {
            if (setvalueP) {
                self.days = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.days);
            }
        } else if (slotname == Stella.SYM_STELLA_MILLIS) {
            if (setvalueP) {
                self.millis = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.millis);
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        TimeDuration self = this;
        return Stella.SGT_STELLA_TIME_DURATION;
    }
}

