/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.Cons;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Interval;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class TaxonomyNode
extends StandardObject {
    public Stella_Object nativeObject;
    public int label;
    public Cons intervals;
    public Interval initialInterval;
    public int firstIntervalLowerBound;
    public int firstIntervalUpperBound;
    public Cons parents;
    public Cons children;
    public int totalAncestors;
    public Cons treeChildren;
    public Stella_Object marker;

    public static TaxonomyNode newTaxonomyNode() {
        TaxonomyNode self = null;
        self = new TaxonomyNode();
        self.marker = null;
        self.treeChildren = Stella.NIL;
        self.totalAncestors = 1;
        self.children = Stella.NIL;
        self.parents = Stella.NIL;
        self.firstIntervalUpperBound = -1;
        self.firstIntervalLowerBound = -1;
        self.initialInterval = null;
        self.intervals = Stella.NIL;
        self.label = Integer.MIN_VALUE;
        self.nativeObject = null;
        return self;
    }

    public static void printTaxonomySpanningTree(TaxonomyNode node, int indent, OutputStream stream) {
        boolean unboundedP000;
        int i = Integer.MIN_VALUE;
        int upperBound000 = indent;
        boolean bl = unboundedP000 = upperBound000 == Integer.MIN_VALUE;
        for (int iter000 = 1; unboundedP000 || iter000 <= upperBound000; ++iter000) {
            i = iter000;
            stream.nativeStream.print(" ");
        }
        stream.nativeStream.println(node);
        TaxonomyNode child = null;
        Cons iter001 = node.treeChildren;
        while (iter001 != Stella.NIL) {
            child = (TaxonomyNode)iter001.value;
            TaxonomyNode.printTaxonomySpanningTree(child, indent + 2, stream);
            iter001 = iter001.rest;
        }
    }

    public static void printTaxonomyTree(TaxonomyNode node, int indent, OutputStream stream) {
        boolean unboundedP000;
        int i = Integer.MIN_VALUE;
        int upperBound000 = indent;
        boolean bl = unboundedP000 = upperBound000 == Integer.MIN_VALUE;
        for (int iter000 = 1; unboundedP000 || iter000 <= upperBound000; ++iter000) {
            i = iter000;
            stream.nativeStream.print(" ");
        }
        stream.nativeStream.println(node);
        TaxonomyNode child = null;
        Cons iter001 = node.children;
        while (iter001 != Stella.NIL) {
            child = (TaxonomyNode)iter001.value;
            TaxonomyNode.printTaxonomyTree(child, indent + 2, stream);
            iter001 = iter001.rest;
        }
    }

    public static boolean slowTaxonomySubnodeOfP(TaxonomyNode subnode, TaxonomyNode supernode) {
        if (subnode == supernode) {
            return true;
        }
        TaxonomyNode parent = null;
        Cons iter000 = subnode.parents;
        while (iter000 != Stella.NIL) {
            parent = (TaxonomyNode)iter000.value;
            if (TaxonomyNode.slowTaxonomySubnodeOfP(parent, supernode)) {
                return true;
            }
            iter000 = iter000.rest;
        }
        return false;
    }

    public static boolean taxonomySubnodeOfP(TaxonomyNode subNode, TaxonomyNode superNode) {
        int subNodeLabel = subNode.label;
        Interval interval = null;
        Cons iter000 = superNode.intervals;
        while (iter000 != Stella.NIL) {
            interval = (Interval)iter000.value;
            if (subNodeLabel >= interval.lowerBound && subNodeLabel <= interval.upperBound) {
                return true;
            }
            iter000 = iter000.rest;
        }
        return false;
    }

    public static void computeTotalAncestors(TaxonomyNode node) {
        TaxonomyNode.uncomputeTotalAncestors(node);
        TaxonomyNode.helpComputeTotalAncestors(node);
    }

    public static void helpComputeTotalAncestors(TaxonomyNode node) {
        if (node.totalAncestors >= 0) {
            return;
        }
        int totalancestors = 0;
        int parentancestors = 0;
        TaxonomyNode parent = null;
        Cons iter000 = node.parents;
        while (iter000 != Stella.NIL) {
            parent = (TaxonomyNode)iter000.value;
            parentancestors = parent.totalAncestors;
            if (parentancestors < 0) {
                return;
            }
            totalancestors += parentancestors;
            iter000 = iter000.rest;
        }
        node.totalAncestors = totalancestors + 1;
        TaxonomyNode child = null;
        Cons iter001 = node.children;
        while (iter001 != Stella.NIL) {
            child = (TaxonomyNode)iter001.value;
            TaxonomyNode.helpComputeTotalAncestors(child);
            iter001 = iter001.rest;
        }
    }

    public static void uncomputeTotalAncestors(TaxonomyNode node) {
        if (node.totalAncestors < 0) {
            return;
        }
        node.totalAncestors = -1;
        TaxonomyNode child = null;
        Cons iter000 = node.children;
        while (iter000 != Stella.NIL) {
            child = (TaxonomyNode)iter000.value;
            TaxonomyNode.uncomputeTotalAncestors(child);
            iter000 = iter000.rest;
        }
    }

    public static void propagateForeignInterval(TaxonomyNode node, Interval interval) {
        if (node.marker == interval) {
            return;
        }
        node.marker = interval;
        if (TaxonomyNode.adjoinTaxonomyNodeIntervalP(node, interval)) {
            TaxonomyNode parent = null;
            Cons iter000 = node.parents;
            while (iter000 != Stella.NIL) {
                parent = (TaxonomyNode)iter000.value;
                TaxonomyNode.propagateForeignInterval(parent, interval);
                iter000 = iter000.rest;
            }
        }
    }

    public static boolean adjoinTaxonomyNodeIntervalP(TaxonomyNode node, Interval interval) {
        Cons intervalstoremove = Stella.NIL;
        Stella_Object renamed_Int = null;
        Cons iter000 = node.intervals;
        while (iter000 != Stella.NIL) {
            renamed_Int = (Interval)iter000.value;
            if (renamed_Int.lowerBound < interval.lowerBound) {
                if (renamed_Int.upperBound >= interval.upperBound) {
                    return false;
                }
                if (interval.lowerBound <= renamed_Int.upperBound + 1) {
                    TaxonomyNode.removeTaxonomyNodeInterval(node, renamed_Int);
                    TaxonomyNode.adjoinTaxonomyNodeIntervalP(node, Interval.mergeIntervals(renamed_Int, interval));
                    return true;
                }
            } else if (interval.upperBound >= renamed_Int.upperBound) {
                intervalstoremove = Stella_Object.cons(renamed_Int, intervalstoremove);
            } else if (renamed_Int.lowerBound <= interval.upperBound + 1) {
                TaxonomyNode.removeTaxonomyNodeInterval(node, renamed_Int);
                TaxonomyNode.adjoinTaxonomyNodeIntervalP(node, Interval.mergeIntervals(interval, renamed_Int));
                return true;
            }
            iter000 = iter000.rest;
        }
        renamed_Int = null;
        Cons iter001 = intervalstoremove;
        while (iter001 != Stella.NIL) {
            renamed_Int = iter001.value;
            TaxonomyNode.removeTaxonomyNodeInterval(node, renamed_Int);
            iter001 = iter001.rest;
        }
        TaxonomyNode.addTaxonomyNodeInterval(node, interval);
        return true;
    }

    public static void removeTaxonomyNodeInterval(TaxonomyNode node, Interval interval) {
        Cons intervals = node.intervals;
        node.intervals = intervals.remove(interval);
        if ((intervals = node.intervals) == Stella.NIL) {
            node.firstIntervalLowerBound = -1;
            node.firstIntervalUpperBound = -1;
        } else {
            node.firstIntervalLowerBound = ((Interval)intervals.value).lowerBound;
            node.firstIntervalUpperBound = ((Interval)intervals.value).upperBound;
        }
    }

    public static void addTaxonomyNodeInterval(TaxonomyNode node, Interval interval) {
        node.intervals = Stella_Object.cons(interval, node.intervals);
        node.firstIntervalLowerBound = interval.lowerBound;
        node.firstIntervalUpperBound = interval.upperBound;
    }

    public static Interval internTaxonomyNodeInterval(TaxonomyNode node, int lowerbound, int upperbound) {
        Interval self000 = Interval.newInterval();
        self000.lowerBound = lowerbound;
        self000.upperBound = upperbound;
        Interval interval = self000;
        TaxonomyNode.addTaxonomyNodeInterval(node, interval);
        return interval;
    }

    public static Cons allTaxonomyNodeIntervals(TaxonomyNode node) {
        return node.intervals;
    }

    public static int helpCreateTaxonomyTreeIntervals(TaxonomyNode self) {
        int minchildlabel = Integer.MIN_VALUE;
        int mylabel = Integer.MIN_VALUE;
        int prevpostnumber = (Integer)Stella.$TAXONOMY_POSTORDER_NUMBER$.get();
        if (self.treeChildren != Stella.NIL) {
            minchildlabel = TaxonomyNode.helpCreateTaxonomyTreeIntervals((TaxonomyNode)self.treeChildren.value);
        }
        TaxonomyNode child = null;
        Cons iter000 = self.treeChildren.rest;
        while (iter000 != Stella.NIL) {
            child = (TaxonomyNode)iter000.value;
            TaxonomyNode.helpCreateTaxonomyTreeIntervals(child);
            iter000 = iter000.rest;
        }
        Native.setIntSpecial(Stella.$TAXONOMY_POSTORDER_NUMBER$, (Integer)Stella.$TAXONOMY_POSTORDER_NUMBER$.get() + Stella.$NUMBERING_INTERVAL$);
        mylabel = (Integer)Stella.$TAXONOMY_POSTORDER_NUMBER$.get();
        if (self.treeChildren == Stella.NIL) {
            minchildlabel = prevpostnumber + 1;
        }
        self.initialInterval = TaxonomyNode.internTaxonomyNodeInterval(self, minchildlabel, mylabel);
        self.label = mylabel;
        return minchildlabel;
    }

    public static void helpClearTaxonomyGraph(TaxonomyNode node) {
        if (node.label != Integer.MIN_VALUE) {
            TaxonomyNode.clearTaxonomyNode(node);
            TaxonomyNode child = null;
            Cons iter000 = node.children;
            while (iter000 != Stella.NIL) {
                child = (TaxonomyNode)iter000.value;
                TaxonomyNode.helpClearTaxonomyGraph(child);
                iter000 = iter000.rest;
            }
        }
    }

    public static void initializeTaxonomyNode(TaxonomyNode node) {
        TaxonomyNode.clearTaxonomyNode(node);
        node.parents = Stella.NIL;
        node.children = Stella.NIL;
        node.nativeObject = null;
    }

    public static void clearTaxonomyNode(TaxonomyNode node) {
        node.label = Integer.MIN_VALUE;
        node.intervals = Stella.NIL;
        node.initialInterval = null;
        node.firstIntervalLowerBound = -1;
        node.firstIntervalUpperBound = -1;
        node.treeChildren = Stella.NIL;
        node.totalAncestors = 1;
    }

    public boolean deletedPSetter(boolean value) {
        TaxonomyNode self = this;
        self.label = value ? -99 : Integer.MIN_VALUE;
        return value;
    }

    public boolean deletedP() {
        TaxonomyNode self = this;
        return self.label == -99;
    }

    public static boolean labeledTaxonomyNodeP(TaxonomyNode node) {
        return node.label != Integer.MIN_VALUE;
    }

    public static Interval allocateIntervalForNewLeafNode(TaxonomyNode parent) {
        Interval parentinterval = parent.initialInterval;
        if (parent.treeChildren == Stella.NIL) {
            if (parentinterval.lowerBound == parentinterval.upperBound) {
                return null;
            }
            Interval self000 = Interval.newInterval();
            self000.lowerBound = parentinterval.lowerBound;
            self000.upperBound = Native.floor((double)(parentinterval.lowerBound + parentinterval.upperBound) / 2.0);
            Interval value000 = self000;
            return value000;
        }
        TaxonomyNode rightchild = (TaxonomyNode)parent.treeChildren.last();
        Interval rightchildinterval = rightchild.initialInterval;
        if (rightchildinterval.upperBound >= parentinterval.upperBound - 1) {
            return null;
        }
        Interval self001 = Interval.newInterval();
        self001.lowerBound = rightchildinterval.upperBound + 1;
        self001.upperBound = Native.ceiling((double)(parentinterval.upperBound + rightchildinterval.upperBound) / 2.0);
        Interval value001 = self001;
        return value001;
    }

    public static boolean taxonomyRootP(TaxonomyNode node) {
        return node.parents == Stella.NIL;
    }

    public void printObject(PrintStream stream) {
        TaxonomyNode self = this;
        stream.print("|TN|" + self.label + " " + self.intervals + " " + self.nativeObject);
    }

    public static Stella_Object accessTaxonomyNodeSlotValue(TaxonomyNode self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_NATIVE_OBJECT) {
            if (setvalueP) {
                self.nativeObject = value;
            } else {
                value = self.nativeObject;
            }
        } else if (slotname == Stella.SYM_STELLA_LABEL) {
            if (setvalueP) {
                self.label = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.label);
            }
        } else if (slotname == Stella.SYM_STELLA_INTERVALS) {
            if (setvalueP) {
                self.intervals = (Cons)value;
            } else {
                value = self.intervals;
            }
        } else if (slotname == Stella.SYM_STELLA_INITIAL_INTERVAL) {
            if (setvalueP) {
                self.initialInterval = (Interval)value;
            } else {
                value = self.initialInterval;
            }
        } else if (slotname == Stella.SYM_STELLA_FIRST_INTERVAL_LOWER_BOUND) {
            if (setvalueP) {
                self.firstIntervalLowerBound = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.firstIntervalLowerBound);
            }
        } else if (slotname == Stella.SYM_STELLA_FIRST_INTERVAL_UPPER_BOUND) {
            if (setvalueP) {
                self.firstIntervalUpperBound = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.firstIntervalUpperBound);
            }
        } else if (slotname == Stella.SYM_STELLA_PARENTS) {
            if (setvalueP) {
                self.parents = (Cons)value;
            } else {
                value = self.parents;
            }
        } else if (slotname == Stella.SYM_STELLA_CHILDREN) {
            if (setvalueP) {
                self.children = (Cons)value;
            } else {
                value = self.children;
            }
        } else if (slotname == Stella.SYM_STELLA_TOTAL_ANCESTORS) {
            if (setvalueP) {
                self.totalAncestors = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.totalAncestors);
            }
        } else if (slotname == Stella.SYM_STELLA_TREE_CHILDREN) {
            if (setvalueP) {
                self.treeChildren = (Cons)value;
            } else {
                value = self.treeChildren;
            }
        } else if (slotname == Stella.SYM_STELLA_MARKER) {
            if (setvalueP) {
                self.marker = value;
            } else {
                value = self.marker;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        TaxonomyNode self = this;
        return Stella.SGT_STELLA_TAXONOMY_NODE;
    }
}

