/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.AllPurposeIterator;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Interval;
import edu.isi.stella.Iterator;
import edu.isi.stella.List;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.TaxonomyNode;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class TaxonomyGraph
extends StandardObject {
    public boolean renumberIfOutOfNumbersP;
    public double renumberRatio;
    public boolean incrementalModeP;
    public int largestPostorderNumber;
    public int numberOfNodes;
    public int numberOfForeignIntervalNodes;
    public List roots;
    public List brokenLinks;
    public List addedLinks;
    public List removedLinks;

    public static TaxonomyGraph newTaxonomyGraph() {
        TaxonomyGraph self = null;
        self = new TaxonomyGraph();
        self.removedLinks = null;
        self.addedLinks = null;
        self.brokenLinks = null;
        self.roots = null;
        self.numberOfForeignIntervalNodes = Integer.MIN_VALUE;
        self.numberOfNodes = Integer.MIN_VALUE;
        self.largestPostorderNumber = Integer.MIN_VALUE;
        self.incrementalModeP = false;
        self.renumberRatio = 0.1;
        self.renumberIfOutOfNumbersP = false;
        TaxonomyGraph.initializeTaxonomyGraph(self);
        return self;
    }

    public static void printTaxonomySpanningForest(TaxonomyGraph graph, OutputStream stream) {
        TaxonomyNode root = null;
        Cons iter000 = graph.roots.theConsList;
        while (iter000 != Stella.NIL) {
            root = (TaxonomyNode)iter000.value;
            TaxonomyNode.printTaxonomySpanningTree(root, 0, stream);
            stream.nativeStream.println();
            iter000 = iter000.rest;
        }
    }

    public static void printTaxonomyGraph(TaxonomyGraph graph, OutputStream stream) {
        TaxonomyNode root = null;
        Cons iter000 = graph.roots.theConsList;
        while (iter000 != Stella.NIL) {
            root = (TaxonomyNode)iter000.value;
            TaxonomyNode.printTaxonomyTree(root, 0, stream);
            stream.nativeStream.println();
            iter000 = iter000.rest;
        }
    }

    public static void finalizeTaxonomyGraphNonincrementally(TaxonomyGraph graph) {
        graph.incrementalModeP = false;
        TaxonomyGraph.finalizeTaxonomyGraph(graph);
    }

    public static void finalizeTaxonomyGraph(TaxonomyGraph graph) {
        if (graph.incrementalModeP && graph.numberOfNodes > 0 && (double)Stella.max(graph.numberOfForeignIntervalNodes, graph.addedLinks.length()) / (double)graph.numberOfNodes < graph.renumberRatio) {
            Cons link = null;
            Cons iter000 = graph.addedLinks.theConsList;
            while (iter000 != Stella.NIL) {
                link = (Cons)iter000.value;
                TaxonomyGraph.incrementallyLinkTaxonomyNodes(graph, (TaxonomyNode)link.value, (TaxonomyNode)link.rest.value);
                iter000 = iter000.rest;
            }
            graph.addedLinks.clear();
        } else {
            graph.incrementalModeP = false;
            Cons link = null;
            Cons iter001 = graph.addedLinks.theConsList;
            while (iter001 != Stella.NIL) {
                link = (Cons)iter001.value;
                TaxonomyGraph.linkTaxonomyNodes(graph, (TaxonomyNode)link.value, (TaxonomyNode)link.rest.value);
                iter001 = iter001.rest;
            }
            graph.addedLinks.clear();
            TaxonomyGraph.createTaxonomySpanningForest(graph);
        }
    }

    public static void createTaxonomySpanningForest(TaxonomyGraph graph) {
        TaxonomyGraph.clearTaxonomyGraph(graph);
        graph.incrementalModeP = false;
        TaxonomyNode root = null;
        Cons iter000 = graph.roots.theConsList;
        while (iter000 != Stella.NIL) {
            root = (TaxonomyNode)iter000.value;
            TaxonomyNode.computeTotalAncestors(root);
            TaxonomyGraph.createTaxonomySpanningTree(graph, root);
            iter000 = iter000.rest;
        }
        TaxonomyGraph.createTaxonomyTreeIntervals(graph);
        Cons link = null;
        Cons iter001 = graph.brokenLinks.theConsList;
        while (iter001 != Stella.NIL) {
            link = (Cons)iter001.value;
            TaxonomyNode.propagateForeignInterval((TaxonomyNode)link.value, ((TaxonomyNode)link.rest.value).initialInterval);
            iter001 = iter001.rest;
        }
        graph.brokenLinks.clear();
        graph.incrementalModeP = true;
    }

    public static void createTaxonomySpanningTree(TaxonomyGraph graph, TaxonomyNode node) {
        if (node.label != Integer.MIN_VALUE) {
            return;
        }
        node.label = -99;
        TaxonomyNode maxparent = null;
        int maxparentvalue = Integer.MIN_VALUE;
        TaxonomyNode parent = null;
        Cons iter000 = node.parents;
        while (iter000 != Stella.NIL) {
            parent = (TaxonomyNode)iter000.value;
            if (maxparentvalue == Integer.MIN_VALUE || parent.totalAncestors > maxparentvalue) {
                maxparent = parent;
                maxparentvalue = parent.totalAncestors;
            }
            iter000 = iter000.rest;
        }
        parent = null;
        Cons iter001 = node.parents;
        while (iter001 != Stella.NIL) {
            parent = (TaxonomyNode)iter001.value;
            if (parent == maxparent) {
                parent.treeChildren = Stella_Object.cons(node, parent.treeChildren);
            } else {
                graph.brokenLinks.push(Stella_Object.cons(parent, Stella_Object.cons(node, Stella.NIL)));
            }
            iter001 = iter001.rest;
        }
        TaxonomyNode child = null;
        Cons iter002 = node.children;
        while (iter002 != Stella.NIL) {
            child = (TaxonomyNode)iter002.value;
            TaxonomyGraph.createTaxonomySpanningTree(graph, child);
            iter002 = iter002.rest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTaxonomyTreeIntervals(TaxonomyGraph graph) {
        Object old$TaxonomyPostorderNumber$000 = Stella.$TAXONOMY_POSTORDER_NUMBER$.get();
        try {
            Native.setIntSpecial(Stella.$TAXONOMY_POSTORDER_NUMBER$, 0);
            TaxonomyNode root = null;
            Cons iter000 = graph.roots.theConsList;
            while (iter000 != Stella.NIL) {
                root = (TaxonomyNode)iter000.value;
                TaxonomyNode.helpCreateTaxonomyTreeIntervals(root);
                iter000 = iter000.rest;
            }
            graph.largestPostorderNumber = (Integer)Stella.$TAXONOMY_POSTORDER_NUMBER$.get();
        }
        finally {
            Stella.$TAXONOMY_POSTORDER_NUMBER$.set(old$TaxonomyPostorderNumber$000);
        }
    }

    public static void initializeTaxonomyGraph(TaxonomyGraph graph) {
        graph.incrementalModeP = false;
        graph.renumberIfOutOfNumbersP = false;
        graph.largestPostorderNumber = 0;
        graph.numberOfNodes = 0;
        graph.numberOfForeignIntervalNodes = 0;
        graph.renumberRatio = 0.1;
        graph.roots = List.newList();
        graph.brokenLinks = List.newList();
        graph.addedLinks = List.newList();
        graph.removedLinks = List.newList();
    }

    public static void clearTaxonomyGraph(TaxonomyGraph graph) {
        TaxonomyNode root = null;
        Cons iter000 = graph.roots.removeDeletedMembers().theConsList;
        while (iter000 != Stella.NIL) {
            root = (TaxonomyNode)iter000.value;
            TaxonomyNode.helpClearTaxonomyGraph(root);
            iter000 = iter000.rest;
        }
        graph.incrementalModeP = false;
        graph.numberOfForeignIntervalNodes = 0;
        graph.brokenLinks.clear();
    }

    public static TaxonomyNode findTaxonomyNode(TaxonomyGraph graph, int label) {
        TaxonomyNode node = null;
        Iterator iter000 = TaxonomyGraph.allTaxonomyNodes(graph);
        while (iter000.nextP()) {
            node = (TaxonomyNode)iter000.value;
            if (node.label != label) continue;
            return node;
        }
        return null;
    }

    public static Iterator allTaxonomyNodes(TaxonomyGraph graph) {
        AllPurposeIterator self000 = AllPurposeIterator.newAllPurposeIterator();
        self000.iteratorObject = graph.roots.copy();
        self000.iteratorNextCode = Native.find_java_method("edu.isi.stella.AllPurposeIterator", "allTaxonomyNodesNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        AllPurposeIterator value000 = self000;
        return value000;
    }

    public static void incrementallyUnlinkTaxonomyNodes(TaxonomyGraph graph, TaxonomyNode parent, TaxonomyNode child) {
        throw (StellaException)StellaException.newStellaException("incrementally-unlink-taxonomy-nodes: Rewrite me!").fillInStackTrace();
    }

    public static void unlinkTaxonomyNodes(TaxonomyGraph graph, TaxonomyNode parent, TaxonomyNode child) {
        if (!parent.children.membP(child)) {
            return;
        }
        if (graph.incrementalModeP) {
            graph.incrementalModeP = false;
        }
        parent.children = parent.children.remove(child);
        parent.treeChildren = parent.treeChildren.remove(child);
        child.parents = child.parents.remove(parent);
        TaxonomyGraph.updateTaxonomyRoots(graph, child);
    }

    public static Interval createNextPostorderInterval(TaxonomyGraph graph) {
        ++graph.numberOfForeignIntervalNodes;
        Interval newinterval = Interval.newInterval();
        newinterval.lowerBound = graph.largestPostorderNumber + 1;
        graph.largestPostorderNumber = newinterval.upperBound = graph.largestPostorderNumber + Stella.$NUMBERING_INTERVAL$;
        return newinterval;
    }

    public static void incrementallyLinkTaxonomyNodes(TaxonomyGraph graph, TaxonomyNode parent, TaxonomyNode child) {
        boolean childexistsP;
        if (parent.children.membP(child)) {
            return;
        }
        TaxonomyGraph.createTaxonomyLink(graph, parent, child);
        Interval interval = null;
        boolean parentexistsP = parent.initialInterval != null;
        boolean bl = childexistsP = child.initialInterval != null;
        if (childexistsP) {
            if (!parentexistsP) {
                parent.initialInterval = interval = TaxonomyGraph.createNextPostorderInterval(graph);
                parent.label = interval.upperBound;
                TaxonomyNode.addTaxonomyNodeInterval(parent, interval);
            }
            Interval interval000 = null;
            Cons iter000 = child.intervals;
            while (iter000 != Stella.NIL) {
                interval000 = (Interval)iter000.value;
                TaxonomyNode.propagateForeignInterval(parent, interval000);
                iter000 = iter000.rest;
            }
        } else {
            if (!parentexistsP) {
                parent.initialInterval = interval = TaxonomyGraph.createNextPostorderInterval(graph);
                parent.label = interval.upperBound;
                TaxonomyNode.addTaxonomyNodeInterval(parent, interval);
            }
            if ((interval = TaxonomyNode.allocateIntervalForNewLeafNode(parent)) == null) {
                if (graph.renumberIfOutOfNumbersP) {
                    TaxonomyGraph.finalizeTaxonomyGraphNonincrementally(graph);
                    return;
                }
                interval = TaxonomyGraph.createNextPostorderInterval(graph);
            }
            child.initialInterval = interval;
            child.label = interval.upperBound;
            TaxonomyNode.addTaxonomyNodeInterval(child, interval);
            parent.treeChildren = parent.treeChildren.concatenate(Stella_Object.cons(child, Stella.NIL), Stella.NIL);
            TaxonomyNode.propagateForeignInterval(parent, interval);
        }
    }

    public static void linkTaxonomyNodes(TaxonomyGraph graph, TaxonomyNode parent, TaxonomyNode child) {
        if (parent.children.membP(child)) {
            return;
        }
        if (graph.incrementalModeP) {
            graph.addedLinks.push(Stella_Object.cons(parent, Stella_Object.cons(child, Stella.NIL)));
        } else {
            TaxonomyGraph.createTaxonomyLink(graph, parent, child);
        }
    }

    public static void createTaxonomyLink(TaxonomyGraph graph, TaxonomyNode parent, TaxonomyNode child) {
        TaxonomyGraph.removeTaxonomyRoot(graph, child);
        child.parents = Stella_Object.cons(parent, child.parents);
        parent.children = Stella_Object.cons(child, parent.children);
    }

    public static void removeTaxonomyNode(TaxonomyGraph graph, TaxonomyNode node) {
        Cons parentscopy = Cons.copyConsList(node.parents);
        Cons childrencopy = Cons.copyConsList(node.children);
        TaxonomyNode parent = null;
        Cons iter000 = parentscopy;
        while (iter000 != Stella.NIL) {
            parent = (TaxonomyNode)iter000.value;
            TaxonomyGraph.unlinkTaxonomyNodes(graph, parent, node);
            iter000 = iter000.rest;
        }
        TaxonomyNode child = null;
        Cons iter001 = childrencopy;
        while (iter001 != Stella.NIL) {
            child = (TaxonomyNode)iter001.value;
            TaxonomyGraph.unlinkTaxonomyNodes(graph, node, child);
            iter001 = iter001.rest;
        }
        node.intervals = Stella.NIL;
        node.nativeObject = null;
        node.deletedPSetter(true);
        TaxonomyGraph.removeTaxonomyRoot(graph, node);
        --graph.numberOfNodes;
    }

    public static void addTaxonomyNode(TaxonomyGraph graph, TaxonomyNode node, boolean rootP) {
        if (rootP) {
            TaxonomyGraph.addTaxonomyRoot(graph, node);
        }
        ++graph.numberOfNodes;
    }

    public static TaxonomyNode createTaxonomyNode(TaxonomyGraph graph, TaxonomyNode node, Stella_Object nativeobject, boolean rootP) {
        if (node == null) {
            TaxonomyNode self000 = TaxonomyNode.newTaxonomyNode();
            self000.nativeObject = nativeobject;
            node = self000;
        } else {
            TaxonomyNode.initializeTaxonomyNode(node);
            node.nativeObject = nativeobject;
        }
        TaxonomyGraph.addTaxonomyNode(graph, node, rootP);
        return node;
    }

    public static void updateTaxonomyRoots(TaxonomyGraph graph, TaxonomyNode node) {
        if (node.parents == Stella.NIL) {
            TaxonomyGraph.addTaxonomyRoot(graph, node);
        } else {
            TaxonomyGraph.removeTaxonomyRoot(graph, node);
        }
    }

    public static void removeTaxonomyRoot(TaxonomyGraph graph, TaxonomyNode root) {
        if (root.label != -99) {
            graph.roots.remove(root);
        }
    }

    public static void addTaxonomyRoot(TaxonomyGraph graph, TaxonomyNode root) {
        graph.roots.insertNew(root);
    }

    public void printObject(PrintStream stream) {
        TaxonomyGraph self = this;
        stream.print("|TG|" + self.roots);
    }

    public static Stella_Object accessTaxonomyGraphSlotValue(TaxonomyGraph self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_RENUMBER_IF_OUT_OF_NUMBERSp) {
            if (setvalueP) {
                self.renumberIfOutOfNumbersP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)value);
            } else {
                value = self.renumberIfOutOfNumbersP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (slotname == Stella.SYM_STELLA_RENUMBER_RATIO) {
            if (setvalueP) {
                self.renumberRatio = ((FloatWrapper)value).wrapperValue;
            } else {
                value = FloatWrapper.wrapFloat(self.renumberRatio);
            }
        } else if (slotname == Stella.SYM_STELLA_INCREMENTAL_MODEp) {
            if (setvalueP) {
                self.incrementalModeP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)value);
            } else {
                value = self.incrementalModeP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (slotname == Stella.SYM_STELLA_LARGEST_POSTORDER_NUMBER) {
            if (setvalueP) {
                self.largestPostorderNumber = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.largestPostorderNumber);
            }
        } else if (slotname == Stella.SYM_STELLA_NUMBER_OF_NODES) {
            if (setvalueP) {
                self.numberOfNodes = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.numberOfNodes);
            }
        } else if (slotname == Stella.SYM_STELLA_NUMBER_OF_FOREIGN_INTERVAL_NODES) {
            if (setvalueP) {
                self.numberOfForeignIntervalNodes = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.numberOfForeignIntervalNodes);
            }
        } else if (slotname == Stella.SYM_STELLA_ROOTS) {
            if (setvalueP) {
                self.roots = (List)value;
            } else {
                value = self.roots;
            }
        } else if (slotname == Stella.SYM_STELLA_BROKEN_LINKS) {
            if (setvalueP) {
                self.brokenLinks = (List)value;
            } else {
                value = self.brokenLinks;
            }
        } else if (slotname == Stella.SYM_STELLA_ADDED_LINKS) {
            if (setvalueP) {
                self.addedLinks = (List)value;
            } else {
                value = self.addedLinks;
            }
        } else if (slotname == Stella.SYM_STELLA_REMOVED_LINKS) {
            if (setvalueP) {
                self.removedLinks = (List)value;
            } else {
                value = self.removedLinks;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        TaxonomyGraph self = this;
        return Stella.SGT_STELLA_TAXONOMY_GRAPH;
    }
}

