/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.InputFileStream;
import edu.isi.stella.InputStream;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Iterator;
import edu.isi.stella.Keyword;
import edu.isi.stella.List;
import edu.isi.stella.MethodSlot;
import edu.isi.stella.Module;
import edu.isi.stella.OutputFileStream;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.SExpressionIterator;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Class;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class SystemDefinition
extends StandardObject {
    public String name;
    public String directory;
    public Cons files;
    public Cons lispOnlyFiles;
    public Cons cppOnlyFiles;
    public Cons javaOnlyFiles;
    public Cons preprocessedFiles;
    public Cons requiredSystems;
    public boolean loadedP;
    public boolean upToDateP;
    public String cardinalModule;
    public String sourceRootDirectory;
    public String nativeRootDirectory;
    public String binaryRootDirectory;
    public String banner;
    public Cons productionSettings;
    public Cons developmentSettings;
    public Symbol finalizationFunction;

    public static SystemDefinition newSystemDefinition() {
        SystemDefinition self = null;
        self = new SystemDefinition();
        self.finalizationFunction = null;
        self.developmentSettings = null;
        self.productionSettings = null;
        self.banner = null;
        self.binaryRootDirectory = null;
        self.nativeRootDirectory = null;
        self.sourceRootDirectory = null;
        self.cardinalModule = null;
        self.upToDateP = false;
        self.loadedP = false;
        self.requiredSystems = null;
        self.preprocessedFiles = null;
        self.javaOnlyFiles = null;
        self.cppOnlyFiles = null;
        self.lispOnlyFiles = null;
        self.files = null;
        self.directory = null;
        self.name = null;
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSystemStartupFile(SystemDefinition system) {
        if ((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get() == null) {
            System.out.println("Must be within a system environment to create startup file ");
            System.out.println("   for system `" + system.name + "'.");
            System.out.println();
            return;
        }
        Object old$Module$000 = Stella.$MODULE$.get();
        Object old$Context$000 = Stella.$CONTEXT$.get();
        try {
            Native.setSpecial(Stella.$MODULE$, SystemDefinition.getCardinalModule(system));
            Native.setSpecial(Stella.$CONTEXT$, (Module)Stella.$MODULE$.get());
            String file = Stella.makeFileName(SystemDefinition.systemStartupFileName(system), Stella.KWD_STELLA, true);
            Cons startupfnnames = Stella.NIL;
            Cons startupforms = Stella.NIL;
            OutputFileStream outputstream = null;
            try {
                outputstream = Stella.openOutputFile(file, Stella.NIL);
                StringWrapper f = null;
                Cons iter000 = SystemDefinition.systemDefinitionSourceFiles(system);
                Cons collect000 = null;
                while (iter000 != Stella.NIL) {
                    f = (StringWrapper)iter000.value;
                    if (collect000 == null) {
                        collect000 = Stella_Object.cons(Stella.startupNameFromFile(f.wrapperValue), Stella.NIL);
                        if (startupfnnames == Stella.NIL) {
                            startupfnnames = collect000;
                        } else {
                            Cons.addConsToEndOfConsList(startupfnnames, collect000);
                        }
                    } else {
                        collect000 = collect000.rest = Stella_Object.cons(Stella.startupNameFromFile(f.wrapperValue), Stella.NIL);
                    }
                    iter000 = iter000.rest;
                }
                OutputStream.clOutputFileHeader(outputstream, file, false);
                startupforms = Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_IN_MODULE, Stella_Object.cons(StringWrapper.wrapString(SystemDefinition.getCardinalModule((SystemDefinition)system).moduleFullName), Stella_Object.cons(Stella.NIL, Stella.NIL)))), startupforms);
                startupforms = Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_DEFUN, Stella_Object.cons(SystemDefinition.systemStartupFunctionSymbol(system), Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.NIL, Stella_Object.cons(Stella.KWD_PUBLICp, Stella_Object.cons(Stella.SYM_STELLA_TRUE, Stella_Object.cons(Stella.NIL, Stella.NIL))))), Stella.NIL)))), startupforms);
                if (Stella.stringEqualP(system.name, "STELLA")) {
                    startupforms = Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_STARTUP_TIME_PROGN, Stella_Object.cons(Stella.KWD_EARLY_INITS, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_UNLESS, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_SYSTEM_STARTED_UPp, Stella_Object.cons(StringWrapper.wrapString("stella"), Stella_Object.cons(StringWrapper.wrapString("/STELLA"), Stella_Object.cons(Stella.NIL, Stella.NIL))))), Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_STARTUP, Stella_Object.cons(Stella.SYM_STELLA_FALSE, Stella_Object.cons(Stella.NIL, Stella.NIL)))), Stella_Object.cons(Stella.NIL, Stella.NIL))))), Stella_Object.cons(Stella.NIL, Stella.NIL))))), startupforms);
                } else {
                    if (system.requiredSystems != null) {
                        startupforms = Stella_Object.cons(SystemDefinition.yieldStartupRequiredSystems(system), startupforms);
                    }
                    Cons form = null;
                    Cons iter001 = SystemDefinition.collectStartupFormsFromSystemFile(system);
                    while (iter001 != Stella.NIL) {
                        form = (Cons)iter001.value;
                        startupforms = Stella_Object.cons(form, startupforms);
                        iter001 = iter001.rest;
                    }
                    Symbol startupfn = null;
                    Cons iter002 = startupfnnames;
                    while (iter002 != Stella.NIL) {
                        startupfn = (Symbol)iter002.value;
                        if (Symbol.lookupFunction(startupfn) == null) {
                            Object old$Module$001 = Stella.$MODULE$.get();
                            Object old$Context$001 = Stella.$CONTEXT$.get();
                            try {
                                Native.setSpecial(Stella.$MODULE$, startupfn.homeModule());
                                Native.setSpecial(Stella.$CONTEXT$, (Module)Stella.$MODULE$.get());
                                Cons.defineMethodFromParseTree(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_DEFUN, Stella_Object.cons(startupfn, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.NIL, Stella_Object.cons(Stella.KWD_PUBLICp, Stella_Object.cons(Stella.SYM_STELLA_TRUE, Stella_Object.cons(Stella.NIL, Stella.NIL))))), Stella.NIL)))));
                            }
                            finally {
                                Stella.$CONTEXT$.set(old$Context$001);
                                Stella.$MODULE$.set(old$Module$001);
                            }
                        }
                        iter002 = iter002.rest;
                    }
                    Cons startupfncalls = Stella.NIL;
                    Symbol startupfn2 = null;
                    Cons iter003 = startupfnnames;
                    Cons collect001 = null;
                    while (iter003 != Stella.NIL) {
                        startupfn2 = (Symbol)iter003.value;
                        if (collect001 == null) {
                            collect001 = Stella_Object.cons(Stella_Object.cons(startupfn2, Stella.NIL), Stella.NIL);
                            if (startupfncalls == Stella.NIL) {
                                startupfncalls = collect001;
                            } else {
                                Cons.addConsToEndOfConsList(startupfncalls, collect001);
                            }
                        } else {
                            collect001 = collect001.rest = Stella_Object.cons(Stella_Object.cons(startupfn2, Stella.NIL), Stella.NIL);
                        }
                        iter003 = iter003.rest;
                    }
                    startupforms = Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_STARTUP_TIME_PROGN, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_FOREACH, Stella_Object.cons(Stella.SYM_STELLA_PHASE, Stella_Object.cons(Stella.SYM_STELLA_IN, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_INTERVAL, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_PHASE_TO_INTEGER, Stella_Object.cons(Stella.KWD_EARLY_INITS, Stella_Object.cons(Stella.NIL, Stella.NIL)))), Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_PHASE_TO_INTEGER, Stella_Object.cons(Stella.KWD_FINAL, Stella_Object.cons(Stella.NIL, Stella.NIL)))), Stella_Object.cons(Stella.NIL, Stella.NIL))))), Stella_Object.cons(Stella.SYM_STELLA_DO, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_SETQ, Stella_Object.cons(Stella.SYM_STELLA_$STARTUP_TIME_PHASE$, Stella_Object.cons(Stella.SYM_STELLA_PHASE, Stella_Object.cons(Stella.NIL, Stella.NIL))))), Stella_Object.cons(startupfncalls.concatenate(Stella.NIL, Stella.NIL), Stella.NIL)))))))), Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_SETQ, Stella_Object.cons(Stella.SYM_STELLA_$STARTUP_TIME_PHASE$, Stella_Object.cons(IntegerWrapper.wrapInteger(999), Stella_Object.cons(Stella.NIL, Stella.NIL))))), Stella_Object.cons(Stella.NIL, Stella.NIL))))), startupforms);
                }
                Object old$PrintreadablyP$000 = Stella.$PRINTREADABLYp$.get();
                Object old$PrintprettyP$000 = Stella.$PRINTPRETTYp$.get();
                try {
                    Native.setBooleanSpecial(Stella.$PRINTREADABLYp$, true);
                    Native.setBooleanSpecial(Stella.$PRINTPRETTYp$, true);
                    Cons form = null;
                    Cons iter004 = startupforms.reverse();
                    while (iter004 != Stella.NIL) {
                        form = (Cons)iter004.value;
                        outputstream.nativeStream.println(form);
                        outputstream.nativeStream.println();
                        iter004 = iter004.rest;
                    }
                }
                finally {
                    Stella.$PRINTPRETTYp$.set(old$PrintprettyP$000);
                    Stella.$PRINTREADABLYp$.set(old$PrintreadablyP$000);
                }
            }
            finally {
                if (outputstream != null) {
                    outputstream.free();
                }
            }
        }
        finally {
            Stella.$CONTEXT$.set(old$Context$000);
            Stella.$MODULE$.set(old$Module$000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cons collectStartupFormsFromSystemFile(SystemDefinition system) {
        String systemfilename = Stella.makeSystemDefinitionFileName(system.name);
        Module module = null;
        Cons startupform = null;
        Cons startupforms = Stella.NIL;
        Object old$Module$000 = Stella.$MODULE$.get();
        Object old$Context$000 = Stella.$CONTEXT$.get();
        try {
            Native.setSpecial(Stella.$MODULE$, (Module)Stella.$MODULE$.get());
            Native.setSpecial(Stella.$CONTEXT$, (Module)Stella.$MODULE$.get());
            InputFileStream inputstream = null;
            try {
                inputstream = Stella.openInputFile(systemfilename, Stella.NIL);
                Stella_Object tree = null;
                SExpressionIterator iter000 = InputStream.sExpressions(inputstream);
                Cons collect000 = null;
                while (iter000.nextP()) {
                    tree = iter000.value;
                    startupform = null;
                    if (Stella_Object.safePrimaryType(tree) == Stella.SGT_STELLA_CONS) {
                        Cons tree000 = (Cons)tree;
                        if (tree000.value == Stella.SYM_STELLA_DEFMODULE) {
                            Stella_Object.evaluate(tree000);
                            module = Stella.getStellaModule(Stella_Object.coerceToModuleName(tree000.rest.value, true), true);
                            if (module != null) {
                                startupform = Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_STARTUP_TIME_PROGN, Stella_Object.cons(Stella.KWD_MODULES, Stella_Object.cons(Module.yieldDefineModule(module), Stella_Object.cons(Stella.NIL, Stella.NIL)))));
                            }
                        }
                        if (tree000.value == Stella.SYM_STELLA_IN_MODULE) {
                            Stella_Object.evaluate(tree000);
                        }
                    }
                    if (startupform == null) continue;
                    if (collect000 == null) {
                        collect000 = Stella_Object.cons(startupform, Stella.NIL);
                        if (startupforms == Stella.NIL) {
                            startupforms = collect000;
                            continue;
                        }
                        Cons.addConsToEndOfConsList(startupforms, collect000);
                        continue;
                    }
                    collect000 = collect000.rest = Stella_Object.cons(startupform, Stella.NIL);
                }
            }
            finally {
                if (inputstream != null) {
                    inputstream.free();
                }
            }
            Cons cons = startupforms;
            return cons;
        }
        finally {
            Stella.$CONTEXT$.set(old$Context$000);
            Stella.$MODULE$.set(old$Module$000);
        }
    }

    public static Cons yieldStartupRequiredSystems(SystemDefinition system) {
        Cons startupforms = Stella.NIL;
        StringWrapper systemname = null;
        Cons iter000 = system.requiredSystems;
        Cons collect000 = null;
        while (iter000 != Stella.NIL) {
            systemname = (StringWrapper)iter000.value;
            if (collect000 == null) {
                collect000 = Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_UNLESS, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_SYSTEM_STARTED_UPp, Stella_Object.cons(systemname, Stella_Object.cons(Stella_Object.cons(StringWrapper.wrapString(SystemDefinition.getCardinalModule((SystemDefinition)Stella.getSystemDefinition((String)systemname.wrapperValue)).moduleFullName), Stella.NIL), Stella.NIL)))), Stella_Object.cons(Stella_Object.cons(SystemDefinition.systemStartupFunctionSymbol(Stella.getSystemDefinition(systemname.wrapperValue)), Stella.NIL), Stella_Object.cons(Stella.NIL, Stella.NIL))))), Stella.NIL);
                if (startupforms == Stella.NIL) {
                    startupforms = collect000;
                } else {
                    Cons.addConsToEndOfConsList(startupforms, collect000);
                }
            } else {
                collect000 = collect000.rest = Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_UNLESS, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_SYSTEM_STARTED_UPp, Stella_Object.cons(systemname, Stella_Object.cons(Stella_Object.cons(StringWrapper.wrapString(SystemDefinition.getCardinalModule((SystemDefinition)Stella.getSystemDefinition((String)systemname.wrapperValue)).moduleFullName), Stella.NIL), Stella.NIL)))), Stella_Object.cons(Stella_Object.cons(SystemDefinition.systemStartupFunctionSymbol(Stella.getSystemDefinition(systemname.wrapperValue)), Stella.NIL), Stella_Object.cons(Stella.NIL, Stella.NIL))))), Stella.NIL);
            }
            iter000 = iter000.rest;
        }
        return Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_STARTUP_TIME_PROGN, Stella_Object.cons(Stella.KWD_EARLY_INITS, Stella_Object.cons(startupforms.concatenate(Stella.NIL, Stella.NIL), Stella.NIL))));
    }

    public static String systemStartupFileName(SystemDefinition system) {
        if (system == null) {
            system = (SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get();
        }
        if (system != null) {
            return "startup-system";
        }
        return null;
    }

    public static Symbol systemStartupFunctionSymbol(SystemDefinition system) {
        return Stella.internSymbolInModule(system.systemStartupFunctionName(), SystemDefinition.getCardinalModule(system), true);
    }

    public String systemStartupFunctionName() {
        SystemDefinition system = this;
        return Stella.string_systemStartupFunctionName(system.name);
    }

    public static void runSystemStartupFunction(SystemDefinition system) {
        if (!Stella.runningAsLispP()) {
            return;
        }
    }

    public static Cons systemDefinitionNativeFiles(SystemDefinition system) {
        Cons files = Cons.copyConsList(system.files);
        if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_COMMON_LISP) {
            files = files.union(system.lispOnlyFiles);
            if (((List)Stella.$CURRENT_STELLA_FEATURES$.get()).membP(Stella.KWD_USE_COMMON_LISP_STRUCTS)) {
                files = Stella_Object.cons(StringWrapper.wrapString(Stella.clYieldStructClassFileName(system.name)), files);
            }
        } else if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_JAVA) {
            files = files.union(system.javaOnlyFiles);
        } else if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_CPP) {
            files = files.union(system.cppOnlyFiles);
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + (Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return files;
    }

    public static Cons systemDefinitionSourceFiles(SystemDefinition system) {
        Cons files = Cons.copyConsList(system.files);
        if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_COMMON_LISP) {
            files = files.subtract(system.javaOnlyFiles);
            files = files.subtract(system.cppOnlyFiles);
        } else if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_JAVA) {
            files = files.subtract(system.lispOnlyFiles);
            files = files.subtract(system.cppOnlyFiles);
        } else if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_CPP) {
            files = files.subtract(system.lispOnlyFiles);
            files = files.subtract(system.javaOnlyFiles);
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + (Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return files;
    }

    public static void runSystemFinalization(SystemDefinition system) {
        String fnname = null;
        MethodSlot finalizationfn = null;
        if (fnname != null) {
            finalizationfn = Stella.lookupFunctionByName(fnname);
        }
        if (finalizationfn != null) {
            Native.funcall(finalizationfn.functionCode, null, new Object[0]);
        }
    }

    public static void computeOptimizationLevels(SystemDefinition system, boolean productionmodeP) {
        Cons settings = null;
        settings = productionmodeP ? system.productionSettings : system.developmentSettings;
        if (settings == null) {
            settings = Stella.getQuotedTree("((3 2 3 3) \"/STELLA\")", "/STELLA");
        }
        Stella.setOptimizationLevels(((IntegerWrapper)settings.nth((int)0)).wrapperValue, ((IntegerWrapper)settings.nth((int)1)).wrapperValue, ((IntegerWrapper)settings.nth((int)2)).wrapperValue, ((IntegerWrapper)settings.nth((int)3)).wrapperValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSystemFiles(SystemDefinition system, Keyword type, boolean probefilesP) {
        List files = List.newList();
        String filename = null;
        Object old$Currentsystemdefinition$000 = Stella.$CURRENTSYSTEMDEFINITION$.get();
        Object old$Currentsystemdefinitionsubdirectory$000 = Stella.$CURRENTSYSTEMDEFINITIONSUBDIRECTORY$.get();
        try {
            Native.setSpecial(Stella.$CURRENTSYSTEMDEFINITION$, Stella.getSystemDefinition(system.name));
            Native.setSpecial(Stella.$CURRENTSYSTEMDEFINITIONSUBDIRECTORY$, (SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get() != null ? ((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get()).directory : null);
            if ((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get() != null) {
                Stella_Object f = null;
                Cons iter000 = ((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get()).files;
                while (iter000 != Stella.NIL) {
                    f = (StringWrapper)iter000.value;
                    filename = type == Stella.KWD_JAVA ? StringWrapper.javaTranslateClassNamestring((StringWrapper)StringWrapper.wrapString((String)new StringBuffer().append((String)"_STARTUP-").append((String)Native.stringUpcase((String)f.wrapperValue)).toString())).wrapperValue : Stella_Object.makeFileNameFromRelativePath(f, type);
                    Stella.helpGetSystemFiles(filename, files, probefilesP);
                    iter000 = iter000.rest;
                }
                if (type == Stella.KWD_JAVA) {
                    if (SystemDefinition.getCardinalModule((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get()) == null) {
                        System.out.println("No cardinal module defined for system `" + system.name + "'");
                        System.out.println();
                        f = Stella.NIL_LIST;
                        return f;
                    }
                    Stella_Class renamed_Class = null;
                    Iterator iter001 = Module.allClasses(SystemDefinition.getCardinalModule((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get()), true);
                    while (iter001.nextP()) {
                        renamed_Class = (Stella_Class)iter001.value;
                        filename = renamed_Class.javaMakeCodeOutputFileName(false);
                        Stella.helpGetSystemFiles(filename, files, probefilesP);
                    }
                    filename = Stella.string_javaMakeCodeOutputFileName(Module.javaYieldFlotsamClassName(SystemDefinition.getCardinalModule((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get())), false);
                    Stella.helpGetSystemFiles(filename, files, probefilesP);
                }
            } else {
                Stella.STANDARD_WARNING.nativeStream.println("Warning: Can't find a system named `" + system.name + "'");
                Stella.STANDARD_WARNING.nativeStream.println();
            }
        }
        finally {
            Stella.$CURRENTSYSTEMDEFINITIONSUBDIRECTORY$.set(old$Currentsystemdefinitionsubdirectory$000);
            Stella.$CURRENTSYSTEMDEFINITION$.set(old$Currentsystemdefinition$000);
        }
        return files;
    }

    public static Module getCardinalModule(SystemDefinition system) {
        String name = system.cardinalModule;
        Module module = null;
        if (name != null && (module = Stella.getStellaModule(name, false)) == null) {
            module = Stella.getStellaModule(Native.stringUpcase(name), false);
        }
        if (module == null) {
            Stella.STANDARD_WARNING.nativeStream.println("Warning: No cardinal module defined for system: `" + system + "'");
            Stella.STANDARD_WARNING.nativeStream.println();
        }
        return module;
    }

    public void printObject(PrintStream stream) {
        SystemDefinition self = this;
        stream.print("|SYSTEM|" + self.name);
    }

    public static Stella_Object accessSystemDefinitionSlotValue(SystemDefinition self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_NAME) {
            if (setvalueP) {
                self.name = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.name);
            }
        } else if (slotname == Stella.SYM_STELLA_DIRECTORY) {
            if (setvalueP) {
                self.directory = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.directory);
            }
        } else if (slotname == Stella.SYM_STELLA_FILES) {
            if (setvalueP) {
                self.files = (Cons)value;
            } else {
                value = self.files;
            }
        } else if (slotname == Stella.SYM_STELLA_LISP_ONLY_FILES) {
            if (setvalueP) {
                self.lispOnlyFiles = (Cons)value;
            } else {
                value = self.lispOnlyFiles;
            }
        } else if (slotname == Stella.SYM_STELLA_CPP_ONLY_FILES) {
            if (setvalueP) {
                self.cppOnlyFiles = (Cons)value;
            } else {
                value = self.cppOnlyFiles;
            }
        } else if (slotname == Stella.SYM_STELLA_JAVA_ONLY_FILES) {
            if (setvalueP) {
                self.javaOnlyFiles = (Cons)value;
            } else {
                value = self.javaOnlyFiles;
            }
        } else if (slotname == Stella.SYM_STELLA_PREPROCESSED_FILES) {
            if (setvalueP) {
                self.preprocessedFiles = (Cons)value;
            } else {
                value = self.preprocessedFiles;
            }
        } else if (slotname == Stella.SYM_STELLA_REQUIRED_SYSTEMS) {
            if (setvalueP) {
                self.requiredSystems = (Cons)value;
            } else {
                value = self.requiredSystems;
            }
        } else if (slotname == Stella.SYM_STELLA_LOADEDp) {
            if (setvalueP) {
                self.loadedP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)value);
            } else {
                value = self.loadedP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (slotname == Stella.SYM_STELLA_UP_TO_DATEp) {
            if (setvalueP) {
                self.upToDateP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)value);
            } else {
                value = self.upToDateP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (slotname == Stella.SYM_STELLA_CARDINAL_MODULE) {
            if (setvalueP) {
                self.cardinalModule = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.cardinalModule);
            }
        } else if (slotname == Stella.SYM_STELLA_SOURCE_ROOT_DIRECTORY) {
            if (setvalueP) {
                self.sourceRootDirectory = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.sourceRootDirectory);
            }
        } else if (slotname == Stella.SYM_STELLA_NATIVE_ROOT_DIRECTORY) {
            if (setvalueP) {
                self.nativeRootDirectory = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.nativeRootDirectory);
            }
        } else if (slotname == Stella.SYM_STELLA_BINARY_ROOT_DIRECTORY) {
            if (setvalueP) {
                self.binaryRootDirectory = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.binaryRootDirectory);
            }
        } else if (slotname == Stella.SYM_STELLA_BANNER) {
            if (setvalueP) {
                self.banner = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.banner);
            }
        } else if (slotname == Stella.SYM_STELLA_COPYRIGHT_HEADER) {
            if (setvalueP) {
                self.banner = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.banner);
            }
        } else if (slotname == Stella.SYM_STELLA_PRODUCTION_SETTINGS) {
            if (setvalueP) {
                self.productionSettings = (Cons)value;
            } else {
                value = self.productionSettings;
            }
        } else if (slotname == Stella.SYM_STELLA_DEVELOPMENT_SETTINGS) {
            if (setvalueP) {
                self.developmentSettings = (Cons)value;
            } else {
                value = self.developmentSettings;
            }
        } else if (slotname == Stella.SYM_STELLA_FINALIZATION_FUNCTION) {
            if (setvalueP) {
                self.finalizationFunction = (Symbol)value;
            } else {
                value = self.finalizationFunction;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        SystemDefinition self = this;
        return Stella.SGT_STELLA_SYSTEM_DEFINITION;
    }
}

