/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.Context;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.InputStream;
import edu.isi.stella.InputStringStream;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Iterator;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.List;
import edu.isi.stella.MethodSlot;
import edu.isi.stella.Module;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Slot;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Stream;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.SystemDefinition;
import edu.isi.stella.XmlAttribute;
import edu.isi.stella.XmlDeclaration;
import edu.isi.stella.XmlElement;
import edu.isi.stella.XmlObject;
import edu.isi.stella.XmlProcessingInstruction;
import edu.isi.stella.XmlSpecial;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class OutputStream
extends Stream {
    public PrintStream nativeStream;

    public static OutputStream newOutputStream() {
        OutputStream self = null;
        self = new OutputStream();
        self.state = null;
        self.nativeStream = null;
        return self;
    }

    public static void javaOutputFileHeader(OutputStream stream, String filename) {
        stream.nativeStream.println("//  -*- Mode: Java -*-");
        stream.nativeStream.println("//");
        if (filename != null) {
            stream.nativeStream.println("// " + Stella.fileNameWithoutDirectory(filename));
            stream.nativeStream.println();
        }
        String packageName = Module.javaPackagePrefix((Module)Stella.$MODULE$.get(), ".");
        Cons importedPackages = Stella.NIL;
        String name = null;
        OutputStream.outputCopyrightHeader(stream);
        if (packageName != null && !Stella.stringEqlP(packageName, "")) {
            packageName = Native.string_subsequence(packageName, 0, packageName.length() - 1);
            stream.nativeStream.println("package " + packageName + ";");
            stream.nativeStream.println();
        }
        if ((Module)Stella.$MODULE$.get() == Stella.$STELLA_MODULE$) {
            stream.nativeStream.println("import " + Stella.javaStellaPackage() + ".javalib.*;");
        } else {
            if (Stella.string_getStellaClass("NATIVE", false) == null && !Stella.inheritedClassNameConflictsP("NATIVE")) {
                stream.nativeStream.println("import " + Stella.javaStellaPackage() + ".javalib.Native;");
            }
            if (Stella.string_getStellaClass("STELLA-SPECIAL-VARIABLE", false) == null && !Stella.inheritedClassNameConflictsP("STELLA-SPECIAL-VARIABLE")) {
                stream.nativeStream.println("import " + Stella.javaStellaPackage() + ".javalib.StellaSpecialVariable;");
            }
        }
        if (((List)Stella.$CURRENT_STELLA_FEATURES$.get()).membP(Stella.KWD_MINIMIZE_JAVA_PREFIXES)) {
            Context module = null;
            Cons iter000 = ((Module)Stella.$MODULE$.get()).uses.theConsList;
            while (iter000 != Stella.NIL) {
                module = (Module)iter000.value;
                name = Module.javaPackagePrefix(module, ".");
                if (!Stella.stringEqlP(name, packageName) && !importedPackages.memberP(StringWrapper.wrapString(name))) {
                    stream.nativeStream.println("import " + name + "*;");
                    importedPackages = Stella_Object.cons(StringWrapper.wrapString(name), importedPackages);
                }
                iter000 = iter000.rest;
            }
            module = null;
            Cons iter001 = ((Module)Stella.$MODULE$.get()).allSuperContexts;
            while (iter001 != Stella.NIL) {
                module = (Context)iter001.value;
                name = Module.javaPackagePrefix(module, ".");
                if (!Stella.stringEqlP(name, packageName) && !importedPackages.memberP(StringWrapper.wrapString(name))) {
                    stream.nativeStream.println("import " + name + "*;");
                    importedPackages = Stella_Object.cons(StringWrapper.wrapString(name), importedPackages);
                }
                iter001 = iter001.rest;
            }
        }
        stream.nativeStream.println();
    }

    public static void cppOutputFileHeader(OutputStream stream, String file) {
        stream.nativeStream.println("//  -*- Mode: C++ -*-");
        stream.nativeStream.println();
        if (file != null) {
            stream.nativeStream.println("// " + Stella.fileNameWithoutDirectory(file));
            stream.nativeStream.println();
        }
        OutputStream.outputCopyrightHeader(stream);
    }

    public static void prettyPrintSlotBlock(OutputStream stream, Iterator iterator, String slotgroup) {
        if (!iterator.nextP()) {
            return;
        }
        Slot slot = (Slot)iterator.value;
        stream.nativeStream.println();
        stream.nativeStream.println("  " + slotgroup);
        stream.nativeStream.print("  (");
        slot.prettyPrintObject(stream);
        slot = null;
        Iterator iter000 = iterator;
        while (iter000.nextP()) {
            slot = (Slot)iter000.value;
            stream.nativeStream.println();
            stream.nativeStream.print("   ");
            slot.prettyPrintObject(stream);
        }
        stream.nativeStream.print(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prettyPrintMethodParameters(OutputStream stream, MethodSlot method) {
        int lastargindex = ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)method.dynamicSlots, (Symbol)Stella.SYM_STELLA_METHOD_VARIABLE_ARGUMENTSp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue ? method.methodParameterNames().length() : -1;
        Object old$PrintreadablyP$000 = Stella.$PRINTREADABLYp$.get();
        try {
            Native.setBooleanSpecial(Stella.$PRINTREADABLYp$, true);
            stream.nativeStream.print("(");
            Symbol parameter = null;
            Cons iter000 = method.methodParameterNames().theConsList;
            StandardObject tspec = null;
            Cons iter001 = method.methodParameterTypeSpecifiers().theConsList;
            int i = Integer.MIN_VALUE;
            int iter002 = 1;
            while (iter000 != Stella.NIL && iter001 != Stella.NIL) {
                parameter = (Symbol)iter000.value;
                tspec = (StandardObject)iter001.value;
                i = iter002;
                if (i > 1) {
                    stream.nativeStream.print(" ");
                }
                if (i == lastargindex) {
                    stream.nativeStream.print("&rest ");
                    tspec = MethodSlot.variableArgumentsType(method);
                }
                stream.nativeStream.print("(" + Native.stringDowncase(parameter.symbolName) + " " + StandardObject.yieldTypeSpecTree(tspec) + ")");
                iter000 = iter000.rest;
                iter001 = iter001.rest;
                ++iter002;
            }
            stream.nativeStream.print(")");
        }
        finally {
            Stella.$PRINTREADABLYp$.set(old$PrintreadablyP$000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfigurationValue(OutputStream stream, Stella_Object value) {
        Surrogate testValue000 = Stella_Object.safePrimaryType(value);
        if (Surrogate.subtypeOfStringP(testValue000)) {
            StringWrapper value000 = (StringWrapper)value;
            stream.nativeStream.print(value000.wrapperValue);
        } else if (Surrogate.subtypeOfBooleanP(testValue000)) {
            BooleanWrapper value000 = (BooleanWrapper)value;
            if (value000 == Stella.TRUE_WRAPPER) {
                stream.nativeStream.print("true");
            } else {
                stream.nativeStream.print("false");
            }
        } else if (Surrogate.subtypeOfIntegerP(testValue000)) {
            IntegerWrapper value000 = (IntegerWrapper)value;
            stream.nativeStream.print(Native.integerToString(value000.wrapperValue));
        } else if (Surrogate.subtypeOfFloatP(testValue000)) {
            FloatWrapper value000 = (FloatWrapper)value;
            stream.nativeStream.print(Native.floatToString(value000.wrapperValue));
        } else {
            Object old$PrintreadablyP$000 = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial(Stella.$PRINTREADABLYp$, true);
                stream.nativeStream.print(value);
            }
            finally {
                Stella.$PRINTREADABLYp$.set(old$PrintreadablyP$000);
            }
        }
    }

    public static void outputFileHeader(OutputStream stream, String file) {
        if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_COMMON_LISP) {
            OutputStream.clOutputFileHeader(stream, file, true);
        } else if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_JAVA) {
            OutputStream.javaOutputFileHeader(stream, file);
        } else if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_CPP) {
            OutputStream.cppOutputFileHeader(stream, file);
        } else {
            OutputStream.clOutputFileHeader(stream, file, false);
        }
    }

    public static void outputCopyrightHeader(OutputStream stream) {
        if (!Stella.translateWithCopyrightHeaderP() || (SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get() == null || ((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get()).banner == null) {
            return;
        }
        if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_COMMON_LISP) {
            stream.nativeStream.println("#|");
        } else if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_JAVA || (Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_CPP || (Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_CPP_STANDALONE) {
            stream.nativeStream.println("/*");
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + (Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        KeyValueList substitutionList = KeyValueList.newKeyValueList();
        InputStringStream bstream = Stella.makeTokenizerStringStream(((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get()).banner);
        KeyValueList.fillInDateSubstitution(substitutionList);
        InputStream.substituteTemplateVariablesToStream(bstream, stream, substitutionList);
        if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_COMMON_LISP) {
            stream.nativeStream.print("|#");
        } else if ((Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_JAVA || (Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_CPP || (Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() == Stella.KWD_CPP_STANDALONE) {
            stream.nativeStream.print("*/");
        } else {
            OutputStringStream stream001 = OutputStringStream.newOutputStringStream();
            stream001.nativeStream.print("`" + (Keyword)Stella.$TRANSLATOROUTPUTLANGUAGE$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream001.theStringReader()).fillInStackTrace();
        }
        stream.nativeStream.println();
        stream.nativeStream.println();
    }

    public static void printXmlExpression(OutputStream stream, Cons xmlExpression, int indent) {
        Surrogate testValue000;
        if (Stella_Object.isaP(xmlExpression.value, Stella.SGT_STELLA_CONS)) {
            Stella_Object exp = null;
            Cons iter000 = xmlExpression;
            while (iter000 != Stella.NIL) {
                exp = iter000.value;
                OutputStream.printXmlExpression(stream, (Cons)exp, indent);
                iter000 = iter000.rest;
            }
            return;
        }
        XmlObject tag = (XmlObject)xmlExpression.value;
        Cons attributes = (Cons)xmlExpression.rest.value;
        String tagname = tag.surfaceForm;
        boolean previousItemWasStringP = false;
        boolean inContentFieldP = false;
        if (indent != Integer.MIN_VALUE) {
            boolean unboundedP000;
            int i = Integer.MIN_VALUE;
            int upperBound000 = indent;
            boolean bl = unboundedP000 = upperBound000 == Integer.MIN_VALUE;
            for (int iter001 = 1; unboundedP000 || iter001 <= upperBound000; ++iter001) {
                i = iter001;
                stream.nativeStream.print(" ");
            }
        }
        if (Surrogate.subtypeOfP(testValue000 = Stella_Object.safePrimaryType(tag), Stella.SGT_STELLA_XML_PROCESSING_INSTRUCTION)) {
            XmlProcessingInstruction tag000 = (XmlProcessingInstruction)tag;
            stream.nativeStream.print("<?" + tagname);
            OutputStream.printXmlNonElementAttributes(stream, attributes);
            stream.nativeStream.println("?>");
        } else if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_XML_DECLARATION)) {
            XmlDeclaration tag000 = (XmlDeclaration)tag;
            stream.nativeStream.print("<!" + tagname);
            OutputStream.printXmlNonElementAttributes(stream, attributes);
            stream.nativeStream.println(">");
        } else if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_XML_SPECIAL)) {
            XmlSpecial tag000 = (XmlSpecial)tag;
            stream.nativeStream.print("<![" + tagname + "[");
            if (Stella.stringEqlP(tagname, "CDATA")) {
                stream.nativeStream.print(StringWrapper.unwrapString((StringWrapper)attributes.value));
            } else {
                OutputStream.printXmlNonElementAttributes(stream, attributes);
            }
            stream.nativeStream.print("]]>");
        } else if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_XML_ELEMENT)) {
            XmlElement tag000 = (XmlElement)tag;
            if (xmlExpression.rest == Stella.NIL) {
                stream.nativeStream.println("<" + tagname + "/>");
            } else {
                stream.nativeStream.print("<" + tagname);
                OutputStream.printXmlElementAttributes(stream, (Cons)xmlExpression.rest.value);
                previousItemWasStringP = false;
                if (indent != Integer.MIN_VALUE) {
                    indent += 2;
                }
                Stella_Object item = null;
                Cons iter002 = xmlExpression.rest.rest;
                while (iter002 != Stella.NIL) {
                    Stella_Object item000;
                    item = iter002.value;
                    Surrogate testValue001 = Stella_Object.safePrimaryType(item);
                    if (testValue001 == Stella.SGT_STELLA_CONS) {
                        item000 = (Cons)item;
                        if (Stella_Object.xmlCdataP(item000.value)) {
                            if (!inContentFieldP) {
                                stream.nativeStream.print(">");
                                inContentFieldP = true;
                            }
                            OutputStream.printXmlExpression(stream, item000, 0);
                            previousItemWasStringP = true;
                        } else {
                            if (!inContentFieldP) {
                                stream.nativeStream.println(">");
                                inContentFieldP = true;
                            }
                            OutputStream.printXmlExpression(stream, item000, indent);
                            previousItemWasStringP = false;
                        }
                    } else if (Surrogate.subtypeOfStringP(testValue001)) {
                        item000 = (StringWrapper)item;
                        if (!inContentFieldP) {
                            stream.nativeStream.print(">");
                            inContentFieldP = true;
                        }
                        if (previousItemWasStringP) {
                            stream.nativeStream.print(" ");
                        }
                        boolean foundP000 = false;
                        char ch = '\u0000';
                        String vector000 = ((StringWrapper)item000).wrapperValue;
                        int length000 = vector000.length();
                        for (int index000 = 0; index000 < length000; ++index000) {
                            ch = vector000.charAt(index000);
                            if (!Stella.htmlCharacterNeedsQuotingP(ch)) continue;
                            foundP000 = true;
                            break;
                        }
                        if (foundP000) {
                            Stella.writeHtmlQuotingSpecialCharacters(stream.nativeStream, ((StringWrapper)item000).wrapperValue);
                        } else {
                            stream.nativeStream.print(((StringWrapper)item000).wrapperValue);
                        }
                        previousItemWasStringP = true;
                    } else {
                        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                        stream000.nativeStream.print("`" + testValue001 + "' is not a valid case option");
                        throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
                    }
                    iter002 = iter002.rest;
                }
                if (inContentFieldP) {
                    if (indent != Integer.MIN_VALUE) {
                        indent -= 2;
                        if (!previousItemWasStringP) {
                            boolean unboundedP001;
                            int i = Integer.MIN_VALUE;
                            int upperBound001 = indent;
                            boolean bl = unboundedP001 = upperBound001 == Integer.MIN_VALUE;
                            for (int iter003 = 1; unboundedP001 || iter003 <= upperBound001; ++iter003) {
                                i = iter003;
                                stream.nativeStream.print(" ");
                            }
                        }
                    }
                    stream.nativeStream.print("</" + tagname + ">");
                    if (indent != Integer.MIN_VALUE && indent > 0) {
                        stream.nativeStream.println();
                    }
                } else {
                    stream.nativeStream.println("/>");
                }
            }
        } else {
            OutputStringStream stream001 = OutputStringStream.newOutputStringStream();
            stream001.nativeStream.print("`" + testValue000 + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream001.theStringReader()).fillInStackTrace();
        }
    }

    public static void printXmlElementAttributes(OutputStream stream, Cons attributes) {
        Stella_Object item = null;
        Cons iter000 = attributes;
        while (iter000 != Stella.NIL) {
            Stella_Object item000;
            item = iter000.value;
            Surrogate testValue000 = Stella_Object.safePrimaryType(item);
            if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_XML_ATTRIBUTE)) {
                item000 = (XmlAttribute)item;
                stream.nativeStream.print(" " + item000.surfaceForm + "=");
            } else if (Surrogate.subtypeOfStringP(testValue000)) {
                item000 = (StringWrapper)item;
                stream.nativeStream.print("\"");
                boolean foundP000 = false;
                char ch = '\u0000';
                String vector000 = ((StringWrapper)item000).wrapperValue;
                int length000 = vector000.length();
                for (int index000 = 0; index000 < length000; ++index000) {
                    ch = vector000.charAt(index000);
                    if (!Stella.htmlCharacterNeedsQuotingP(ch)) continue;
                    foundP000 = true;
                    break;
                }
                if (foundP000) {
                    Stella.writeHtmlQuotingSpecialCharacters(stream.nativeStream, ((StringWrapper)item000).wrapperValue);
                } else {
                    stream.nativeStream.print(((StringWrapper)item000).wrapperValue);
                }
                stream.nativeStream.print("\"");
            } else {
                OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                stream000.nativeStream.print("`" + testValue000 + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
            }
            iter000 = iter000.rest;
        }
    }

    public static void printXmlNonElementAttributes(OutputStream stream, Cons attributes) {
        boolean lastWasAttributeP = false;
        Stella_Object item = null;
        Cons iter000 = attributes;
        while (iter000 != Stella.NIL) {
            Stella_Object item000;
            item = iter000.value;
            Surrogate testValue000 = Stella_Object.safePrimaryType(item);
            if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_XML_ATTRIBUTE)) {
                item000 = (XmlAttribute)item;
                stream.nativeStream.print(" " + item000.surfaceForm);
                lastWasAttributeP = true;
            } else if (Surrogate.subtypeOfStringP(testValue000)) {
                item000 = (StringWrapper)item;
                if (lastWasAttributeP) {
                    stream.nativeStream.print("=");
                } else {
                    stream.nativeStream.print(" ");
                }
                stream.nativeStream.print(((StringWrapper)item000).wrapperValue);
                lastWasAttributeP = false;
            } else {
                OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                stream000.nativeStream.print("`" + testValue000 + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
            }
            iter000 = iter000.rest;
        }
    }

    public static void clOutputInPackageDeclaration(OutputStream stream, String renamed_Package) {
        stream.nativeStream.println("(CL:IN-PACKAGE \"" + renamed_Package + "\")");
    }

    public static void clOutputEnsurePackageDefinition(OutputStream stream, String renamed_Package) {
        stream.nativeStream.println("(CL:EVAL-WHEN (CL:COMPILE CL:LOAD CL:EVAL)");
        stream.nativeStream.println("  (CL:UNLESS (CL:FIND-PACKAGE \"" + renamed_Package + "\")");
        stream.nativeStream.println("     (CL:DEFPACKAGE \"" + renamed_Package + "\" (:USE))))");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clOutputFileHeader(OutputStream stream, String file, boolean ensurepackageP) {
        String renamed_Package = ((Module)Stella.$MODULE$.get()).lispPackage();
        stream.nativeStream.println(";;; -*- Mode: Lisp; Package: " + renamed_Package + "; Syntax: COMMON-LISP; Base: 10 -*-");
        stream.nativeStream.println();
        if (file != null) {
            stream.nativeStream.println(";;; " + Stella.fileNameWithoutDirectory(file));
            stream.nativeStream.println();
        }
        Object old$Translatoroutputlanguage$000 = Stella.$TRANSLATOROUTPUTLANGUAGE$.get();
        try {
            Native.setSpecial(Stella.$TRANSLATOROUTPUTLANGUAGE$, Stella.KWD_COMMON_LISP);
            OutputStream.outputCopyrightHeader(stream);
        }
        finally {
            Stella.$TRANSLATOROUTPUTLANGUAGE$.set(old$Translatoroutputlanguage$000);
        }
        if (!Stella.stringEqlP(renamed_Package, "STELLA") && ensurepackageP) {
            OutputStream.clOutputEnsurePackageDefinition(stream, renamed_Package);
            stream.nativeStream.println();
        }
        OutputStream.clOutputInPackageDeclaration(stream, renamed_Package);
        stream.nativeStream.println();
    }

    public static void flushOutput(OutputStream self) {
        PrintStream nativeStream = self.nativeStream;
        nativeStream.flush();
    }

    public static boolean terminateOutputStreamP(OutputStream self) {
        PrintStream nativeStream = self.nativeStream;
        if (nativeStream != null) {
            nativeStream.close();
        }
        self.nativeStream = null;
        self.state = Stella.KWD_CLOSED;
        return true;
    }

    public Surrogate primaryType() {
        OutputStream self = this;
        return Stella.SGT_STELLA_OUTPUT_STREAM;
    }

    public void free() {
        OutputStream self = this;
        if (OutputStream.terminateOutputStreamP(self)) {
            Stella_Object.unmake(self);
        }
    }
}

