/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.Cons;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.MemoizationTable;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;

public class MruMemoizationTable
extends MemoizationTable {
    public Vector mruBucketsVector;
    public Vector lruBucketsVector;
    public Stella_Object[] mruBuckets;
    public Stella_Object[] lruBuckets;
    public Cons mruTimestamp;
    public Cons lruTimestamp;
    public int nofBuckets;
    public int freeEntries;
    public int maxEntries;

    public static MruMemoizationTable newMruMemoizationTable() {
        MruMemoizationTable self = null;
        self = new MruMemoizationTable();
        self.timestamps = Stella.NIL;
        self.currentTimestamp = null;
        self.tableName = null;
        self.hashTable = null;
        self.maxEntries = Integer.MIN_VALUE;
        self.freeEntries = Integer.MIN_VALUE;
        self.nofBuckets = Integer.MIN_VALUE;
        self.lruTimestamp = null;
        self.mruTimestamp = null;
        self.lruBuckets = null;
        self.mruBuckets = null;
        self.lruBucketsVector = null;
        self.mruBucketsVector = null;
        return self;
    }

    public static Cons lookupMruMemoizedValuen(MruMemoizationTable memotable, Cons args, int eqvector) {
        Stella_Object[] mrubuckets = memotable.mruBuckets;
        Stella_Object[] lrubuckets = null;
        Cons mrubucket = Stella.NIL;
        Cons lrubucket = Stella.NIL;
        Cons mrutimestamp = null;
        int hashcode = 0;
        int bucketindex = 0;
        Cons entry = null;
        if (mrubuckets == null) {
            MruMemoizationTable.initializeMruBucketTables(memotable);
            mrubuckets = memotable.mruBuckets;
        }
        if (memotable.currentTimestamp != (mrutimestamp = memotable.mruTimestamp)) {
            memotable.mruTimestamp = mrutimestamp = memotable.currentTimestamp;
            memotable.lruTimestamp = mrutimestamp;
            memotable.freeEntries = memotable.maxEntries;
        }
        if ((mrubucket = (Cons)mrubuckets[bucketindex = ((hashcode = Cons.hashMemoizedArgumentsn(args, eqvector)) & Integer.MAX_VALUE) % memotable.nofBuckets]) != null) {
            if ((Cons)mrubucket.value == mrutimestamp) {
                entry = Cons.findMemoizedValueEntryn(mrubucket, args, eqvector, false);
                if (entry != null) {
                    return entry;
                }
            } else {
                mrubucket.value = mrutimestamp;
                mrubucket.rest = Stella.NIL;
            }
        }
        if ((lrubucket = (Cons)(lrubuckets = memotable.lruBuckets)[bucketindex]) != null) {
            if ((Cons)lrubucket.value == memotable.lruTimestamp) {
                entry = Cons.findMemoizedValueEntryn(lrubucket, args, eqvector, true);
            } else {
                lrubucket.rest = Stella.NIL;
            }
        }
        if (entry == null) {
            entry = Stella_Object.cons(null, args);
        }
        if (mrubucket != null) {
            mrubucket.rest = Stella_Object.cons(entry, mrubucket.rest);
        } else {
            mrubuckets[bucketindex] = Stella_Object.cons(mrutimestamp, Stella_Object.cons(entry, Stella.NIL));
        }
        if (--memotable.freeEntries == 0) {
            memotable.mruBuckets = lrubuckets;
            memotable.lruBuckets = mrubuckets;
            memotable.currentTimestamp = memotable.mruTimestamp = Stella_Object.cons(null, Stella.NIL);
            memotable.lruTimestamp = mrutimestamp;
            memotable.freeEntries = memotable.maxEntries;
        }
        return entry;
    }

    public static Cons lookupMruMemoizedValue(MruMemoizationTable memotable, Stella_Object arg1, Stella_Object arg2, Stella_Object arg3, Stella_Object arg4, int eqvector) {
        Stella_Object[] mrubuckets = memotable.mruBuckets;
        Stella_Object[] lrubuckets = null;
        Cons mrubucket = Stella.NIL;
        Cons lrubucket = Stella.NIL;
        Cons mrutimestamp = null;
        int hashcode = 0;
        int bucketindex = 0;
        Cons entry = null;
        if (mrubuckets == null) {
            MruMemoizationTable.initializeMruBucketTables(memotable);
            mrubuckets = memotable.mruBuckets;
        }
        if (memotable.currentTimestamp != (mrutimestamp = memotable.mruTimestamp)) {
            memotable.mruTimestamp = mrutimestamp = memotable.currentTimestamp;
            memotable.lruTimestamp = mrutimestamp;
            memotable.freeEntries = memotable.maxEntries;
        }
        if ((mrubucket = (Cons)mrubuckets[bucketindex = ((hashcode = Stella_Object.hashMemoizedArguments(arg1, arg2, arg3, arg4, eqvector)) & Integer.MAX_VALUE) % memotable.nofBuckets]) != null) {
            if ((Cons)mrubucket.value == mrutimestamp) {
                entry = Cons.findMemoizedValueEntry(mrubucket, arg1, arg2, arg3, arg4, eqvector, false);
                if (entry != null) {
                    return entry;
                }
            } else {
                mrubucket.value = mrutimestamp;
                mrubucket.rest = Stella.NIL;
            }
        }
        if ((lrubucket = (Cons)(lrubuckets = memotable.lruBuckets)[bucketindex]) != null) {
            if ((Cons)lrubucket.value == memotable.lruTimestamp) {
                entry = Cons.findMemoizedValueEntry(lrubucket, arg1, arg2, arg3, arg4, eqvector, true);
            } else {
                lrubucket.rest = Stella.NIL;
            }
        }
        if (entry == null) {
            entry = Stella_Object.makeMemoizedValueEntry(null, arg1, arg2, arg3, arg4);
        }
        if (mrubucket != null) {
            mrubucket.rest = Stella_Object.cons(entry, mrubucket.rest);
        } else {
            mrubuckets[bucketindex] = Stella_Object.cons(mrutimestamp, Stella_Object.cons(entry, Stella.NIL));
        }
        if (--memotable.freeEntries == 0) {
            memotable.mruBuckets = lrubuckets;
            memotable.lruBuckets = mrubuckets;
            memotable.currentTimestamp = memotable.mruTimestamp = Stella_Object.cons(null, Stella.NIL);
            memotable.lruTimestamp = mrutimestamp;
            memotable.freeEntries = memotable.maxEntries;
        }
        return entry;
    }

    public static void initializeMruBucketTables(MruMemoizationTable memotable) {
        memotable.nofBuckets = Stella.pickHashTableSizePrime(memotable.maxEntries);
        memotable.mruBucketsVector = Vector.newVector(memotable.nofBuckets);
        memotable.lruBucketsVector = Vector.newVector(memotable.nofBuckets);
        memotable.mruBuckets = memotable.mruBucketsVector.theArray;
        memotable.lruBuckets = memotable.lruBucketsVector.theArray;
        memotable.freeEntries = memotable.maxEntries;
        memotable.mruTimestamp = memotable.currentTimestamp = Stella_Object.cons(null, Stella.NIL);
        memotable.lruTimestamp = memotable.currentTimestamp;
    }

    public static Stella_Object accessMruMemoizationTableSlotValue(MruMemoizationTable self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_MRU_BUCKETS_VECTOR) {
            if (setvalueP) {
                self.mruBucketsVector = (Vector)value;
            } else {
                value = self.mruBucketsVector;
            }
        } else if (slotname == Stella.SYM_STELLA_LRU_BUCKETS_VECTOR) {
            if (setvalueP) {
                self.lruBucketsVector = (Vector)value;
            } else {
                value = self.lruBucketsVector;
            }
        } else if (slotname == Stella.SYM_STELLA_MRU_TIMESTAMP) {
            if (setvalueP) {
                self.mruTimestamp = (Cons)value;
            } else {
                value = self.mruTimestamp;
            }
        } else if (slotname == Stella.SYM_STELLA_LRU_TIMESTAMP) {
            if (setvalueP) {
                self.lruTimestamp = (Cons)value;
            } else {
                value = self.lruTimestamp;
            }
        } else if (slotname == Stella.SYM_STELLA_NOF_BUCKETS) {
            if (setvalueP) {
                self.nofBuckets = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.nofBuckets);
            }
        } else if (slotname == Stella.SYM_STELLA_FREE_ENTRIES) {
            if (setvalueP) {
                self.freeEntries = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.freeEntries);
            }
        } else if (slotname == Stella.SYM_STELLA_MAX_ENTRIES) {
            if (setvalueP) {
                self.maxEntries = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.maxEntries);
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        MruMemoizationTable self = this;
        return Stella.SGT_STELLA_MRU_MEMOIZATION_TABLE;
    }
}

