/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.AllPurposeIterator;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.Context;
import edu.isi.stella.HookList;
import edu.isi.stella.Iterator;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.List;
import edu.isi.stella.ListIterator;
import edu.isi.stella.MemoizationTable;
import edu.isi.stella.MethodSlot;
import edu.isi.stella.MruMemoizationTable;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.PropertyList;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringToIntegerHashTable;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.VerbatimStringWrapper;
import edu.isi.stella.World;
import edu.isi.stella.javalib.Native;

public class Module
extends Context {
    public List parentModules;
    public String documentation;
    public List nicknames;
    public List uses;
    public List usedBy;
    public List requires;
    public boolean caseSensitiveP;
    public String moduleFullName;
    public String moduleName;
    public String moduleStringifiedSource;
    public String stringifiedOptions;
    public Module cardinalModule;
    public StringToIntegerHashTable symbolOffsetTable;
    public StringToIntegerHashTable surrogateOffsetTable;
    public World strictInferenceCache;
    public World defaultInferenceCache;
    public World prototypeInferenceCache;

    public static Module defineModuleFromStringifiedSource(String name, String stringifiedoptions) {
        return Module.defineModule(name, (Cons)Stella.readSExpressionFromString(stringifiedoptions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Module defineModule(String name, Cons options) {
        Object old$Shadowedsurrogates$000 = Stella.$SHADOWEDSURROGATES$.get();
        try {
            Native.setSpecial(Stella.$SHADOWEDSURROGATES$, Stella.NIL);
            Module module = null;
            String stringifiedoptions = Native.stringify(options);
            Module oldmodule = null;
            oldmodule = Stella.getStellaModule(name, false);
            if (oldmodule != null && Module.identicalModuleStructureP(oldmodule, null, stringifiedoptions)) {
                Module.updateNonStructuralModuleOptions(oldmodule, null, stringifiedoptions);
                Module module2 = oldmodule;
                return module2;
            }
            module = Module.newModule();
            module.stringifiedOptions = stringifiedoptions;
            Module.incorporateModuleOptions(module, options);
            Module.incorporateModuleName(module, name);
            module.baseModule = module;
            if (oldmodule != null) {
                if (Module.identicalModuleStructureP(oldmodule, module, null)) {
                    Module.updateNonStructuralModuleOptions(oldmodule, module, null);
                    module.unfinalizeModule();
                    Module module3 = oldmodule;
                    return module3;
                }
                if (oldmodule == (Module)Stella.$MODULE$.get()) {
                    Stella.STANDARD_WARNING.nativeStream.println("Warning: Can't define a module inside of itself.");
                    System.out.println("Skipping redefinition of module " + name + ".");
                    module.unfinalizeModule();
                    Module module4 = oldmodule;
                    return module4;
                }
                Module.undefineModule(oldmodule, module);
            }
            Module.finalizeModule(module);
            if (oldmodule != null) {
                Context c = null;
                AllPurposeIterator iter000 = Context.allSubcontexts(module, Stella.KWD_TOPDOWN);
                while (iter000.nextP()) {
                    Context c000;
                    c = (Context)iter000.value;
                    Surrogate testValue000 = Stella_Object.safePrimaryType(c);
                    if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_MODULE)) {
                        c000 = (Module)c;
                        if (c000.uses.emptyP()) {
                            c000.uses = Stella.list(Stella_Object.cons(c000, Stella.NIL));
                        }
                        Module.finalizeModule(c000);
                        continue;
                    }
                    if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_WORLD)) {
                        c000 = (World)c;
                        World.finalizeWorld((World)c000);
                        continue;
                    }
                    OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                    stream000.nativeStream.print("`" + testValue000 + "' is not a valid case option");
                    throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
                }
            }
            Keyword.bumpMemoizationTimestamp(Stella.KWD_MODULE_UPDATE);
            HookList.runHooks(Stella.$DEFINE_MODULE_HOOKS$, module);
            Module module5 = module;
            return module5;
        }
        finally {
            Stella.$SHADOWEDSURROGATES$.set(old$Shadowedsurrogates$000);
        }
    }

    public static Module newModule() {
        Module self = null;
        self = new Module();
        self.dynamicSlots = KeyValueList.newKeyValueList();
        self.surrogateValueInverse = null;
        self.contextNumber = Integer.MIN_VALUE;
        self.allSuperContexts = null;
        self.baseModule = null;
        self.childContexts = List.newList();
        self.prototypeInferenceCache = null;
        self.defaultInferenceCache = null;
        self.strictInferenceCache = null;
        self.surrogateOffsetTable = null;
        self.symbolOffsetTable = null;
        self.cardinalModule = null;
        self.stringifiedOptions = null;
        self.moduleStringifiedSource = null;
        self.moduleName = null;
        self.moduleFullName = null;
        self.caseSensitiveP = false;
        self.requires = null;
        self.usedBy = List.newList();
        self.uses = List.newList();
        self.nicknames = null;
        self.documentation = null;
        self.parentModules = List.newList();
        return self;
    }

    public void helpPrintOutline(OutputStream stream, int currentDepth, int depth, boolean namedP) {
        Module top = this;
        Stella.indentOutline(currentDepth, stream);
        stream.nativeStream.println(top.name());
        if (depth == Integer.MIN_VALUE || depth < 0 || currentDepth < depth) {
            ++currentDepth;
            Context c = null;
            Cons iter000 = top.childContexts.theConsList;
            while (iter000 != Stella.NIL) {
                c = (Context)iter000.value;
                c.helpPrintOutline(stream, currentDepth, depth, namedP);
                iter000 = iter000.rest;
            }
        }
    }

    public static String javaPackagePrefix(Module module, String separator) {
        String result = "";
        char separatorChar = separator.charAt(0);
        String packagePrefix = module.javaPackage();
        if (packagePrefix != null) {
            result = separatorChar == '.' ? packagePrefix : Native.string_substitute(packagePrefix, separatorChar, '.');
            return result + separator;
        }
        result = Stella.javaTranslateNamestring(Native.stringDowncase(module.name())) + separator;
        Context mod = null;
        Iterator iter000 = module.parentContexts();
        while (iter000.nextP()) {
            mod = (Context)iter000.value;
            if (!Stella_Object.isaP(mod, Stella.SGT_STELLA_MODULE) || mod == Stella.$ROOT_MODULE$) continue;
            result = Module.javaPackagePrefix((Module)mod, separator) + result;
            break;
        }
        if (separatorChar == '.') {
            KeyValueList.setDynamicSlotValue(module.dynamicSlots, Stella.SYM_STELLA_JAVA_PACKAGE, StringWrapper.wrapString(Native.string_subsequence(result, 0, result.length() - 1)), Stella.NULL_STRING_WRAPPER);
        }
        return result;
    }

    public static boolean omitJavaPackagePrefixP(Module module, String stellaClassName) {
        if (((List)Stella.$CURRENT_STELLA_FEATURES$.get()).membP(Stella.KWD_MINIMIZE_JAVA_PREFIXES)) {
            return Module.inCurrentJavaPackageP(module) || (((Module)Stella.$MODULE$.get()).uses.membP(module) || ((Module)Stella.$MODULE$.get()).allSuperContexts.membP(module)) && !Stella.inheritedClassNameConflictsP(stellaClassName);
        }
        return Module.inCurrentJavaPackageP(module);
    }

    public static boolean inCurrentJavaPackageP(Module module) {
        return module == (Module)Stella.$MODULE$.get() || Stella.stringEqlP(Module.javaPackagePrefix(module, "."), Module.javaPackagePrefix((Module)Stella.$MODULE$.get(), "."));
    }

    public static String javaYieldFlotsamClassName(Module mod) {
        String flotsamclassname = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)mod.dynamicSlots, (Symbol)Stella.SYM_STELLA_JAVA_FLOTSAM_CLASS, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
        if (flotsamclassname != null && flotsamclassname != "") {
            return flotsamclassname;
        }
        flotsamclassname = StringWrapper.javaTranslateClassNamestring((StringWrapper)StringWrapper.wrapString((String)mod.name())).wrapperValue;
        KeyValueList.setDynamicSlotValue(mod.dynamicSlots, Stella.SYM_STELLA_JAVA_FLOTSAM_CLASS, StringWrapper.wrapString(flotsamclassname), Stella.NULL_STRING_WRAPPER);
        return flotsamclassname;
    }

    public static String javaMakeGlobalOutputFileName(Module module, boolean donttruncateP) {
        return Stella.string_javaMakeCodeOutputFileName(Module.javaYieldFlotsamClassName(module), donttruncateP);
    }

    public static String cppYieldNamespacePrefixFromModule(Module module) {
        boolean packageprefixinheritedP;
        if (module == null) {
            module = (Module)Stella.$MODULE$.get();
        }
        String packageprefix = module.cppPackage();
        boolean bl = packageprefixinheritedP = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)module.dynamicSlots, (Symbol)Stella.SYM_STELLA_MODULE_CPP_PACKAGE, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue == null;
        if (packageprefixinheritedP) {
            String relativemodulepath = module.moduleFullName;
            return packageprefix + Stella.cppSubstituteForbiddenCharacters(Native.string_substitute(Native.stringDowncase(relativemodulepath), '_', '/'), Stella.KWD_LOWERCASE);
        }
        return packageprefix;
    }

    public static void cppOutputNamespaceChange(Module fromnamespace, Module tonamespace) {
        if (!(tonamespace == fromnamespace || fromnamespace != null && Stella.stringEqlP(Module.cppYieldNamespacePrefixFromModule(fromnamespace), Module.cppYieldNamespacePrefixFromModule(tonamespace)))) {
            if (fromnamespace != null) {
                ((OutputStream)Stella.$CURRENT_STREAM$.get()).nativeStream.println();
                Module.cppOutputNamespaceFooter(fromnamespace);
                ((OutputStream)Stella.$CURRENT_STREAM$.get()).nativeStream.println();
                ((OutputStream)Stella.$CURRENT_STREAM$.get()).nativeStream.println();
            }
            Module.cppOutputNamespaceHeader(tonamespace);
        }
    }

    public static void cppOutputNamespaceFooter(Module module) {
        ((OutputStream)Stella.$CURRENT_STREAM$.get()).nativeStream.println("} // end of namespace " + Module.cppYieldNamespacePrefixFromModule(module));
    }

    public static void cppOutputNamespaceHeader(Module module) {
        ((OutputStream)Stella.$CURRENT_STREAM$.get()).nativeStream.println("namespace " + Module.cppYieldNamespacePrefixFromModule(module) + " {");
        Module usee = null;
        Cons iter000 = Cons.copyConsList(Module.visibleModules((Module)module).consify().rest).reverse();
        while (iter000 != Stella.NIL) {
            usee = (Module)iter000.value;
            ((OutputStream)Stella.$CURRENT_STREAM$.get()).nativeStream.println("  using namespace " + Module.cppYieldNamespacePrefixFromModule(usee) + ";");
            iter000 = iter000.rest;
        }
        ((OutputStream)Stella.$CURRENT_STREAM$.get()).nativeStream.println();
    }

    public static String xmoduleStringifiedSource(Module self) {
        return "(defmodule " + self.moduleName + " " + self.stringifiedOptions + ")";
    }

    public void describeObject(OutputStream stream, Keyword mode) {
        Module self = this;
        if (mode == Stella.KWD_SOURCE) {
            Cons.prettyPrintStellaTree((Cons)Stella.readSExpressionFromString(Module.xmoduleStringifiedSource(self)), stream);
        } else if (mode == Stella.KWD_TERSE) {
            Stella_Object.describeTersely(self, stream);
        } else if (mode == Stella.KWD_VERBOSE) {
            Cons.prettyPrintDefinitionTree(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_DEFMODULE, Stella_Object.cons(StringWrapper.wrapString(self.moduleName), Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.KWD_INCLUDES, Stella_Object.cons(self.parentModules, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.KWD_USES, Stella_Object.cons(self.uses, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.KWD_SHADOWS, Stella_Object.cons(self.shadowedSurrogates(), Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_gg_INFERRED_SLOTS, Stella_Object.cons(Stella.KWD_CHILDREN, Stella_Object.cons(self.childContexts, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.KWD_USED_BY, Stella_Object.cons(self.usedBy, Stella_Object.cons(Stella.list$(Stella_Object.cons(Stella.KWD_CARDINAL_MODULE, Stella_Object.cons(self.cardinalModule, Stella_Object.cons(Stella.NIL, Stella.NIL)))), Stella.NIL)))), Stella.NIL))))), Stella.NIL)))), Stella.NIL)))), Stella.NIL)))), Stella.NIL)))), stream);
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + mode + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDefinition(OutputStream stream) {
        Module self = this;
        Object old$PrintreadablyP$000 = Stella.$PRINTREADABLYp$.get();
        try {
            Native.setBooleanSpecial(Stella.$PRINTREADABLYp$, true);
            stream.nativeStream.print("(DEFMODULE \"" + self.moduleFullName + "\"");
            for (Cons options = (Cons)Stella.readSExpressionFromString(self.stringifiedOptions); options != Stella.NIL; options = options.nthRest(2)) {
                stream.nativeStream.println();
                stream.nativeStream.print("  " + options.value + " " + options.rest.value);
            }
            stream.nativeStream.println(")");
        }
        finally {
            Stella.$PRINTREADABLYp$.set(old$PrintreadablyP$000);
        }
    }

    public static boolean cardinalModuleP(Module self) {
        return self.cardinalModule == self;
    }

    public static Cons helpMemoizeVisibleModules(Module from) {
        Cons visiblemodules = Stella.NIL;
        visiblemodules = Stella_Object.cons(from, visiblemodules);
        Context renamed_Super = null;
        Cons iter000 = from.allSuperContexts;
        while (iter000 != Stella.NIL) {
            renamed_Super = (Context)iter000.value;
            visiblemodules = Stella_Object.cons(renamed_Super, visiblemodules);
            iter000 = iter000.rest;
        }
        Module usee = null;
        Cons iter001 = from.uses.theConsList;
        while (iter001 != Stella.NIL) {
            usee = (Module)iter001.value;
            if (!visiblemodules.membP(usee)) {
                visiblemodules = Stella_Object.cons(usee, visiblemodules);
            }
            Context useesuper = null;
            Cons iter002 = usee.allSuperContexts;
            while (iter002 != Stella.NIL) {
                useesuper = (Context)iter002.value;
                if (!visiblemodules.membP(useesuper)) {
                    visiblemodules = Stella_Object.cons(useesuper, visiblemodules);
                }
                iter002 = iter002.rest;
            }
            iter001 = iter001.rest;
        }
        return visiblemodules.reverse();
    }

    public static Cons visibleModules(Module from) {
        if (from == null) {
            from = (Module)Stella.$MODULE$.get();
        }
        MemoizationTable memoTable000 = null;
        Cons memoizedEntry000 = null;
        Stella_Object memoizedValue000 = null;
        if (Stella.$MEMOIZATION_ENABLEDp$) {
            memoTable000 = (MemoizationTable)Stella.SGT_STELLA_F_VISIBLE_MODULES_MEMO_TABLE_000.surrogateValue;
            if (memoTable000 == null) {
                Surrogate.initializeMemoizationTable(Stella.SGT_STELLA_F_VISIBLE_MODULES_MEMO_TABLE_000, "(:MAX-VALUES 50 :TIMESTAMPS (:MODULE-UPDATE))");
                memoTable000 = (MemoizationTable)Stella.SGT_STELLA_F_VISIBLE_MODULES_MEMO_TABLE_000.surrogateValue;
            }
            memoizedEntry000 = MruMemoizationTable.lookupMruMemoizedValue((MruMemoizationTable)memoTable000, from, Stella.MEMOIZED_NULL_VALUE, null, null, -1);
            memoizedValue000 = memoizedEntry000.value;
        }
        if (memoizedValue000 != null) {
            if (memoizedValue000 == Stella.MEMOIZED_NULL_VALUE) {
                memoizedValue000 = null;
            }
        } else {
            memoizedValue000 = Module.helpMemoizeVisibleModules(from);
            if (Stella.$MEMOIZATION_ENABLEDp$) {
                memoizedEntry000.value = memoizedValue000 == null ? Stella.MEMOIZED_NULL_VALUE : memoizedValue000;
            }
        }
        Cons value000 = memoizedValue000;
        return value000;
    }

    public static Iterator allIncludedModules(Module self) {
        Cons copy = Cons.copyConsList(self.allSuperContexts);
        copy = Stella_Object.cons(self, copy);
        return copy.reverse().allocateDestructiveListIterator();
    }

    public static Cons yieldDefineModule(Module module) {
        return Stella.list$(Stella_Object.cons(Stella.SYM_STELLA_DEFINE_MODULE_FROM_STRINGIFIED_SOURCE, Stella_Object.cons(StringWrapper.wrapString(module.moduleFullName), Stella_Object.cons(Stella_Object.cons(Stella.yieldStringConstantTree(module.stringifiedOptions), Stella.NIL), Stella.NIL))));
    }

    public static boolean identicalModuleStructureP(Module oldmodule, Module newmodule, String newoptions) {
        if (newmodule != null && !Stella.stringEqlP(oldmodule.moduleFullName, newmodule.moduleFullName)) {
            return false;
        }
        String oldoptions = oldmodule.stringifiedOptions;
        String string = newoptions = newmodule == null ? newoptions : newmodule.stringifiedOptions;
        if (newoptions == null) {
            return false;
        }
        if (Stella.eqlExceptInWhitespaceP(oldoptions, newoptions)) {
            return true;
        }
        if (Native.stringSearch(oldoptions, ":INCLUDES", 0) == Integer.MIN_VALUE && Native.stringSearch(newoptions, ":INCLUDES", 0) == Integer.MIN_VALUE) {
            return false;
        }
        if (newmodule != null && Stella_Object.equalConsTreesP(oldmodule.parentModules.theConsList, newmodule.parentModules.theConsList)) {
            PropertyList self000 = PropertyList.newPropertyList();
            self000.thePlist = (Cons)Stella.readSExpressionFromString(oldoptions);
            PropertyList oldplist = self000;
            PropertyList self001 = PropertyList.newPropertyList();
            self001.thePlist = (Cons)Stella.readSExpressionFromString(newoptions);
            PropertyList newplist = self001;
            oldplist.removeAt(Stella.KWD_INCLUDES);
            newplist.removeAt(Stella.KWD_INCLUDES);
            Stella_Object key = null;
            Stella_Object value = null;
            Cons iter000 = oldplist.thePlist;
            while (iter000 != Stella.NIL) {
                key = iter000.value;
                value = iter000.rest.value;
                if (!Stella.$MODULE_NON_STRUCTURAL_OPTIONS$.memberP(key) && !Stella_Object.equalConsTreesP(value, newplist.lookup(key))) {
                    return false;
                }
                iter000 = iter000.rest.rest;
            }
            key = null;
            value = null;
            Cons iter001 = newplist.thePlist;
            while (iter001 != Stella.NIL) {
                key = iter001.value;
                value = iter001.rest.value;
                if (!Stella.$MODULE_NON_STRUCTURAL_OPTIONS$.memberP(key) && !Stella_Object.equalConsTreesP(value, oldplist.lookup(key))) {
                    return false;
                }
                iter001 = iter001.rest.rest;
            }
            return true;
        }
        return false;
    }

    public static void updateNonStructuralModuleOptions(Module oldmodule, Module newmodule, String newoptions) {
        if (newoptions == null) {
            newoptions = newmodule.stringifiedOptions;
        }
        PropertyList self000 = PropertyList.newPropertyList();
        self000.thePlist = (Cons)Stella.readSExpressionFromString(oldmodule.stringifiedOptions);
        PropertyList oldplist = self000;
        PropertyList self001 = PropertyList.newPropertyList();
        self001.thePlist = (Cons)Stella.readSExpressionFromString(newoptions);
        PropertyList newplist = self001;
        Stella_Object oldvalue = null;
        Stella_Object newvalue = null;
        Cons changedValues = Stella.NIL;
        Keyword option = null;
        Cons iter000 = Stella.$MODULE_NON_STRUCTURAL_OPTIONS$;
        while (iter000 != Stella.NIL) {
            option = (Keyword)iter000.value;
            oldvalue = oldplist.lookup(option);
            if (!Stella_Object.eqlP(oldvalue, newvalue = newplist.lookup(option))) {
                if (newvalue != null) {
                    changedValues = Stella_Object.cons(newvalue, changedValues);
                } else {
                    if (newmodule == null) {
                        newmodule = Module.newModule();
                    }
                    changedValues = Stella_Object.cons(StandardObject.readSlotValue(newmodule, Surrogate.lookupSlotFromOptionKeyword(newmodule.primaryType(), option)), changedValues);
                }
                changedValues = Stella_Object.cons(option, changedValues);
            }
            iter000 = iter000.rest;
        }
        if (changedValues != Stella.NIL) {
            System.out.println("Updating module `" + oldmodule + "'");
            Module.incorporateModuleOptions(oldmodule, changedValues);
            oldmodule.stringifiedOptions = newoptions;
        }
    }

    public static void undefineModule(Module oldmodule, Module newmodule) {
        Context c;
        System.out.println("Redefining the module `" + oldmodule.contextName() + "'");
        if (Stella.$SUBCONTEXT_REVISION_POLICY$ == Stella.KWD_DESTROY) {
            oldmodule.destroyContext();
            return;
        }
        if (Stella.$SUBCONTEXT_REVISION_POLICY$ != Stella.KWD_PRESERVE) {
            if (Stella.$SUBCONTEXT_REVISION_POLICY$ == Stella.KWD_CLEAR) {
                c = null;
                AllPurposeIterator iter000 = Context.allSubcontexts(oldmodule, Stella.KWD_PREORDER);
                while (iter000.nextP()) {
                    c = (Context)iter000.value;
                    Context.clearContext(c);
                }
            } else {
                OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                stream000.nativeStream.print("`" + Stella.$SUBCONTEXT_REVISION_POLICY$ + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
            }
        }
        if (Module.cardinalModuleP(oldmodule)) {
            Stella.$ROOT_MODULE$.childContexts.remove(oldmodule);
        } else {
            Module p = null;
            Cons iter001 = oldmodule.parentModules.theConsList;
            while (iter001 != Stella.NIL) {
                p = (Module)iter001.value;
                p.childContexts.remove(oldmodule);
                iter001 = iter001.rest;
            }
        }
        c = null;
        Cons iter002 = oldmodule.childContexts.theConsList;
        while (iter002 != Stella.NIL) {
            Context c000;
            c = (Context)iter002.value;
            Surrogate testValue000 = Stella_Object.safePrimaryType(c);
            if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_MODULE)) {
                c000 = (Module)c;
                c000.parentModules.theConsList.substitute(newmodule, oldmodule);
            } else if (Surrogate.subtypeOfP(testValue000, Stella.SGT_STELLA_WORLD)) {
                c000 = (World)c;
                ((World)c000).parentContext = newmodule;
            } else {
                OutputStringStream stream001 = OutputStringStream.newOutputStringStream();
                stream001.nativeStream.print("`" + testValue000 + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException(stream001.theStringReader()).fillInStackTrace();
            }
            iter002 = iter002.rest;
        }
        newmodule.childContexts.theConsList = oldmodule.childContexts.theConsList;
        oldmodule.childContexts.theConsList = Stella.NIL;
        oldmodule.surrogateValueInverse = null;
        oldmodule.unfinalizeModule();
        oldmodule.free();
    }

    public static void incorporateModuleOptions(Module self, Cons options) {
        PropertyList self000 = PropertyList.newPropertyList();
        self000.thePlist = options;
        PropertyList plist = Stella_Object.vetOptions(self000, Stella.getQuotedTree("((:NICKNAME :INCLUDES :USES :DOCUMENTATION :SHADOW :CASE-SENSITIVE? :LISP-PACKAGE :CPP-PACKAGE :JAVA-PACKAGE :JAVA-CATCHALL-CLASS :API? :CLEARABLE? :PROTECT-SURROGATES? :CODE-ONLY? :NAMESPACE?) \"/STELLA\")", "/STELLA"));
        Stella_Object key = null;
        Stella_Object value = null;
        Cons iter000 = plist.thePlist;
        while (iter000 != Stella.NIL) {
            key = iter000.value;
            value = iter000.rest.value;
            Keyword testValue000 = (Keyword)key;
            if (testValue000 == Stella.KWD_INCLUDES) {
                Module.incorporateIncludesModules(self, value);
            } else if (testValue000 == Stella.KWD_USES) {
                Module.incorporateUsesModules(self, value);
            } else if (testValue000 == Stella.KWD_SHADOW) {
                Native.setSpecial(Stella.$SHADOWEDSURROGATES$, (Cons)value);
            } else {
                value = Stella_Object.permanentCopy(value);
                Keyword testValue001 = (Keyword)key;
                if (testValue001 == Stella.KWD_DOCUMENTATION) {
                    self.documentation = StringWrapper.unwrapString((StringWrapper)value);
                } else if (testValue001 == Stella.KWD_CASE_SENSITIVEp) {
                    self.caseSensitiveP = value == Stella.SYM_STELLA_TRUE || Stella_Object.eqlP(value, Stella.TRUE_WRAPPER) || Stella_Object.isaP(value, Stella.SGT_STELLA_SYMBOL) && Stella.stringEqualP(((Symbol)value).symbolName, "TRUE");
                } else if (testValue001 == Stella.KWD_APIp) {
                    KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_APIp, value == Stella.SYM_STELLA_TRUE || Stella_Object.eqlP(value, Stella.TRUE_WRAPPER) || Stella_Object.isaP(value, Stella.SGT_STELLA_SYMBOL) && Stella.stringEqualP(((Symbol)value).symbolName, "TRUE") ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER, Stella.FALSE_WRAPPER);
                } else if (testValue001 == Stella.KWD_LISP_PACKAGE) {
                    KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_MODULE_LISP_PACKAGE, StringWrapper.wrapString(StringWrapper.unwrapString((StringWrapper)value)), Stella.NULL_STRING_WRAPPER);
                } else if (testValue001 == Stella.KWD_CPP_PACKAGE) {
                    KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_MODULE_CPP_PACKAGE, StringWrapper.wrapString(StringWrapper.unwrapString((StringWrapper)value)), Stella.NULL_STRING_WRAPPER);
                } else if (testValue001 == Stella.KWD_JAVA_PACKAGE) {
                    KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_JAVA_PACKAGE, StringWrapper.wrapString(StringWrapper.unwrapString((StringWrapper)value)), Stella.NULL_STRING_WRAPPER);
                } else if (testValue001 == Stella.KWD_JAVA_CATCHALL_CLASS) {
                    KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_JAVA_FLOTSAM_CLASS, StringWrapper.wrapString(StringWrapper.unwrapString((StringWrapper)value)), Stella.NULL_STRING_WRAPPER);
                } else if (testValue001 == Stella.KWD_NICKNAME) {
                    if (self.nicknames == null) {
                        self.nicknames = List.newList();
                    }
                    self.nicknames.insert((StringWrapper)value);
                } else if (testValue001 == Stella.KWD_CLEARABLEp) {
                    KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_CLEARABLEp, value == Stella.SYM_STELLA_TRUE || Stella_Object.eqlP(value, Stella.TRUE_WRAPPER) || Stella_Object.isaP(value, Stella.SGT_STELLA_SYMBOL) && Stella.stringEqualP(((Symbol)value).symbolName, "TRUE") ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER, Stella.FALSE_WRAPPER);
                } else if (testValue001 == Stella.KWD_PROTECT_SURROGATESp) {
                    KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_PROTECT_SURROGATESp, value == Stella.SYM_STELLA_TRUE || Stella_Object.eqlP(value, Stella.TRUE_WRAPPER) || Stella_Object.isaP(value, Stella.SGT_STELLA_SYMBOL) && Stella.stringEqualP(((Symbol)value).symbolName, "TRUE") ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER, Stella.FALSE_WRAPPER);
                } else if (testValue001 == Stella.KWD_CODE_ONLYp) {
                    KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_CODE_ONLYp, value == Stella.SYM_STELLA_TRUE || Stella_Object.eqlP(value, Stella.TRUE_WRAPPER) || Stella_Object.isaP(value, Stella.SGT_STELLA_SYMBOL) && Stella.stringEqualP(((Symbol)value).symbolName, "TRUE") ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER, Stella.FALSE_WRAPPER);
                } else if (testValue001 == Stella.KWD_NAMESPACEp) {
                    KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_NAMESPACEp, value == Stella.SYM_STELLA_TRUE || Stella_Object.eqlP(value, Stella.TRUE_WRAPPER) || Stella_Object.isaP(value, Stella.SGT_STELLA_SYMBOL) && Stella.stringEqualP(((Symbol)value).symbolName, "TRUE") ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER, Stella.FALSE_WRAPPER);
                } else if (testValue001 == Stella.KWD_REQUIRES) {
                    self.requires = (List)value;
                } else {
                    OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                    stream000.nativeStream.print("`" + testValue001 + "' is not a valid case option");
                    throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
                }
            }
            iter000 = iter000.rest.rest;
        }
        plist.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incorporateUsesModules(Module module, Stella_Object usees) {
        Surrogate testValue000 = Stella_Object.safePrimaryType(usees);
        if (testValue000 == Stella.SGT_STELLA_CONS) {
            Cons usees000 = (Cons)usees;
            Stella_Object name = null;
            Cons iter000 = usees000;
            while (iter000 != Stella.NIL) {
                name = iter000.value;
                Module.incorporateUsesModules(module, name);
                iter000 = iter000.rest;
            }
            if (module.uses.emptyP()) {
                module.uses.insert(module);
            }
        } else if (Surrogate.subtypeOfStringP(testValue000)) {
            StringWrapper usees000 = (StringWrapper)usees;
            Module useemodule = Stella_Object.coerceToModule(usees000, true);
            if (useemodule != null) {
                if (!module.uses.memberP(useemodule)) {
                    module.uses.insertLast(useemodule);
                }
                useemodule.usedBy.insertNew(module);
            }
        } else if (Surrogate.subtypeOfSymbolP(testValue000)) {
            Symbol usees000 = (Symbol)usees;
            Module useemodule = Stella_Object.coerceToModule(usees000, true);
            if (useemodule != null) {
                if (!module.uses.memberP(useemodule)) {
                    module.uses.insertLast(useemodule);
                }
                useemodule.usedBy.insertNew(module);
            }
        } else {
            Object old$PrintreadablyP$000 = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial(Stella.$PRINTREADABLYp$, true);
                Stella.signalTranslationError();
                if (!Stella.suppressWarningsP()) {
                    Stella.printErrorContext(">> ERROR: ", Stella.STANDARD_ERROR);
                    Stella.STANDARD_ERROR.nativeStream.println();
                    Stella.STANDARD_ERROR.nativeStream.println(" Illegal argument to ':uses' option .");
                }
            }
            finally {
                Stella.$PRINTREADABLYp$.set(old$PrintreadablyP$000);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void incorporateIncludesModules(Module module, Stella_Object includees) {
        Surrogate testValue000 = Stella_Object.safePrimaryType(includees);
        if (testValue000 == Stella.SGT_STELLA_CONS) {
            Cons includees000 = (Cons)includees;
            Stella_Object name = null;
            Cons iter000 = includees000;
            while (iter000 != Stella.NIL) {
                name = iter000.value;
                Module.incorporateIncludesModules(module, name);
                iter000 = iter000.rest;
            }
            return;
        } else if (Surrogate.subtypeOfStringP(testValue000)) {
            StringWrapper includees000 = (StringWrapper)includees;
            Module includeemodule = Stella_Object.coerceToModule(includees000, true);
            if (includeemodule == null) return;
            if (!module.parentModules.memberP(includeemodule)) {
                module.parentModules.insertLast(includeemodule);
            }
            includeemodule.childContexts.insertNew(module);
            return;
        } else if (Surrogate.subtypeOfSymbolP(testValue000)) {
            Symbol includees000 = (Symbol)includees;
            Module includeemodule = Stella_Object.coerceToModule(includees000, true);
            if (includeemodule == null) return;
            if (!module.parentModules.memberP(includeemodule)) {
                module.parentModules.insertLast(includeemodule);
            }
            includeemodule.childContexts.insertNew(module);
            return;
        } else {
            Object old$PrintreadablyP$000 = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial(Stella.$PRINTREADABLYp$, true);
                Stella.signalTranslationError();
                if (Stella.suppressWarningsP()) return;
                Stella.printErrorContext(">> ERROR: ", Stella.STANDARD_ERROR);
                Stella.STANDARD_ERROR.nativeStream.println();
                Stella.STANDARD_ERROR.nativeStream.println(" Illegal argument to ':includes' option`" + Stella_Object.deUglifyParseTree(includees) + "'.");
                return;
            }
            finally {
                Stella.$PRINTREADABLYp$.set(old$PrintreadablyP$000);
            }
        }
    }

    public static void incorporateModuleName(Module module, String name) {
        Module parentmodule = null;
        String barename = null;
        if (Stella.qualifiedStellaNameP(name)) {
            Object[] caller_MV_returnarray = new Object[1];
            parentmodule = Stella.computeModuleAndBareName(name, caller_MV_returnarray);
            barename = ((StringWrapper)caller_MV_returnarray[0]).wrapperValue;
            if (parentmodule == null) {
                Stella.STANDARD_WARNING.nativeStream.println("Warning: Bad path name `" + name + "' when defining the module `" + barename + "'");
                return;
            }
            boolean testValue000 = false;
            if (parentmodule == Stella.$ROOT_MODULE$ && module.parentModules.nonEmptyP()) {
                testValue000 = true;
            } else {
                boolean foundP000 = false;
                Module includedmodule = null;
                Cons iter000 = module.parentModules.theConsList;
                while (iter000 != Stella.NIL) {
                    includedmodule = (Module)iter000.value;
                    if (includedmodule != parentmodule && (includedmodule == parentmodule || includedmodule.allSuperContexts.membP(parentmodule))) {
                        foundP000 = true;
                        break;
                    }
                    iter000 = iter000.rest;
                }
                testValue000 = foundP000;
            }
            if (testValue000) {
                Stella.STANDARD_WARNING.nativeStream.println("Warning: Bad path name `" + name + "' when defining the module `" + barename + "',");
                Stella.STANDARD_WARNING.nativeStream.println("   since it points to a parent of an included module.");
            } else {
                Module.linkToParentModule(module, parentmodule, true);
            }
        } else {
            if (module.parentModules.emptyP()) {
                Module.linkToParentModule(module, Stella.$ROOT_MODULE$, true);
            }
            barename = name;
        }
        module.moduleName = barename;
        module.moduleFullName = Stella.computeFullName("", module);
    }

    public static void linkToParentModule(Module self, Module parent, boolean insertFirstP) {
        if (parent != Stella.$ROOT_MODULE$ && !self.parentModules.memberP(parent)) {
            if (insertFirstP) {
                self.parentModules.insert(parent);
            } else {
                self.parentModules.insertLast(parent);
            }
        }
        parent.childContexts.insertNew(self);
    }

    public void destroyContext() {
        Module self = this;
        Module.destroyModule(self);
    }

    public static void helpDestroyModule(Module self) {
        Context child = null;
        Cons iter000 = self.childContexts.copy().theConsList;
        while (iter000 != Stella.NIL) {
            child = (Context)iter000.value;
            if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(child), Stella.SGT_STELLA_MODULE)) {
                Module child000 = (Module)child;
                Module.helpDestroyModule(child000);
            } else {
                child.destroyContext();
            }
            iter000 = iter000.rest;
        }
        Module parentmodule = self.parentModule();
        HookList.runHooks(Stella.$DESTROY_CONTEXT_HOOKS$, self);
        if (parentmodule == null) {
            parentmodule = self.cardinalModule;
        }
        if (parentmodule == null) {
            parentmodule = Stella.$STELLA_MODULE$;
        }
        self.unfinalizeModule();
        Keyword.bumpMemoizationTimestamp(Stella.KWD_MODULE_UPDATE);
        if (self == (Module)Stella.$MODULE$.get()) {
            parentmodule.changeModule();
        }
    }

    public static void destroyModule(Module self) {
        if (self == Stella.$ROOT_MODULE$ || self == Stella.$STELLA_MODULE$) {
            Stella.STANDARD_WARNING.nativeStream.println("Warning: Can't destroy the root module or the STELLA module.");
            return;
        }
        Context.clearContext(self);
        Module.helpDestroyModule(self);
    }

    public void unfinalizeModule() {
        Module self = this;
        self.uninheritSupercontexts();
        Module.uninheritUsedModules(self);
        if (Module.cardinalModuleP(self)) {
            Stella.$ROOT_MODULE$.childContexts.remove(self);
        } else {
            Module parent = null;
            Cons iter000 = self.parentModules.theConsList;
            while (iter000 != Stella.NIL) {
                parent = (Module)iter000.value;
                parent.childContexts.remove(self);
                iter000 = iter000.rest;
            }
        }
        self.parentModules.clear();
        if (self.contextNumber != Integer.MIN_VALUE) {
            --self.contextNumber;
        }
        self.moduleFullName = null;
        self.cardinalModule = null;
        self.symbolOffsetTable = null;
        self.surrogateOffsetTable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeModule(Module self) {
        self.inheritSupercontexts();
        Module.inheritUsedModules(self);
        self.contextNumber = Stella.$CONTEXT_NUMBER_COUNTER$ += 2;
        self.cardinalModule = self.parentModule() == null ? self : self.parentModule().cardinalModule;
        self.symbolOffsetTable = StringToIntegerHashTable.newStringToIntegerHashTable();
        self.surrogateOffsetTable = StringToIntegerHashTable.newStringToIntegerHashTable();
        if ((Cons)Stella.$SHADOWEDSURROGATES$.get() != Stella.NIL) {
            KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_SHADOWED_SURROGATES, List.newList(), null);
            Object old$Module$000 = Stella.$MODULE$.get();
            try {
                Native.setSpecial(Stella.$MODULE$, self);
                Symbol sym = null;
                Cons iter000 = (Cons)Stella.$SHADOWEDSURROGATES$.get();
                while (iter000 != Stella.NIL) {
                    sym = (Symbol)iter000.value;
                    self.shadowedSurrogates().insertLast(Stella.shadowSurrogate(sym.symbolName));
                    iter000 = iter000.rest;
                }
            }
            finally {
                Stella.$MODULE$.set(old$Module$000);
            }
        }
    }

    public static void uninheritUsedModules(Module module) {
        List usees = module.uses;
        if (usees.emptyP()) {
            usees.push(module);
        } else if (Native.stringSearch(module.stringifiedOptions, ":USES ", 0) == Integer.MIN_VALUE) {
            Module usee = null;
            Cons iter000 = usees.theConsList;
            while (iter000 != Stella.NIL) {
                usee = (Module)iter000.value;
                usee.usedBy.remove(module);
                iter000 = iter000.rest;
            }
            usees.clear();
        }
    }

    public static void inheritUsedModules(Module module) {
        List usees = module.uses;
        if (usees.emptyP()) {
            if (module.parentModules.emptyP()) {
                usees.push(Stella.$STELLA_MODULE$);
                Stella.$STELLA_MODULE$.usedBy.insertNew(module);
            } else {
                Module parent = null;
                Cons iter000 = module.parentModules.theConsList;
                while (iter000 != Stella.NIL) {
                    parent = (Module)iter000.value;
                    Module parentusees = null;
                    Cons iter001 = parent.uses.theConsList;
                    while (iter001 != Stella.NIL) {
                        parentusees = (Module)iter001.value;
                        usees.insertNew(parentusees);
                        parentusees.usedBy.insertNew(module);
                        iter001 = iter001.rest;
                    }
                    iter000 = iter000.rest;
                }
                usees.reverse();
            }
        } else if (usees.memberP(module)) {
            usees.remove(module);
        }
    }

    public void inheritSupercontexts() {
        Module onlyparent;
        Module module = this;
        if (!module.multipleParentsP() && (onlyparent = (Module)module.parentModules.first()) != null) {
            module.allSuperContexts = Stella_Object.cons(onlyparent, onlyparent.allSuperContexts);
            return;
        }
        Cons allsupercontexts = Stella.NIL;
        Cons sublist = null;
        Module.normalizeParentModules(module);
        module.parentModules.reverse();
        Module parent = null;
        Cons iter000 = module.parentModules.theConsList;
        while (iter000 != Stella.NIL) {
            parent = (Module)iter000.value;
            sublist = Stella.NIL;
            Context ancestor = null;
            Cons iter001 = parent.allSuperContexts;
            Cons collect000 = null;
            while (iter001 != Stella.NIL) {
                ancestor = (Context)iter001.value;
                if (!allsupercontexts.memberP(ancestor)) {
                    if (collect000 == null) {
                        collect000 = Stella_Object.cons(ancestor, Stella.NIL);
                        if (sublist == Stella.NIL) {
                            sublist = collect000;
                        } else {
                            Cons.addConsToEndOfConsList(sublist, collect000);
                        }
                    } else {
                        collect000 = collect000.rest = Stella_Object.cons(ancestor, Stella.NIL);
                    }
                }
                iter001 = iter001.rest;
            }
            sublist = Stella_Object.cons(parent, sublist);
            allsupercontexts = sublist.concatenate(allsupercontexts, Stella.NIL);
            iter000 = iter000.rest;
        }
        module.allSuperContexts = allsupercontexts;
        module.parentModules.reverse();
    }

    public static void normalizeParentModules(Module self) {
        if (!self.multipleParentsP()) {
            return;
        }
        List parents = self.parentModules;
        Module supermodule = null;
        Cons iter000 = parents.theConsList;
        while (iter000 != Stella.NIL) {
            supermodule = (Module)iter000.value;
            Module othersupermodule = null;
            Cons iter001 = parents.theConsList;
            while (iter001 != Stella.NIL) {
                othersupermodule = (Module)iter001.value;
                if (othersupermodule != supermodule && supermodule.allSuperContexts.memberP(othersupermodule)) {
                    parents.remove(othersupermodule);
                }
                iter001 = iter001.rest;
            }
            iter000 = iter000.rest;
        }
    }

    public boolean multipleParentsP() {
        Module module = this;
        return module.parentModules.rest() != Stella.NIL;
    }

    public Module changeModule() {
        Module module = this;
        return Module.changeCurrentModule(module);
    }

    public static Module changeCurrentModule(Module module) {
        Native.setSpecial(Stella.$MODULE$, module);
        Native.setSpecial(Stella.$CONTEXT$, module);
        HookList.runHooks(Stella.$CHANGE_MODULE_HOOKS$, module);
        return module;
    }

    public Iterator parentContexts() {
        Module self = this;
        return (ListIterator)self.parentModules.allocateIterator();
    }

    public static Stella_Object yieldGlobalLispSymbol(Module symbolmodule, String symbolname) {
        String lispsymbolpackage = symbolmodule == null || symbolmodule == (Module)Stella.$MODULE$.get() || Stella.stringEqlP(symbolmodule.lispPackage(), ((Module)Stella.$MODULE$.get()).lispPackage()) ? (String)null : symbolmodule.lispPackage();
        String lispsymbolname = Module.yieldReadableSymbolName(symbolmodule, symbolname, false);
        if (lispsymbolpackage == null) {
            return VerbatimStringWrapper.newVerbatimStringWrapper(lispsymbolname);
        }
        return VerbatimStringWrapper.newVerbatimStringWrapper(lispsymbolpackage + "::" + lispsymbolname);
    }

    public static String yieldReadableSymbolName(Module symbolmodule, String symbolname, boolean localP) {
        String lispsymbolname = localP || ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)symbolmodule.dynamicSlots, (Symbol)Stella.SYM_STELLA_MODULE_LISP_PACKAGE, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue != null ? symbolname : Stella.computeFullName(symbolname, symbolmodule);
        Keyword testValue000 = Stella.computeSymbolEscapeCode(lispsymbolname, false);
        if (testValue000 != Stella.KWD_UNESCAPED) {
            if (testValue000 == Stella.KWD_ESCAPED) {
                lispsymbolname = "|" + lispsymbolname + "|";
            } else if (testValue000 == Stella.KWD_COMPLEX_ESCAPED) {
                OutputStringStream s = OutputStringStream.newOutputStringStream();
                Stella.printSymbolNameReadably(lispsymbolname, s.nativeStream, false);
                lispsymbolname = s.theStringReader();
            } else {
                OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                stream000.nativeStream.print("`" + testValue000 + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
            }
        }
        return lispsymbolname;
    }

    public static void printUndefinedMethods(Module module, boolean localP) {
        Cons undefinedmethods = Stella.NIL;
        Stella_Object method = null;
        Iterator iter000 = Module.allMethods(module, localP);
        Cons collect000 = null;
        while (iter000.nextP()) {
            method = (MethodSlot)iter000.value;
            if (!((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)method.dynamicSlots, (Symbol)Stella.SYM_STELLA_FORWARD_DECLARATIONp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue || method.abstractP || MethodSlot.methodContainsUnknownTypeP(method)) continue;
            if (collect000 == null) {
                collect000 = Stella_Object.cons(method, Stella.NIL);
                if (undefinedmethods == Stella.NIL) {
                    undefinedmethods = collect000;
                    continue;
                }
                Cons.addConsToEndOfConsList(undefinedmethods, collect000);
                continue;
            }
            collect000 = collect000.rest = Stella_Object.cons(method, Stella.NIL);
        }
        MethodSlot function = null;
        Iterator iter001 = Module.allFunctions(module, localP);
        Cons collect001 = null;
        while (iter001.nextP()) {
            function = (MethodSlot)iter001.value;
            if (!((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)function.dynamicSlots, (Symbol)Stella.SYM_STELLA_FORWARD_DECLARATIONp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) continue;
            if (collect001 == null) {
                collect001 = Stella_Object.cons(function, Stella.NIL);
                if (undefinedmethods == Stella.NIL) {
                    undefinedmethods = collect001;
                    continue;
                }
                Cons.addConsToEndOfConsList(undefinedmethods, collect001);
                continue;
            }
            collect001 = collect001.rest = Stella_Object.cons(function, Stella.NIL);
        }
        if (undefinedmethods != Stella.NIL) {
            System.out.println("The following functions and methods are declared but not yet defined:");
            method = null;
            Cons iter002 = undefinedmethods;
            while (iter002 != Stella.NIL) {
                method = iter002.value;
                System.out.println("    " + method);
                iter002 = iter002.rest;
            }
        }
    }

    public static Iterator unboundSurrogates(Module module, boolean localP) {
        AllPurposeIterator iterator = AllPurposeIterator.newAllPurposeIterator();
        iterator.iteratorNestedIterator = Module.allSurrogates(module, localP);
        iterator.iteratorNextCode = Native.find_java_method("edu.isi.stella.AllPurposeIterator", "filteredNestedIteratorNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        iterator.iteratorFilterCode = Native.find_java_method("edu.isi.stella.Surrogate", "filterUnboundSurrogateP", new Class[]{Native.find_java_class("edu.isi.stella.Surrogate"), Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        return iterator;
    }

    public static void initializeKernelModule(Module module, String name, String fullname, Module parent) {
        module.moduleName = name;
        module.moduleFullName = fullname;
        if (parent != null) {
            parent.childContexts.insert(module);
            module.cardinalModule = module;
        }
        module.symbolOffsetTable = StringToIntegerHashTable.newStringToIntegerHashTable();
        module.surrogateOffsetTable = StringToIntegerHashTable.newStringToIntegerHashTable();
        module.allSuperContexts = Stella.NIL;
        module.baseModule = module;
        module.contextNumber = Stella.$CONTEXT_NUMBER_COUNTER$ += 2;
        module.stringifiedOptions = "";
    }

    public static StringToIntegerHashTable selectSymbolOffsetTable(Module module, int kindofsym) {
        switch (kindofsym) {
            case 0: {
                return module.symbolOffsetTable;
            }
            case 1: {
                return module.surrogateOffsetTable;
            }
            case 2: {
                return Stella.$KEYWORD_OFFSET_TABLE$;
            }
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("`" + kindofsym + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
    }

    public static Iterator allPublicMethods(Module module, boolean localP) {
        AllPurposeIterator iterator = (AllPurposeIterator)Module.allSlots(module, localP);
        iterator.iteratorFilterCode = Native.find_java_method("edu.isi.stella.Slot", "filterPublicMethodSlotP", new Class[]{Native.find_java_class("edu.isi.stella.Slot"), Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        return iterator;
    }

    public static Iterator allMethods(Module module, boolean localP) {
        AllPurposeIterator iterator = AllPurposeIterator.newAllPurposeIterator();
        iterator.iteratorNextCode = Native.find_java_method("edu.isi.stella.AllPurposeIterator", "slotsNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        iterator.iteratorNestedIterator = Module.allClasses(module, localP);
        iterator.iteratorFilterCode = Native.find_java_method("edu.isi.stella.Slot", "filterMethodSlotP", new Class[]{Native.find_java_class("edu.isi.stella.Slot"), Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        iterator.iteratorConsList = Stella.NIL;
        return iterator;
    }

    public static Iterator allSlots(Module module, boolean localP) {
        AllPurposeIterator iterator = AllPurposeIterator.newAllPurposeIterator();
        iterator.iteratorNextCode = Native.find_java_method("edu.isi.stella.AllPurposeIterator", "slotsNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        iterator.iteratorNestedIterator = Module.allClasses(module, localP);
        iterator.iteratorConsList = Stella.NIL;
        return iterator;
    }

    public static Iterator allClasses(Module module, boolean localP) {
        return Stella.allocateAllMetaObjectsIterator(Stella.$SURROGATE_ARRAY$.topSymbolOffset + 1, Native.find_java_method("edu.isi.stella.AllPurposeIterator", "allClassesNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")}), module, localP);
    }

    public static Iterator allSurrogates(Module module, boolean localP) {
        return Stella.allocateAllMetaObjectsIterator(Stella.$SURROGATE_ARRAY$.topSymbolOffset + 1, Native.find_java_method("edu.isi.stella.AllPurposeIterator", "allSurrogatesNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")}), module, localP);
    }

    public static Iterator allVariables(Module module, boolean localP) {
        return Stella.allocateAllMetaObjectsIterator(Stella.$SYMBOL_ARRAY$.topSymbolOffset + 1, Native.find_java_method("edu.isi.stella.AllPurposeIterator", "allVariablesNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")}), module, localP);
    }

    public static Iterator allPublicFunctions(Module module, boolean localP) {
        AllPurposeIterator iterator = (AllPurposeIterator)Module.allFunctions(module, localP);
        iterator.iteratorFilterCode = Native.find_java_method("edu.isi.stella.Slot", "filterPublicSlotP", new Class[]{Native.find_java_class("edu.isi.stella.Slot"), Native.find_java_class("edu.isi.stella.AllPurposeIterator")});
        return iterator;
    }

    public static Iterator allFunctions(Module module, boolean localP) {
        return Stella.allocateAllMetaObjectsIterator(Stella.$SYMBOL_ARRAY$.topSymbolOffset + 1, Native.find_java_method("edu.isi.stella.AllPurposeIterator", "allFunctionsNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")}), module, localP);
    }

    public static Iterator allSymbols(Module module, boolean localP) {
        return Stella.allocateAllMetaObjectsIterator(Stella.$SYMBOL_ARRAY$.topSymbolOffset + 1, Native.find_java_method("edu.isi.stella.AllPurposeIterator", "allSymbolsNextP", new Class[]{Native.find_java_class("edu.isi.stella.AllPurposeIterator")}), module, localP);
    }

    public static Stella_Object accessModuleSlotValue(Module self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_PARENT_MODULES) {
            if (setvalueP) {
                self.parentModules = (List)value;
            } else {
                value = self.parentModules;
            }
        } else if (slotname == Stella.SYM_STELLA_DOCUMENTATION) {
            if (setvalueP) {
                self.documentation = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.documentation);
            }
        } else if (slotname == Stella.SYM_STELLA_NICKNAMES) {
            if (setvalueP) {
                self.nicknames = (List)value;
            } else {
                value = self.nicknames;
            }
        } else if (slotname == Stella.SYM_STELLA_USES) {
            if (setvalueP) {
                self.uses = (List)value;
            } else {
                value = self.uses;
            }
        } else if (slotname == Stella.SYM_STELLA_USED_BY) {
            if (setvalueP) {
                self.usedBy = (List)value;
            } else {
                value = self.usedBy;
            }
        } else if (slotname == Stella.SYM_STELLA_SHADOWED_SURROGATES) {
            if (setvalueP) {
                KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_SHADOWED_SURROGATES, (List)value, null);
            } else {
                value = self.shadowedSurrogates();
            }
        } else if (slotname == Stella.SYM_STELLA_REQUIRES) {
            if (setvalueP) {
                self.requires = (List)value;
            } else {
                value = self.requires;
            }
        } else if (slotname == Stella.SYM_STELLA_MODULE_LISP_PACKAGE) {
            if (setvalueP) {
                KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_MODULE_LISP_PACKAGE, StringWrapper.wrapString(((StringWrapper)value).wrapperValue), Stella.NULL_STRING_WRAPPER);
            } else {
                value = StringWrapper.wrapString(self.moduleLispPackage());
            }
        } else if (slotname == Stella.SYM_STELLA_MODULE_CPP_PACKAGE) {
            if (setvalueP) {
                KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_MODULE_CPP_PACKAGE, StringWrapper.wrapString(((StringWrapper)value).wrapperValue), Stella.NULL_STRING_WRAPPER);
            } else {
                value = StringWrapper.wrapString(self.moduleCppPackage());
            }
        } else if (slotname == Stella.SYM_STELLA_JAVA_PACKAGE) {
            if (setvalueP) {
                KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_JAVA_PACKAGE, StringWrapper.wrapString(((StringWrapper)value).wrapperValue), Stella.NULL_STRING_WRAPPER);
            } else {
                value = StringWrapper.wrapString(self.javaPackage());
            }
        } else if (slotname == Stella.SYM_STELLA_CASE_SENSITIVEp) {
            if (setvalueP) {
                self.caseSensitiveP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)value);
            } else {
                value = self.caseSensitiveP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (slotname == Stella.SYM_STELLA_CLEARABLEp) {
            if (setvalueP) {
                KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_CLEARABLEp, BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)value) ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER, Stella.FALSE_WRAPPER);
            } else {
                value = self.clearableP() ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (slotname == Stella.SYM_STELLA_PROTECT_SURROGATESp) {
            if (setvalueP) {
                KeyValueList.setDynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_PROTECT_SURROGATESp, BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)value) ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER, Stella.FALSE_WRAPPER);
            } else {
                value = self.protectSurrogatesP() ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (slotname == Stella.SYM_STELLA_MODULE_FULL_NAME) {
            if (setvalueP) {
                self.moduleFullName = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.moduleFullName);
            }
        } else if (slotname == Stella.SYM_STELLA_MODULE_NAME) {
            if (setvalueP) {
                self.moduleName = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.moduleName);
            }
        } else if (slotname == Stella.SYM_STELLA_MODULE_STRINGIFIED_SOURCE) {
            if (setvalueP) {
                self.moduleStringifiedSource = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.moduleStringifiedSource);
            }
        } else if (slotname == Stella.SYM_STELLA_STRINGIFIED_OPTIONS) {
            if (setvalueP) {
                self.stringifiedOptions = ((StringWrapper)value).wrapperValue;
            } else {
                value = StringWrapper.wrapString(self.stringifiedOptions);
            }
        } else if (slotname == Stella.SYM_STELLA_CARDINAL_MODULE) {
            if (setvalueP) {
                self.cardinalModule = (Module)value;
            } else {
                value = self.cardinalModule;
            }
        } else if (slotname == Stella.SYM_STELLA_SYMBOL_OFFSET_TABLE) {
            if (setvalueP) {
                self.symbolOffsetTable = (StringToIntegerHashTable)value;
            } else {
                value = self.symbolOffsetTable;
            }
        } else if (slotname == Stella.SYM_STELLA_SURROGATE_OFFSET_TABLE) {
            if (setvalueP) {
                self.surrogateOffsetTable = (StringToIntegerHashTable)value;
            } else {
                value = self.surrogateOffsetTable;
            }
        } else if (slotname == Stella.SYM_STELLA_STRICT_INFERENCE_CACHE) {
            if (setvalueP) {
                self.strictInferenceCache = (World)value;
            } else {
                value = self.strictInferenceCache;
            }
        } else if (slotname == Stella.SYM_STELLA_DEFAULT_INFERENCE_CACHE) {
            if (setvalueP) {
                self.defaultInferenceCache = (World)value;
            } else {
                value = self.defaultInferenceCache;
            }
        } else if (slotname == Stella.SYM_STELLA_PROTOTYPE_INFERENCE_CACHE) {
            if (setvalueP) {
                self.prototypeInferenceCache = (World)value;
            } else {
                value = self.prototypeInferenceCache;
            }
        } else if (setvalueP) {
            KeyValueList.setDynamicSlotValue(self.dynamicSlots, slotname, value, null);
        } else {
            value = self.dynamicSlots.lookup(slotname);
        }
        return value;
    }

    public boolean protectSurrogatesP() {
        Module self = this;
        return ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)self.dynamicSlots, (Symbol)Stella.SYM_STELLA_PROTECT_SURROGATESp, (Stella_Object)Stella.TRUE_WRAPPER)).wrapperValue;
    }

    public boolean clearableP() {
        Module self = this;
        return ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)self.dynamicSlots, (Symbol)Stella.SYM_STELLA_CLEARABLEp, (Stella_Object)Stella.TRUE_WRAPPER)).wrapperValue;
    }

    public String javaPackage() {
        Module self = this;
        String answer = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)self.dynamicSlots, (Symbol)Stella.SYM_STELLA_JAVA_PACKAGE, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
        if (answer == null) {
            return null;
        }
        return answer;
    }

    public String moduleCppPackage() {
        Module self = this;
        String answer = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)self.dynamicSlots, (Symbol)Stella.SYM_STELLA_MODULE_CPP_PACKAGE, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
        if (answer == null) {
            return "stella";
        }
        return answer;
    }

    public String moduleLispPackage() {
        Module self = this;
        String answer = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)self.dynamicSlots, (Symbol)Stella.SYM_STELLA_MODULE_LISP_PACKAGE, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
        if (answer == null) {
            return "STELLA";
        }
        return answer;
    }

    public List shadowedSurrogates() {
        Module self = this;
        List answer = (List)KeyValueList.dynamicSlotValue(self.dynamicSlots, Stella.SYM_STELLA_SHADOWED_SURROGATES, null);
        if (answer == null) {
            return Stella.NIL_LIST;
        }
        return answer;
    }

    public String cppPackage() {
        Module self;
        Module cursor = self = this;
        String value = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)cursor.dynamicSlots, (Symbol)Stella.SYM_STELLA_MODULE_CPP_PACKAGE, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
        while (true) {
            if (value != null) {
                return value;
            }
            cursor = (Module)cursor.parentModules.first();
            if (cursor == null) break;
            value = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)cursor.dynamicSlots, (Symbol)Stella.SYM_STELLA_MODULE_CPP_PACKAGE, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
        }
        return "stella";
    }

    public String lispPackage() {
        Module self;
        Module cursor = self = this;
        String value = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)cursor.dynamicSlots, (Symbol)Stella.SYM_STELLA_MODULE_LISP_PACKAGE, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
        while (true) {
            if (value != null) {
                return value;
            }
            cursor = (Module)cursor.parentModules.first();
            if (cursor == null) break;
            value = ((StringWrapper)KeyValueList.dynamicSlotValue((KeyValueList)cursor.dynamicSlots, (Symbol)Stella.SYM_STELLA_MODULE_LISP_PACKAGE, (Stella_Object)Stella.NULL_STRING_WRAPPER)).wrapperValue;
        }
        return "STELLA";
    }

    public Module parentModule() {
        Module self = this;
        return (Module)((Context)self.parentContexts().pop());
    }

    public String name() {
        Module self = this;
        return self.moduleName;
    }

    public Surrogate primaryType() {
        Module self = this;
        return Stella.SGT_STELLA_MODULE;
    }
}

