/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.AbstractIterator;
import edu.isi.stella.CalendarDate;
import edu.isi.stella.Cons;
import edu.isi.stella.Dictionary;
import edu.isi.stella.InputFileStream;
import edu.isi.stella.InputStream;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Keyword;
import edu.isi.stella.KvCons;
import edu.isi.stella.KvListIterator;
import edu.isi.stella.LineIterator;
import edu.isi.stella.List;
import edu.isi.stella.Module;
import edu.isi.stella.OutputFileStream;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.PropertyList;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Class;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.SystemDefinition;
import edu.isi.stella.TranslationUnit;
import edu.isi.stella.Wrapper;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class KeyValueList
extends Dictionary {
    public KvCons theKvList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyValueList loadConfigurationFile(String file) {
        KeyValueList configuration = KeyValueList.newKeyValueList();
        InputFileStream in = null;
        try {
            in = Stella.openInputFile(file, Stella.NIL);
            String line = null;
            LineIterator iter000 = InputStream.lines(in);
            while (iter000.nextP()) {
                line = iter000.value;
                StringWrapper key = null;
                Wrapper value = null;
                Keyword operator = null;
                Object[] caller_MV_returnarray = new Object[2];
                key = Stella.parseConfigurationFileLine(line, caller_MV_returnarray);
                value = (Wrapper)caller_MV_returnarray[0];
                operator = (Keyword)caller_MV_returnarray[1];
                if (key == null) continue;
                if (operator == Stella.KWD_SET) {
                    Stella.setConfigurationProperty(key.wrapperValue, value, configuration);
                    Stella.setConfigurationProperty(key.wrapperValue, value, null);
                    continue;
                }
                if (operator == Stella.KWD_ADD) {
                    Stella.addConfigurationProperty(key.wrapperValue, value, configuration);
                    Stella.addConfigurationProperty(key.wrapperValue, value, null);
                    continue;
                }
                OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
                stream000.nativeStream.print("`" + operator + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
            }
        }
        finally {
            if (in != null) {
                in.free();
            }
        }
        return configuration;
    }

    public static KeyValueList newKeyValueList() {
        KeyValueList self = null;
        self = new KeyValueList();
        self.theKvList = null;
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void javaTranslateWalkedSystemUnits(KeyValueList systemunits) {
        Object old$Translationunits$000 = Stella.$TRANSLATIONUNITS$.get();
        try {
            Native.setSpecial(Stella.$TRANSLATIONUNITS$, KeyValueList.concatenateSystemUnits(systemunits));
            if ((Integer)Stella.$TRANSLATIONVERBOSITYLEVEL$.get() >= 1) {
                System.out.println("Generating Java translations...");
            }
            Stella.javaOutputAllUnitsToFile();
            Stella.cleanUpTranslationUnitsSpecial();
        }
        finally {
            Stella.$TRANSLATIONUNITS$.set(old$Translationunits$000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cppTranslateWalkedSystemUnits(KeyValueList systemunits) {
        Object old$Currentfile$000 = Stella.$CURRENTFILE$.get();
        Object old$Translationunits$000 = Stella.$TRANSLATIONUNITS$.get();
        try {
            Native.setSpecial(Stella.$CURRENTFILE$, null);
            Native.setSpecial(Stella.$TRANSLATIONUNITS$, null);
            StringWrapper file = null;
            List units = null;
            KvCons iter000 = systemunits.theKvList;
            while (iter000 != null) {
                file = (StringWrapper)iter000.key;
                units = (List)iter000.value;
                Native.setSpecial(Stella.$CURRENTFILE$, Stella.fileBaseName(file.wrapperValue));
                Native.setSpecial(Stella.$TRANSLATIONUNITS$, units);
                Object old$Module$000 = Stella.$MODULE$.get();
                Object old$Context$000 = Stella.$CONTEXT$.get();
                try {
                    Native.setSpecial(Stella.$MODULE$, List.computeFileUnitsModule(units));
                    Native.setSpecial(Stella.$CONTEXT$, (Module)Stella.$MODULE$.get());
                    Stella.translateAndOutputUnitsToFile(file.wrapperValue, "C++");
                }
                finally {
                    Stella.$CONTEXT$.set(old$Context$000);
                    Stella.$MODULE$.set(old$Module$000);
                }
                Stella.cleanUpTranslationUnitsSpecial();
                iter000 = iter000.rest;
            }
            Stella.cppOutputSystemSpecificFiles();
        }
        finally {
            Stella.$TRANSLATIONUNITS$.set(old$Translationunits$000);
            Stella.$CURRENTFILE$.set(old$Currentfile$000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfigurationFile(KeyValueList table, String file, String title) {
        Object old$PrintreadablyP$000 = Stella.$PRINTREADABLYp$.get();
        try {
            Native.setBooleanSpecial(Stella.$PRINTREADABLYp$, false);
            OutputFileStream out = null;
            try {
                out = Stella.openOutputFile(file, Stella.NIL);
                if (title != null) {
                    out.nativeStream.println("# " + title);
                }
                StringWrapper key = null;
                Stella_Object value = null;
                KvCons iter000 = table.theKvList;
                while (iter000 != null) {
                    key = (StringWrapper)iter000.key;
                    value = iter000.value;
                    if (Stella_Object.safePrimaryType(value) == Stella.SGT_STELLA_CONS) {
                        Cons value000 = (Cons)value;
                        Stella_Object v = null;
                        Cons iter001 = value000;
                        while (iter001 != Stella.NIL) {
                            v = iter001.value;
                            out.nativeStream.print(StringWrapper.unwrapString(key) + " +=");
                            OutputStream.saveConfigurationValue(out, v);
                            out.nativeStream.println();
                            iter001 = iter001.rest;
                        }
                    } else {
                        out.nativeStream.print(StringWrapper.unwrapString(key) + " =");
                        OutputStream.saveConfigurationValue(out, value);
                        out.nativeStream.println();
                    }
                    iter000 = iter000.rest;
                }
            }
            finally {
                if (out != null) {
                    out.free();
                }
            }
        }
        finally {
            Stella.$PRINTREADABLYp$.set(old$PrintreadablyP$000);
        }
    }

    public static List concatenateSystemUnits(KeyValueList systemunits) {
        Cons head;
        Cons cursor = head = Stella_Object.cons(null, Stella.NIL);
        StringWrapper file = null;
        List units = null;
        KvCons iter000 = systemunits.theKvList;
        while (iter000 != null) {
            file = (StringWrapper)iter000.key;
            units = (List)iter000.value;
            if (units.nonEmptyP()) {
                cursor.concatenate(units.theConsList, Stella.NIL);
                cursor = units.theConsList;
            }
            iter000 = iter000.rest;
        }
        List self000 = List.newList();
        self000.theConsList = head.rest;
        List value000 = self000;
        return value000;
    }

    public static Stella_Object setDynamicSlotValue(KeyValueList dynamicslots, Symbol slotname, Stella_Object value, Wrapper nullwrapper) {
        boolean deletevalueP = value == nullwrapper && nullwrapper != Stella.FALSE_WRAPPER;
        KvCons cursor = dynamicslots.theKvList;
        while (cursor != null) {
            if (cursor.key == slotname) {
                if (deletevalueP) {
                    dynamicslots.removeAt(slotname);
                } else {
                    cursor.value = value;
                }
                return value;
            }
            cursor = cursor.rest;
        }
        if (!deletevalueP) {
            dynamicslots.theKvList = Stella_Object.kvCons(slotname, value, dynamicslots.theKvList);
        }
        return value;
    }

    public static Stella_Object dynamicSlotValue(KeyValueList dynamicslots, Symbol slotname, Stella_Object nullvalue) {
        Stella_Object key = null;
        Stella_Object value = null;
        KvCons iter000 = dynamicslots.theKvList;
        while (iter000 != null) {
            key = iter000.key;
            value = iter000.value;
            if (key == slotname) {
                if (value == null) {
                    return nullvalue;
                }
                return value;
            }
            iter000 = iter000.rest;
        }
        return nullvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clTranslateWalkedSystemUnits(KeyValueList systemunits) {
        Object old$Currentfile$000 = Stella.$CURRENTFILE$.get();
        Object old$Translationunits$000 = Stella.$TRANSLATIONUNITS$.get();
        try {
            Native.setSpecial(Stella.$CURRENTFILE$, null);
            Native.setSpecial(Stella.$TRANSLATIONUNITS$, null);
            List classunits = List.newList();
            boolean useclstructsP = ((List)Stella.$CURRENT_STELLA_FEATURES$.get()).membP(Stella.KWD_USE_COMMON_LISP_STRUCTS);
            String filename = null;
            StringWrapper file = null;
            List units = null;
            KvCons iter000 = systemunits.theKvList;
            while (iter000 != null) {
                file = (StringWrapper)iter000.key;
                units = (List)iter000.value;
                Native.setSpecial(Stella.$CURRENTFILE$, Stella.fileBaseName(file.wrapperValue));
                if (useclstructsP) {
                    Native.setSpecial(Stella.$TRANSLATIONUNITS$, List.newList());
                    TranslationUnit unit = null;
                    Cons iter001 = units.theConsList;
                    while (iter001 != Stella.NIL) {
                        unit = (TranslationUnit)iter001.value;
                        if (unit.category == Stella.SYM_STELLA_CLASS) {
                            classunits.push(unit);
                        } else {
                            ((List)Stella.$TRANSLATIONUNITS$.get()).push(unit);
                        }
                        iter001 = iter001.rest;
                    }
                    ((List)Stella.$TRANSLATIONUNITS$.get()).reverse();
                } else {
                    Native.setSpecial(Stella.$TRANSLATIONUNITS$, units);
                }
                Object old$Module$000 = Stella.$MODULE$.get();
                Object old$Context$000 = Stella.$CONTEXT$.get();
                try {
                    Native.setSpecial(Stella.$MODULE$, List.computeFileUnitsModule(units));
                    Native.setSpecial(Stella.$CONTEXT$, (Module)Stella.$MODULE$.get());
                    Stella.translateAndOutputUnitsToFile(file.wrapperValue, "Common Lisp");
                }
                finally {
                    Stella.$CONTEXT$.set(old$Context$000);
                    Stella.$MODULE$.set(old$Module$000);
                }
                Stella.cleanUpTranslationUnitsSpecial();
                iter000 = iter000.rest;
            }
            if (useclstructsP) {
                if ((Integer)Stella.$TRANSLATIONVERBOSITYLEVEL$.get() >= 1) {
                    System.out.println("Collecting CL structure class definitions...");
                }
                file = null;
                Cons iter002 = Cons.filesPlusSystemStartup(SystemDefinition.systemDefinitionSourceFiles((SystemDefinition)Stella.$CURRENTSYSTEMDEFINITION$.get()));
                while (iter002 != Stella.NIL) {
                    file = (StringWrapper)iter002.value;
                    filename = Stella.makeFileName(file.wrapperValue, Stella.KWD_STELLA, true);
                    if ((List)systemunits.lookup(StringWrapper.wrapString(filename)) == null) {
                        Native.setSpecial(Stella.$TRANSLATIONUNITS$, List.newList());
                        Native.setSpecial(Stella.$CURRENTFILE$, Stella.fileBaseName(filename));
                        Native.setSpecial(Stella.$TRANSLATIONUNITS$, List.newList());
                        Stella.operateOnFile(filename, Stella.KWD_FINALIZE);
                        TranslationUnit unit = null;
                        Cons iter003 = ((List)Stella.$TRANSLATIONUNITS$.get()).theConsList;
                        Cons collect000 = null;
                        while (iter003 != Stella.NIL) {
                            unit = (TranslationUnit)iter003.value;
                            if (unit.category == Stella.SYM_STELLA_CLASS && Stella_Class.createNativeClassP((Stella_Class)unit.theObject) && !((Stella_Class)unit.theObject).mixinP) {
                                if (collect000 == null) {
                                    collect000 = Stella_Object.cons(unit, Stella.NIL);
                                    if (classunits.theConsList == Stella.NIL) {
                                        classunits.theConsList = collect000;
                                    } else {
                                        Cons.addConsToEndOfConsList(classunits.theConsList, collect000);
                                    }
                                } else {
                                    collect000 = collect000.rest = Stella_Object.cons(unit, Stella.NIL);
                                }
                            }
                            iter003 = iter003.rest;
                        }
                        Stella.cleanUpTranslationUnitsSpecial();
                    }
                    iter002 = iter002.rest;
                }
                List.clOutputSystemClStructsFile(classunits);
            }
        }
        finally {
            Stella.$TRANSLATIONUNITS$.set(old$Translationunits$000);
            Stella.$CURRENTFILE$.set(old$Currentfile$000);
        }
    }

    public static void insertAtVariableTable(KeyValueList self, Symbol variable, Stella_Object value) {
        KvCons cursor = self.theKvList;
        while (cursor != null) {
            if (Symbol.variableEqlP((Symbol)cursor.key, variable)) {
                cursor.value = value;
                return;
            }
            cursor = cursor.rest;
        }
        self.theKvList = Stella_Object.kvCons(variable, value, self.theKvList);
    }

    public static Stella_Object lookupVariableTable(KeyValueList self, Symbol variable) {
        Symbol key = null;
        Stella_Object value = null;
        KvCons iter000 = self.theKvList;
        while (iter000 != null) {
            key = (Symbol)iter000.key;
            value = iter000.value;
            if (Symbol.variableEqlP(key, variable)) {
                return value;
            }
            iter000 = iter000.rest;
        }
        return null;
    }

    public static void fillInDateSubstitution(KeyValueList substitutionList) {
        int year = Integer.MIN_VALUE;
        int month = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        Keyword dow = null;
        Object[] caller_MV_returnarray = new Object[3];
        year = CalendarDate.makeCurrentDateTime().getCalendarDate(Stella.getLocalTimeZone(), caller_MV_returnarray);
        month = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
        day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
        dow = (Keyword)caller_MV_returnarray[2];
        substitutionList.insertAt(StringWrapper.wrapString("YEAR"), StringWrapper.wrapString(Native.integerToString(year)));
        substitutionList.insertAt(StringWrapper.wrapString("DATE"), StringWrapper.wrapString(Stella.formatWithPadding(Native.integerToString(day), 2, '0', Stella.KWD_RIGHT, false) + "-" + ((StringWrapper)Stella.$MONTH_ABBREVIATION_VECTOR$.theArray[month]).wrapperValue + "-" + Native.integerToString(year)));
    }

    public static void printKeyValueList(KeyValueList self, PrintStream stream) {
        stream.print("|kv|(");
        KvCons cursor = self.theKvList;
        int position = 1;
        while (cursor != null) {
            if ((Integer)Stella.$PRINTLENGTH$.get() != Integer.MIN_VALUE && position > (Integer)Stella.$PRINTLENGTH$.get()) {
                stream.print(" ...");
                break;
            }
            if (position != 1) {
                stream.print(" ");
            }
            stream.print(cursor);
            cursor = cursor.rest;
            ++position;
        }
        stream.print(")");
    }

    public List listify() {
        KeyValueList self = this;
        List result = List.newList();
        Stella_Object k = null;
        Stella_Object v = null;
        KvCons iter000 = self.theKvList;
        Cons collect000 = null;
        while (iter000 != null) {
            k = iter000.key;
            v = iter000.value;
            if (collect000 == null) {
                collect000 = Stella_Object.cons(Stella_Object.cons(k, Stella_Object.cons(v, Stella.NIL)), Stella.NIL);
                if (result.theConsList == Stella.NIL) {
                    result.theConsList = collect000;
                } else {
                    Cons.addConsToEndOfConsList(result.theConsList, collect000);
                }
            } else {
                collect000 = collect000.rest = Stella_Object.cons(Stella_Object.cons(k, Stella_Object.cons(v, Stella.NIL)), Stella.NIL);
            }
            iter000 = iter000.rest;
        }
        return result;
    }

    public static PropertyList kvlistToPlist(KeyValueList self) {
        Cons plist = Stella.NIL;
        Stella_Object key = null;
        Stella_Object value = null;
        KvCons iter000 = self.theKvList;
        while (iter000 != null) {
            key = iter000.key;
            value = iter000.value;
            plist = Stella_Object.cons(value, Stella_Object.cons(key, plist));
            iter000 = iter000.rest;
        }
        PropertyList self000 = PropertyList.newPropertyList();
        self000.thePlist = plist.reverse();
        PropertyList value000 = self000;
        return value000;
    }

    public AbstractIterator allocateIterator() {
        KeyValueList self = this;
        KvListIterator iterator = KvListIterator.newKvListIterator();
        iterator.theKvList = self;
        iterator.kvListIteratorCursor = self.theKvList;
        iterator.firstIterationP = true;
        return iterator;
    }

    public int equalHashCode() {
        KeyValueList self = this;
        int code = 94797224;
        Stella_Object key = null;
        Stella_Object value = null;
        KvCons iter000 = self.theKvList;
        while (iter000 != null) {
            key = iter000.key;
            value = iter000.value;
            code ^= Stella_Object.safeEqualHashCode(key);
            code ^= Stella_Object.safeEqualHashCode(value);
            iter000 = iter000.rest;
        }
        return code;
    }

    public boolean objectEqualP(Stella_Object y) {
        KeyValueList x = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(y), Stella.SGT_STELLA_KEY_VALUE_LIST)) {
            KeyValueList y000 = (KeyValueList)y;
            if (x.length() == y000.length()) {
                Stella_Object key = null;
                Stella_Object value = null;
                KvCons iter000 = x.theKvList;
                while (iter000 != null) {
                    value = iter000.value;
                    key = iter000.key;
                    if (!Stella_Object.equalP(value, y000.lookup(key))) {
                        return false;
                    }
                    iter000 = iter000.rest;
                }
                return true;
            }
        }
        return false;
    }

    public void clear() {
        KeyValueList self = this;
        KvCons next = self.theKvList;
        KvCons current = null;
        while (next != null) {
            current = next;
            next = next.rest;
            KvCons.freeKvCons(current);
        }
        self.theKvList = null;
    }

    public KeyValueList copy() {
        KeyValueList self = this;
        KeyValueList copy = KeyValueList.newKeyValueList();
        copy.theKvList = KvCons.copyKvConsList(self.theKvList);
        return copy;
    }

    public boolean nonEmptyP() {
        KeyValueList self = this;
        return self.theKvList != null;
    }

    public boolean emptyP() {
        KeyValueList self = this;
        return self.theKvList == null;
    }

    public KeyValueList reverse() {
        KeyValueList self = this;
        KvCons reversedlist = self.theKvList;
        KvCons remaininglist = null;
        KvCons temp = null;
        if (reversedlist == null) {
            return self;
        }
        remaininglist = reversedlist.rest;
        if (remaininglist == null) {
            return self;
        }
        reversedlist.rest = null;
        while (remaininglist != null) {
            temp = remaininglist;
            remaininglist = remaininglist.rest;
            temp.rest = reversedlist;
            reversedlist = temp;
        }
        self.theKvList = reversedlist;
        return self;
    }

    public Stella_Object pop() {
        KeyValueList self = this;
        if (self.emptyP()) {
            return null;
        }
        KvCons cons = self.theKvList;
        Stella_Object value = null;
        value = cons.value;
        self.theKvList = cons.rest;
        KvCons.freeKvCons(cons);
        return value;
    }

    public void kvPush(Stella_Object key, Stella_Object value) {
        KeyValueList self = this;
        self.theKvList = Stella_Object.kvCons(key, value, self.theKvList);
    }

    public void push(KvCons value) {
        KeyValueList self = this;
        if (value.rest != null) {
            System.err.print("Safety violation: Push only supports single entry KV-CONSes");
        }
        value.rest = self.theKvList;
        self.theKvList = value;
    }

    public void removeEntry(Stella_Object key, Stella_Object value) {
        KeyValueList self = this;
        KvCons cursor = self.theKvList;
        KvCons previouscursor = null;
        if (cursor != null) {
            if (Stella_Object.eqlP(cursor.key, key) && Stella_Object.eqlP(cursor.value, value)) {
                self.theKvList = cursor.rest;
                KvCons.freeKvCons(cursor);
                return;
            }
            while (cursor.rest != null) {
                previouscursor = cursor;
                cursor = cursor.rest;
                if (!Stella_Object.eqlP(cursor.key, key) || !Stella_Object.eqlP(cursor.value, value)) continue;
                previouscursor.rest = cursor.rest;
                KvCons.freeKvCons(cursor);
                return;
            }
        }
    }

    public void insertEntry(Stella_Object key, Stella_Object value) {
        KeyValueList self = this;
        boolean foundP000 = false;
        Stella_Object k = null;
        Stella_Object v = null;
        KvCons iter000 = self.theKvList;
        while (iter000 != null) {
            k = iter000.key;
            v = iter000.value;
            if (k == key && v == value) {
                foundP000 = true;
                break;
            }
            iter000 = iter000.rest;
        }
        if (!foundP000) {
            self.theKvList = Stella_Object.kvCons(key, value, self.theKvList);
        }
    }

    public Stella_Object removeAt(Stella_Object key) {
        KeyValueList self = this;
        KvCons cursor = self.theKvList;
        KvCons previouscursor = null;
        Stella_Object value = null;
        if (cursor != null) {
            if (Stella_Object.eqlP(cursor.key, key)) {
                self.theKvList = cursor.rest;
                value = cursor.value;
                KvCons.freeKvCons(cursor);
                return value;
            }
            while (cursor.rest != null) {
                previouscursor = cursor;
                cursor = cursor.rest;
                if (!Stella_Object.eqlP(cursor.key, key)) continue;
                previouscursor.rest = cursor.rest;
                value = cursor.value;
                KvCons.freeKvCons(cursor);
                return value;
            }
        }
        return null;
    }

    public void insertAt(Stella_Object key, Stella_Object value) {
        KeyValueList self = this;
        KvCons cursor = self.theKvList;
        while (cursor != null) {
            if (Stella_Object.eqlP(cursor.key, key)) {
                cursor.value = value;
                return;
            }
            cursor = cursor.rest;
        }
        self.theKvList = Stella_Object.kvCons(key, value, self.theKvList);
    }

    public int length() {
        KeyValueList self = this;
        int length = 0;
        KvCons cursor = self.theKvList;
        while (cursor != null) {
            ++length;
            cursor = cursor.rest;
        }
        return length;
    }

    public Stella_Object lookupWithDefault(Stella_Object key, Stella_Object renamed_Default) {
        KeyValueList self = this;
        KvCons cursor = self.theKvList;
        while (cursor != null) {
            if (Stella_Object.eqlP(cursor.key, key)) {
                return cursor.value;
            }
            cursor = cursor.rest;
        }
        return renamed_Default;
    }

    public Stella_Object lookup(Stella_Object key) {
        KeyValueList self = this;
        KvCons cursor = self.theKvList;
        while (cursor != null) {
            if (Stella_Object.eqlP(cursor.key, key)) {
                return cursor.value;
            }
            cursor = cursor.rest;
        }
        return null;
    }

    public Cons consify() {
        KeyValueList self = this;
        Cons result = Stella.NIL;
        Stella_Object k = null;
        Stella_Object v = null;
        KvCons iter000 = self.theKvList;
        Cons collect000 = null;
        while (iter000 != null) {
            k = iter000.key;
            v = iter000.value;
            if (collect000 == null) {
                collect000 = Stella_Object.cons(Stella_Object.cons(k, Stella_Object.cons(v, Stella.NIL)), Stella.NIL);
                if (result == Stella.NIL) {
                    result = collect000;
                } else {
                    Cons.addConsToEndOfConsList(result, collect000);
                }
            } else {
                collect000 = collect000.rest = Stella_Object.cons(Stella_Object.cons(k, Stella_Object.cons(v, Stella.NIL)), Stella.NIL);
            }
            iter000 = iter000.rest;
        }
        return result;
    }

    public void printObject(PrintStream stream) {
        KeyValueList self = this;
        KeyValueList.printKeyValueList(self, stream);
    }

    public static Stella_Object accessKeyValueListSlotValue(KeyValueList self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_THE_KV_LIST) {
            if (setvalueP) {
                self.theKvList = (KvCons)value;
            } else {
                value = self.theKvList;
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        KeyValueList self = this;
        return Stella.SGT_STELLA_KEY_VALUE_LIST;
    }
}

