/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.IntervalIterator;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.ReverseIntegerIntervalIterator;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;

public class IntegerIntervalIterator
extends IntervalIterator {
    public int intervalCursor;
    public int lowerBound;
    public int upperBound;
    public int value;

    public static IntegerIntervalIterator newIntegerIntervalIterator(int lowerBound, int upperBound) {
        IntegerIntervalIterator self = null;
        self = new IntegerIntervalIterator();
        self.lowerBound = lowerBound;
        self.upperBound = upperBound;
        self.firstIterationP = true;
        self.value = Integer.MIN_VALUE;
        self.intervalCursor = Integer.MIN_VALUE;
        self.initializeIntegerIntervalIterator();
        return self;
    }

    public ReverseIntegerIntervalIterator reverse() {
        IntegerIntervalIterator self = this;
        return Stella.reverseInterval(self.lowerBound, self.upperBound);
    }

    public boolean nextP() {
        IntegerIntervalIterator self = this;
        if (self.firstIterationP) {
            self.firstIterationP = false;
        } else {
            ++self.intervalCursor;
        }
        int upperbound = self.upperBound;
        self.value = self.intervalCursor;
        return upperbound == Integer.MIN_VALUE || self.intervalCursor <= upperbound;
    }

    public void initializeIntegerIntervalIterator() {
        IntegerIntervalIterator self = this;
        self.intervalCursor = self.lowerBound;
        self.firstIterationP = true;
    }

    public static Stella_Object accessIntegerIntervalIteratorSlotValue(IntegerIntervalIterator self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_INTERVAL_CURSOR) {
            if (setvalueP) {
                self.intervalCursor = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.intervalCursor);
            }
        } else if (slotname == Stella.SYM_STELLA_LOWER_BOUND) {
            if (setvalueP) {
                self.lowerBound = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.lowerBound);
            }
        } else if (slotname == Stella.SYM_STELLA_UPPER_BOUND) {
            if (setvalueP) {
                self.upperBound = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.upperBound);
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        IntegerIntervalIterator self = this;
        return Stella.SGT_STELLA_INTEGER_INTERVAL_ITERATOR;
    }
}

