/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella;

import edu.isi.stella.DateTimeObject;
import edu.isi.stella.DecodedDateTime;
import edu.isi.stella.IncompatibleQuantityException;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Keyword;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Quantity;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class CalendarDate
extends DateTimeObject {
    public int modifiedJulianDay;
    public int timeMillis;

    public static CalendarDate stringToCalendarDateWithDefault(String inputDate, DecodedDateTime defaultDate) {
        if (defaultDate == null) {
            return CalendarDate.stringToCalendarDate(inputDate);
        }
        DecodedDateTime dateTime = DecodedDateTime.parseDateTimeRelativeToBase(inputDate, defaultDate, 0, Integer.MIN_VALUE, false, true);
        if (dateTime == null) {
            return null;
        }
        return dateTime.encodeCalendarDate();
    }

    public static CalendarDate stringToCalendarDate(String input) {
        DecodedDateTime dateTime = DecodedDateTime.parseDateTimeInTimeZone(input, Double.NEGATIVE_INFINITY, 0, Integer.MIN_VALUE, false);
        if (dateTime == null) {
            return null;
        }
        return dateTime.encodeCalendarDate();
    }

    public static CalendarDate makeCalendarDate(int day, int time) {
        while (time < 0) {
            time += Stella.MILLIS_PER_DAY;
            --day;
        }
        while (time > Stella.MILLIS_PER_DAY) {
            time -= Stella.MILLIS_PER_DAY;
            ++day;
        }
        CalendarDate self000 = CalendarDate.newCalendarDate();
        self000.modifiedJulianDay = day;
        self000.timeMillis = time;
        CalendarDate value000 = self000;
        return value000;
    }

    public static CalendarDate makeCurrentDateTime() {
        int year = Integer.MIN_VALUE;
        int month = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        Keyword dow = null;
        int hour = Integer.MIN_VALUE;
        int minute = Integer.MIN_VALUE;
        int second = Integer.MIN_VALUE;
        int millisecond = Integer.MIN_VALUE;
        Object[] caller_MV_returnarray = new Object[7];
        year = Stella.getCurrentDateTime(caller_MV_returnarray);
        month = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
        day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
        dow = (Keyword)caller_MV_returnarray[2];
        hour = ((IntegerWrapper)caller_MV_returnarray[3]).wrapperValue;
        minute = ((IntegerWrapper)caller_MV_returnarray[4]).wrapperValue;
        second = ((IntegerWrapper)caller_MV_returnarray[5]).wrapperValue;
        millisecond = ((IntegerWrapper)caller_MV_returnarray[6]).wrapperValue;
        return CalendarDate.makeDateTime(year, month, day, hour, minute, second, millisecond, 0.0);
    }

    public static CalendarDate makeDateTime(int year, int month, int day, int hour, int minute, int second, int millis, double timezone) {
        int time = hour * Stella.MILLIS_PER_HOUR + minute * 60000 + second * 1000 + millis;
        time = (int)((double)time - timezone * (double)Stella.MILLIS_PER_HOUR);
        return CalendarDate.makeCalendarDate(Stella.julianDayToModifiedJulianDay(Stella.computeJulianDay(year, month, day)), time);
    }

    public static CalendarDate nativeDateTimeToCalendarDate(long date) {
        int mjd = 0;
        int millis = 0;
        mjd = (int)(date / 86400000L + 40588L);
        millis = (int)(date % 86400000L);
        return CalendarDate.makeCalendarDate(mjd, millis);
    }

    public static CalendarDate newCalendarDate() {
        CalendarDate self = null;
        self = new CalendarDate();
        self.timeMillis = Integer.MIN_VALUE;
        self.modifiedJulianDay = Integer.MIN_VALUE;
        return self;
    }

    public boolean greaterEqualP(Stella_Object t2) {
        CalendarDate t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_CALENDAR_DATE)) {
            CalendarDate t2000 = (CalendarDate)t2;
            if (t1.modifiedJulianDay == t2000.modifiedJulianDay) {
                return t1.timeMillis >= t2000.timeMillis;
            }
            return t1.modifiedJulianDay >= t2000.modifiedJulianDay;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't compare calendar date `" + t1 + "' with object `" + t2 + "'");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public boolean lessEqualP(Stella_Object t2) {
        CalendarDate t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_CALENDAR_DATE)) {
            CalendarDate t2000 = (CalendarDate)t2;
            if (t1.modifiedJulianDay == t2000.modifiedJulianDay) {
                return t1.timeMillis <= t2000.timeMillis;
            }
            return t1.modifiedJulianDay <= t2000.modifiedJulianDay;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't compare calendar date `" + t1 + "' with object `" + t2 + "'");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public boolean greaterP(Stella_Object t2) {
        CalendarDate t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_CALENDAR_DATE)) {
            CalendarDate t2000 = (CalendarDate)t2;
            if (t1.modifiedJulianDay == t2000.modifiedJulianDay) {
                return t1.timeMillis > t2000.timeMillis;
            }
            return t1.modifiedJulianDay > t2000.modifiedJulianDay;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't compare calendar date `" + t1 + "' with object `" + t2 + "'");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public boolean lessP(Stella_Object t2) {
        CalendarDate t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_CALENDAR_DATE)) {
            CalendarDate t2000 = (CalendarDate)t2;
            if (t1.modifiedJulianDay == t2000.modifiedJulianDay) {
                return t1.timeMillis < t2000.timeMillis;
            }
            return t1.modifiedJulianDay < t2000.modifiedJulianDay;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't compare calendar date `" + t1 + "' with object `" + t2 + "'");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public boolean objectEqlP(Stella_Object t2) {
        CalendarDate t1 = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(t2), Stella.SGT_STELLA_CALENDAR_DATE)) {
            CalendarDate t2000 = (CalendarDate)t2;
            if (t1.modifiedJulianDay == t2000.modifiedJulianDay) {
                return t1.timeMillis == t2000.timeMillis;
            }
            return t1.modifiedJulianDay == t2000.modifiedJulianDay;
        }
        return false;
    }

    public DecodedDateTime decodeCalendarDate(double timezone) {
        CalendarDate date = this;
        int hour = Integer.MIN_VALUE;
        int min = Integer.MIN_VALUE;
        int sec = Integer.MIN_VALUE;
        int millis = Integer.MIN_VALUE;
        Object[] caller_MV_returnarray = new Object[3];
        hour = date.getTime(timezone, caller_MV_returnarray);
        min = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
        sec = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
        millis = ((IntegerWrapper)caller_MV_returnarray[2]).wrapperValue;
        int year = Integer.MIN_VALUE;
        int month = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        Keyword dow = null;
        Object[] caller_MV_returnarray2 = new Object[3];
        year = date.getCalendarDate(timezone, caller_MV_returnarray2);
        month = ((IntegerWrapper)caller_MV_returnarray2[0]).wrapperValue;
        day = ((IntegerWrapper)caller_MV_returnarray2[1]).wrapperValue;
        dow = (Keyword)caller_MV_returnarray2[2];
        DecodedDateTime self000 = DecodedDateTime.newDecodedDateTime();
        self000.dateTimeMillis = millis;
        self000.dateTimeSecond = sec;
        self000.dateTimeMinute = min;
        self000.dateTimeHour = hour;
        self000.dateTimeDay = day;
        self000.dateTimeMonth = month;
        self000.dateTimeYear = year;
        self000.dateTimeZone = timezone;
        self000.dateTimeDow = dow;
        DecodedDateTime value000 = self000;
        return value000;
    }

    public int getTime(double timezone, Object[] MV_returnarray) {
        CalendarDate date = this;
        if (timezone == Double.NEGATIVE_INFINITY) {
            Stella.STANDARD_WARNING.nativeStream.println("Warning: Timezone not specified in GET-TIME.  Using local zone.");
            int year = Integer.MIN_VALUE;
            int month = Integer.MIN_VALUE;
            int day = Integer.MIN_VALUE;
            Keyword dow = null;
            Object[] caller_MV_returnarray = new Object[3];
            year = Stella.computeCalendarDate(Stella.modifiedJulianDayToJulianDay(date.modifiedJulianDay), caller_MV_returnarray);
            month = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
            day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
            dow = (Keyword)caller_MV_returnarray[2];
            timezone = Stella.getLocalTimeZoneForDate(year, month, day, 12, 0, 0);
        }
        if (timezone == 0.0) {
            return Stella.decodeTimeInMillis(date.timeMillis, MV_returnarray);
        }
        if (timezone < 0.0) {
            return Stella.decodeTimeInMillis((int)((double)(date.timeMillis + Stella.MILLIS_PER_DAY) + timezone * (double)Stella.MILLIS_PER_HOUR) % Stella.MILLIS_PER_DAY, MV_returnarray);
        }
        return Stella.decodeTimeInMillis((int)((double)date.timeMillis + timezone * (double)Stella.MILLIS_PER_HOUR) % Stella.MILLIS_PER_DAY, MV_returnarray);
    }

    public int getCalendarDate(double timezone, Object[] MV_returnarray) {
        CalendarDate date = this;
        if (timezone == Double.NEGATIVE_INFINITY) {
            Stella.STANDARD_WARNING.nativeStream.println("Warning: Timezone not specified in GET-CALENDAR-DATE  Using local zone.");
            int year = Integer.MIN_VALUE;
            int month = Integer.MIN_VALUE;
            int day = Integer.MIN_VALUE;
            Keyword dow = null;
            Object[] caller_MV_returnarray = new Object[3];
            year = Stella.computeCalendarDate(Stella.modifiedJulianDayToJulianDay(date.modifiedJulianDay), caller_MV_returnarray);
            month = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
            day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
            dow = (Keyword)caller_MV_returnarray[2];
            timezone = Stella.getLocalTimeZoneForDate(year, month, day, 12, 0, 0);
        }
        int time = date.timeMillis;
        int timezoneAdjustedTime = (int)((double)time + timezone * (double)Stella.MILLIS_PER_HOUR);
        int dayOffset = 0;
        if (timezoneAdjustedTime < 0) {
            dayOffset = -1;
        } else if (timezoneAdjustedTime > Stella.MILLIS_PER_DAY) {
            dayOffset = 1;
        }
        return Stella.computeCalendarDate(Stella.modifiedJulianDayToJulianDay(date.modifiedJulianDay + dayOffset), MV_returnarray);
    }

    public void printCalendarDate(PrintStream stream) {
        CalendarDate date = this;
        if (((Boolean)Stella.$PRINTREADABLYp$.get()).booleanValue()) {
            stream.print("\"");
        } else {
            stream.print("<" + date.modifiedJulianDay + " ");
        }
        stream.print(date.calendarDateToString(0.0, false, false));
        if (((Boolean)Stella.$PRINTREADABLYp$.get()).booleanValue()) {
            stream.print(" UTC\"");
        } else {
            stream.print(" UTC>");
        }
    }

    public long calendarDateToNativeDateTime() {
        CalendarDate date = this;
        int mjd = date.modifiedJulianDay;
        int millis = date.timeMillis;
        return ((long)mjd - 40588L) * 86400000L + (long)millis;
    }

    public String calendarDateToIso8601String(double timezone, boolean includeTimezoneP) {
        CalendarDate date = this;
        String tzString = "";
        if (includeTimezoneP) {
            tzString = timezone == 0.0 ? "Z" : Stella.timeZoneFormat60(timezone);
        }
        return date.calendarDateToDateString(timezone, true) + "T" + date.calendarDateToTimeString(timezone, false, false, true) + tzString;
    }

    public String calendarDateToString(double timezone, boolean numericMonthP, boolean includeTimezoneP) {
        CalendarDate date = this;
        return date.calendarDateToDateString(timezone, numericMonthP) + " " + date.calendarDateToTimeString(timezone, includeTimezoneP, true, false);
    }

    public String calendarDateToTimeString(double timezone, boolean includeTimezoneP, boolean includeMillisP, boolean padHoursP) {
        CalendarDate date = this;
        int hours = Integer.MIN_VALUE;
        int minutes = Integer.MIN_VALUE;
        int seconds = Integer.MIN_VALUE;
        int milli = Integer.MIN_VALUE;
        Object[] caller_MV_returnarray = new Object[3];
        hours = date.getTime(timezone, caller_MV_returnarray);
        minutes = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
        seconds = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
        milli = ((IntegerWrapper)caller_MV_returnarray[2]).wrapperValue;
        String timezoneString = includeTimezoneP ? (timezone == 0.0 ? " UTC" : " " + Native.floatToString(timezone)) : "";
        String milliString = includeMillisP ? "." + Stella.formatWithPadding(Native.integerToString(milli), 3, '0', Stella.KWD_RIGHT, false) : "";
        return (padHoursP ? Stella.formatWithPadding(Native.integerToString(hours), 2, '0', Stella.KWD_RIGHT, false) : Native.integerToString(hours)) + ":" + Stella.formatWithPadding(Native.integerToString(minutes), 2, '0', Stella.KWD_RIGHT, false) + ":" + Stella.formatWithPadding(Native.integerToString(seconds), 2, '0', Stella.KWD_RIGHT, false) + milliString + timezoneString;
    }

    public String calendarDateToDateString(double timezone, boolean numericMonthP) {
        CalendarDate date = this;
        int year = Integer.MIN_VALUE;
        int month = Integer.MIN_VALUE;
        int day = Integer.MIN_VALUE;
        Keyword dow = null;
        Object[] caller_MV_returnarray = new Object[3];
        year = date.getCalendarDate(timezone, caller_MV_returnarray);
        month = ((IntegerWrapper)caller_MV_returnarray[0]).wrapperValue;
        day = ((IntegerWrapper)caller_MV_returnarray[1]).wrapperValue;
        dow = (Keyword)caller_MV_returnarray[2];
        String yearString = year < 0 ? Native.integerToString(0 - year) + "BC" : Native.integerToString(year);
        String monthString = numericMonthP ? Stella.formatWithPadding(Native.integerToString(month), 2, '0', Stella.KWD_RIGHT, false) : StringWrapper.unwrapString((StringWrapper)Stella.$MONTH_ABBREVIATION_VECTOR$.theArray[month]);
        return yearString + "-" + monthString + "-" + Stella.formatWithPadding(Native.integerToString(day), 2, '0', Stella.KWD_RIGHT, false);
    }

    public int hashCode_() {
        CalendarDate self = this;
        return self.modifiedJulianDay ^ self.timeMillis;
    }

    public Quantity coerceTo(Stella_Object y) {
        CalendarDate x = this;
        if (Surrogate.subtypeOfP(Stella_Object.safePrimaryType(y), Stella.SGT_STELLA_CALENDAR_DATE)) {
            CalendarDate y000 = (CalendarDate)y;
            return y000;
        }
        OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
        stream000.nativeStream.print("Can't coerce `" + y + "' to a CALENDAR-DATE");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException(stream000.theStringReader()).fillInStackTrace();
    }

    public void printObject(PrintStream stream) {
        CalendarDate self = this;
        self.printCalendarDate(stream);
    }

    public static Stella_Object accessCalendarDateSlotValue(CalendarDate self, Symbol slotname, Stella_Object value, boolean setvalueP) {
        if (slotname == Stella.SYM_STELLA_MODIFIED_JULIAN_DAY) {
            if (setvalueP) {
                self.modifiedJulianDay = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.modifiedJulianDay);
            }
        } else if (slotname == Stella.SYM_STELLA_TIME_MILLIS) {
            if (setvalueP) {
                self.timeMillis = ((IntegerWrapper)value).wrapperValue;
            } else {
                value = IntegerWrapper.wrapInteger(self.timeMillis);
            }
        } else {
            OutputStringStream stream000 = OutputStringStream.newOutputStringStream();
            stream000.nativeStream.print("`" + slotname + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException(stream000.theStringReader()).fillInStackTrace();
        }
        return value;
    }

    public Surrogate primaryType() {
        CalendarDate self = this;
        return Stella.SGT_STELLA_CALENDAR_DATE;
    }
}

