/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.util;

import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.Visitable;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.InlineResourceChecker;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterNamespaceManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Util {
    private static Set<String> excludedPropertyNames = new HashSet<String>();

    public static boolean isExcludedProperty(RDFProperty rDFProperty) {
        return excludedPropertyNames.contains(rDFProperty.getName());
    }

    public static void insertProperties(RDFResource rDFResource, TripleStore tripleStore, XMLWriter xMLWriter) throws IOException {
        for (RDFProperty rDFProperty : rDFResource.getRDFProperties()) {
            if (excludedPropertyNames.contains(rDFProperty.getName())) continue;
            for (Object e : rDFResource.getPropertyValues(rDFProperty)) {
                Visitable visitable;
                if (!tripleStore.contains(rDFResource, rDFProperty, e)) continue;
                if (e instanceof RDFResource || e instanceof RDFExternalResource) {
                    Util.insertResourceAsElement(rDFProperty, xMLWriter);
                    visitable = (Visitable)e;
                    Util.inlineObject(visitable, tripleStore, xMLWriter);
                    xMLWriter.writeEndElement();
                    continue;
                }
                Util.insertResourceAsElement(rDFProperty, xMLWriter);
                visitable = rDFResource.getOWLModel().asRDFSLiteral(e);
                if (visitable.getLanguage() != null) {
                    xMLWriter.writeAttribute("xml:lang", visitable.getLanguage());
                } else {
                    xMLWriter.writeAttribute("rdf:datatype", visitable.getDatatype().getURI());
                }
                xMLWriter.writeTextContent(visitable.toString());
                xMLWriter.writeEndElement();
            }
        }
    }

    public static void inlineObject(Visitable visitable, TripleStore tripleStore, XMLWriter xMLWriter) throws IOException {
        InlineResourceChecker inlineResourceChecker = new InlineResourceChecker();
        visitable.accept(inlineResourceChecker);
        if (inlineResourceChecker.isCanInline()) {
            if (visitable instanceof RDFResource) {
                RDFResource rDFResource = (RDFResource)visitable;
                Util.insertResourceAttribute(rDFResource, xMLWriter);
            } else if (visitable instanceof RDFExternalResource) {
                xMLWriter.writeAttribute("rdf:resource", ((RDFExternalResource)visitable).getResourceURI());
            }
        } else {
            new RDFResourceRenderer(visitable, tripleStore, xMLWriter).write();
        }
    }

    public static void insertAboutAttribute(RDFResource rDFResource, XMLWriter xMLWriter) throws IOException {
        xMLWriter.writeAttribute("rdf:about", Util.getResourceAttributeName(rDFResource, xMLWriter));
    }

    public static void insertIDOrAboutAttribute(RDFResource rDFResource, TripleStore tripleStore, XMLWriter xMLWriter) throws IOException {
        String string = Util.getResourceAttributeName(rDFResource, xMLWriter);
        if (string.startsWith("#")) {
            xMLWriter.writeAttribute("rdf:ID", string.substring(1, string.length()));
        } else {
            xMLWriter.writeAttribute("rdf:about", string);
        }
    }

    public static void insertResourceAttribute(RDFResource rDFResource, XMLWriter xMLWriter) throws IOException {
        xMLWriter.writeAttribute("rdf:resource", Util.getResourceAttributeName(rDFResource, xMLWriter));
    }

    public static String getResourceAttributeName(RDFResource rDFResource, XMLWriter xMLWriter) {
        String string = rDFResource.getURI().startsWith(xMLWriter.getXMLBase()) ? rDFResource.getURI().substring(xMLWriter.getXMLBase().length(), rDFResource.getURI().length()) : rDFResource.getURI();
        return string;
    }

    public static void insertResourceAsElement(RDFResource rDFResource, XMLWriter xMLWriter) throws IOException {
        String string = "rdf:resource";
        if (xMLWriter.getDefaultNamespace().equals(rDFResource.getNamespace())) {
            string = rDFResource.getLocalName();
        } else {
            String string2 = xMLWriter.getNamespacePrefixes().getPrefixForNamespace(rDFResource.getNamespace());
            string = string2 + ":" + rDFResource.getLocalName();
        }
        xMLWriter.writeStartElement(string);
    }

    public static boolean isInDefaultNamespace(RDFResource rDFResource, XMLWriter xMLWriter) {
        return xMLWriter.getNamespacePrefixes().getDefaultNamespace().equals(rDFResource.getNamespace());
    }

    public static XMLWriterNamespaceManager getNamespacePrefixes(NamespaceManager namespaceManager, String string) {
        XMLWriterNamespaceManager xMLWriterNamespaceManager = new XMLWriterNamespaceManager(string);
        for (String string2 : namespaceManager.getPrefixes()) {
            String string3 = namespaceManager.getNamespaceForPrefix(string2);
            if (string3.equals(string)) continue;
            xMLWriterNamespaceManager.setPrefix(string2, namespaceManager.getNamespaceForPrefix(string2));
        }
        if (!namespaceManager.getDefaultNamespace().equals(string)) {
            xMLWriterNamespaceManager.createPrefixForNamespace(namespaceManager.getDefaultNamespace());
        }
        return xMLWriterNamespaceManager;
    }

    public static void renderTypes(RDFResource rDFResource, TripleStore tripleStore, RDFResource rDFResource2, XMLWriter xMLWriter) throws IOException {
        RDFProperty rDFProperty = rDFResource.getOWLModel().getRDFProperty("rdf:type");
        Iterator iterator = tripleStore.listObjects(rDFResource, rDFProperty);
        while (iterator.hasNext()) {
            RDFResource rDFResource3 = (RDFResource)iterator.next();
            if (rDFResource3.equals(rDFResource2)) continue;
            xMLWriter.writeStartElement("rdf:type");
            Util.inlineObject(rDFResource3, tripleStore, xMLWriter);
            xMLWriter.writeEndElement();
        }
    }

    public static RDFResource getType(RDFResource rDFResource, TripleStore tripleStore) {
        RDFResource rDFResource2 = null;
        RDFProperty rDFProperty = rDFResource.getOWLModel().getRDFProperty("rdf:type");
        Iterator iterator = tripleStore.listObjects(rDFResource, rDFProperty);
        while (iterator.hasNext()) {
            RDFResource rDFResource3 = (RDFResource)iterator.next();
            if (rDFResource3.isAnonymous()) continue;
            rDFResource2 = rDFResource3;
            break;
        }
        return rDFResource2;
    }

    public static String getOntologyName(OWLModel oWLModel, TripleStore tripleStore) {
        for (OWLOntology oWLOntology : oWLModel.getOWLOntologies()) {
            if (!oWLModel.getTripleStoreModel().getHomeTripleStore(oWLOntology).equals(tripleStore)) continue;
            return oWLOntology.getURI();
        }
        return "<null>";
    }

    static {
        excludedPropertyNames.add("rdfs:subClassOf");
        excludedPropertyNames.add("owl:equivalentClass");
        excludedPropertyNames.add("rdf:type");
        excludedPropertyNames.add("protege:classificationStatus");
        excludedPropertyNames.add("protege:inferredSuperclassOf");
        excludedPropertyNames.add("protege:inferredSubclassOf");
        excludedPropertyNames.add("protege:inferredType");
        excludedPropertyNames.add("owl:distinctMembers");
        excludedPropertyNames.add("owl:allValuesFrom");
        excludedPropertyNames.add("owl:cardinality");
        excludedPropertyNames.add("owl:complementOf");
        excludedPropertyNames.add("owl:hasValue");
        excludedPropertyNames.add("owl:intersectionOf");
        excludedPropertyNames.add("owl:maxCardinality");
        excludedPropertyNames.add("owl:minCardinality");
        excludedPropertyNames.add("owl:onProperty");
        excludedPropertyNames.add("owl:oneOf");
        excludedPropertyNames.add("owl:someValuesFrom");
        excludedPropertyNames.add("owl:unionOf");
        excludedPropertyNames.add("owl");
        excludedPropertyNames.add(":OWL-ONTOLOGY-PREFIXES");
        excludedPropertyNames.add("owl:imports");
        excludedPropertyNames.add("rdfs:domain");
    }
}

