/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.util;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFExternalResource;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;

public class InlineResourceChecker
extends OWLModelVisitorAdapter {
    private boolean canInline = false;

    public boolean isCanInline() {
        return this.canInline;
    }

    public void visitOWLOntology(OWLOntology oWLOntology) {
        this.canInline = true;
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty oWLDatatypeProperty) {
        this.canInline = true;
    }

    public void visitOWLIndividual(OWLIndividual oWLIndividual) {
        if (!oWLIndividual.getOWLModel().isAnonymousResourceName(oWLIndividual.getName())) {
            this.canInline = true;
        }
    }

    public void visitRDFDatatype(RDFSDatatype rDFSDatatype) {
        this.canInline = !rDFSDatatype.isAnonymous();
    }

    public void visitOWLNamedClass(OWLNamedClass oWLNamedClass) {
        this.canInline = true;
    }

    public void visitOWLObjectProperty(OWLObjectProperty oWLObjectProperty) {
        this.canInline = true;
    }

    public void visitRDFExternalResource(RDFExternalResource rDFExternalResource) {
        this.canInline = true;
    }

    public void visitRDFIndividual(RDFIndividual rDFIndividual) {
        if (!rDFIndividual.getOWLModel().isAnonymousResourceName(rDFIndividual.getName())) {
            this.canInline = true;
        }
    }

    public void visitRDFProperty(RDFProperty rDFProperty) {
        this.canInline = true;
    }

    public void visitRDFSNamedClass(RDFSNamedClass rDFSNamedClass) {
        this.canInline = true;
    }
}

