/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFAxiomRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.util.Collection;

public class RDFResourceCollectionContentWriter
implements RDFXMLContentWriter {
    private Collection resources;
    private RDFAxiomRenderer.RenderableAxiomsChecker checker;
    private TripleStore tripleStore;

    public RDFResourceCollectionContentWriter(Collection collection, TripleStore tripleStore) {
        this.resources = collection;
        this.tripleStore = tripleStore;
        this.checker = RDFAxiomRenderer.getChecker();
    }

    public void writeContent(XMLWriter xMLWriter) {
        for (RDFResource rDFResource : this.resources) {
            OWLModelVisitorAdapter oWLModelVisitorAdapter;
            if (this.checker.isRenderable(rDFResource)) {
                oWLModelVisitorAdapter = new RDFAxiomRenderer(rDFResource, this.tripleStore, xMLWriter);
                ((RDFAxiomRenderer)oWLModelVisitorAdapter).write();
                continue;
            }
            oWLModelVisitorAdapter = new RDFResourceRenderer(rDFResource, this.tripleStore, xMLWriter);
            ((RDFResourceRenderer)oWLModelVisitorAdapter).write();
        }
    }
}

