/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelOrderedWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.OWLModelWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;

public class OWLModelAllTripleStoresWriter {
    private OWLModel model;
    private URI uri;
    private boolean ordered;

    public OWLModelAllTripleStoresWriter(OWLModel oWLModel, URI uRI, boolean bl) {
        this.model = oWLModel;
        this.uri = uRI;
        this.ordered = bl;
    }

    public void write() throws Exception {
        Object object;
        Iterator iterator = this.model.getTripleStoreModel().listUserTripleStores();
        TripleStore tripleStore = (TripleStore)iterator.next();
        File file = new File(this.uri);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, FileUtilities.getWriteEncoding());
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        OWLModelWriter oWLModelWriter = this.getOwlModelWriter(tripleStore, bufferedWriter);
        oWLModelWriter.getXmlWriter().setEncoding(outputStreamWriter.getEncoding());
        oWLModelWriter.write();
        bufferedWriter.flush();
        bufferedWriter.close();
        while (iterator.hasNext()) {
            object = (TripleStore)iterator.next();
            String string = object.getName();
            URI uRI = new URI(string);
            Repository repository = this.model.getRepositoryManager().getRepository(uRI);
            if (repository == null || !repository.isWritable(uRI)) continue;
            System.out.println("Saving import " + uRI + " to " + repository.getOntologyLocationDescription(uRI));
            OutputStream outputStream = repository.getOutputStream(uRI);
            OutputStreamWriter outputStreamWriter2 = new OutputStreamWriter(outputStream, FileUtilities.getWriteEncoding());
            bufferedWriter = new BufferedWriter(outputStreamWriter2);
            OWLModelWriter oWLModelWriter2 = this.getOwlModelWriter((TripleStore)object, bufferedWriter);
            oWLModelWriter2.getXmlWriter().setEncoding(outputStreamWriter2.getEncoding());
            oWLModelWriter2.write();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        object = new RepositoryFileManager(this.model);
        ((RepositoryFileManager)object).saveGlobalRepositories();
        ((RepositoryFileManager)object).saveProjectRepositories(this.uri);
        System.out.println("... saving successful.");
    }

    private OWLModelWriter getOwlModelWriter(TripleStore tripleStore, Writer writer) {
        if (this.ordered) {
            return new OWLModelOrderedWriter(this.model, tripleStore, writer);
        }
        return new OWLModelWriter(this.model, tripleStore, writer);
    }
}

