/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.widget.OWLDateWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import edu.stanford.smi.protegex.owl.ui.widget.TimePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JPanel;

public class OWLDateTimeWidget
extends OWLDateWidget
implements TimePanel.Listener {
    private TimePanel timePanel;

    public OWLDateTimeWidget() {
        this.setPreferredColumns(3);
        this.timePanel = new TimePanel(this);
    }

    protected RDFSLiteral createPropertyValue(Date date) {
        String string = XMLSchemaDatatypes.getDateString(date);
        RDFSDatatype rDFSDatatype = this.getOWLModel().getRDFSDatatypeByURI(XSDDatatype.XSDdateTime.getURI());
        string = string + "T" + this.timePanel.getTime();
        return this.getOWLModel().createRDFSLiteral(string, rDFSDatatype);
    }

    protected void deleteValue() {
        super.deleteValue();
        this.timePanel.clear();
    }

    protected Component getCenterComponent() {
        Component component = super.getCenterComponent();
        JPanel jPanel = new JPanel(new BorderLayout(4, 0));
        jPanel.add("Center", component);
        jPanel.add("East", this.timePanel);
        return jPanel;
    }

    protected void setValue(String string) {
        super.setValue(string);
        if (string != null) {
            int n = string.indexOf("T");
            if (n >= 0) {
                string = string.substring(n + 1);
                this.timePanel.setTime(string);
            } else {
                this.timePanel.clear();
            }
        } else {
            this.timePanel.clear();
        }
    }

    public void timeChanged(TimePanel timePanel) {
        this.updateValues();
    }

    protected void updateComponents() {
        super.updateComponents();
        RDFResource rDFResource = this.getEditedResource();
        RDFProperty rDFProperty = this.getRDFProperty();
        this.timePanel.setEnabled(rDFResource != null && rDFProperty != null && rDFResource.isEditable());
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return OWLWidgetMapper.isSuitable(OWLDateTimeWidget.class, cls, slot);
    }
}

