/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.AbstractTriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class HeaderWidget
extends AbstractSlotWidget {
    private AbstractTriplesComponent component;

    public void activate(AbstractTriplesComponent abstractTriplesComponent) {
        if (this.component != null) {
            this.removeAll();
            ComponentUtilities.dispose((Component)this.component);
        }
        this.component = abstractTriplesComponent;
        this.component.setSubject((RDFResource)this.getInstance());
        this.add("Center", this.component);
        this.revalidate();
    }

    public void activateAnnotationsComponent() {
        RDFProperty rDFProperty = (RDFProperty)this.getSlot();
        this.activate(new AnnotationsComponent(rDFProperty){

            protected void addButtons(LabeledComponent labeledComponent) {
                super.addButtons(labeledComponent);
                labeledComponent.addHeaderSeparator();
                labeledComponent.addHeaderSeparator();
                labeledComponent.addHeaderButton((Action)new AbstractAction("Switch to Triples", OWLIcons.getImageIcon("Triples")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        HeaderWidget.this.activateTriplesComponent();
                    }
                });
            }
        });
    }

    public void activateTriplesComponent() {
        RDFProperty rDFProperty = (RDFProperty)this.getSlot();
        this.activate(new TriplesComponent(rDFProperty){

            protected void addButtons(LabeledComponent labeledComponent) {
                super.addButtons(labeledComponent);
                labeledComponent.addHeaderSeparator();
                labeledComponent.addHeaderSeparator();
                labeledComponent.addHeaderButton((Action)new AbstractAction("Switch to Annotations", OWLIcons.getImageIcon("AnnotationsTable")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        HeaderWidget.this.activateAnnotationsComponent();
                    }
                });
            }
        });
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.activateAnnotationsComponent();
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return OWLWidgetMapper.isSuitable(HeaderWidget.class, cls, slot);
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        if (instance instanceof RDFResource) {
            RDFResource rDFResource = (RDFResource)instance;
            this.component.setSubject(rDFResource);
        }
    }
}

