/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.Task;
import edu.stanford.smi.protegex.owl.model.TaskManager;
import edu.stanford.smi.protegex.owl.testing.OWLModelTest;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.ui.testing.AbstractOWLModelTestAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class OWLTestAction
extends AbstractOWLModelTestAction {
    public String getIconFileName() {
        return "Test";
    }

    public String getName() {
        return "Run ontology tests...";
    }

    protected List run(OWLTest[] oWLTestArray, Task task) {
        TaskManager taskManager = this.owlModel.getTaskManager();
        ArrayList arrayList = new ArrayList();
        double d = oWLTestArray.length * 4;
        int n = 0;
        for (int i = 0; i < oWLTestArray.length && !task.isCancelled(); ++i) {
            try {
                OWLTest oWLTest = oWLTestArray[i];
                String string = oWLTest.getClass().getName();
                int n2 = string.lastIndexOf(46);
                taskManager.setMessage(task, string.substring(n2 + 1));
                taskManager.setProgress(task, (int)((double)n++ / d * 100.0));
                if (oWLTest instanceof OWLModelTest) {
                    this.runOWLModelTest(arrayList, (OWLModelTest)oWLTest);
                }
                taskManager.setProgress(task, (int)((double)n++ / d * 100.0));
                if (oWLTest instanceof RDFSClassTest) {
                    this.runOWLClsTest(arrayList, (RDFSClassTest)oWLTest);
                }
                taskManager.setProgress(task, (int)((double)n++ / d * 100.0));
                if (oWLTest instanceof RDFPropertyTest) {
                    this.runOWLPropertyTest(arrayList, (RDFPropertyTest)oWLTest);
                }
                taskManager.setProgress(task, (int)((double)n++ / d * 100.0));
                if (!(oWLTest instanceof RDFResourceTest)) continue;
                this.runOWLInstanceTest(arrayList, (RDFResourceTest)oWLTest);
                continue;
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            }
        }
        return arrayList;
    }
}

