/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;

public class TooltippedSelectableTree
extends SelectableTree {
    public TooltippedSelectableTree(Action action, LazyTreeRoot lazyTreeRoot) {
        super(action, lazyTreeRoot);
        final int n = ToolTipManager.sharedInstance().getDismissDelay();
        this.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                ToolTipManager.sharedInstance().setDismissDelay(n);
            }
        });
        this.setToolTipText("");
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TreePath treePath;
        int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (n >= 0 && (treePath = this.getPathForRow(n)) != null) {
            Object object = treePath.getLastPathComponent();
            RDFResource rDFResource = null;
            if (object instanceof LazyTreeNode) {
                LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath.getLastPathComponent();
                rDFResource = (RDFResource)lazyTreeNode.getUserObject();
            }
            if (rDFResource != null) {
                ToolTipManager.sharedInstance().setDismissDelay(1000000);
                return OWLUI.getOWLToolTipText(rDFResource);
            }
        }
        return null;
    }
}

