/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.ModelUtilities;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.TreePopupMenuMouseListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.widget.AbstractTreeWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.ToggleSuperclassExplorerAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResultsViewModelFind;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreeNode;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreeRoot;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public abstract class SubsumptionTreePanel
extends SelectableContainer
implements Hierarchy,
ClassTreePanel {
    private HeaderComponent headerComponent;
    private LabeledComponent lc;
    private OWLModel owlModel;
    private static final int MAX_EXPANSIONS = 100;
    private Slot superclassesSlot;
    private Action viewAction;
    public static final String TYPE = "Subclass Explorer";

    public SubsumptionTreePanel(Cls cls, Slot slot, Slot slot2, boolean bl) {
        this(new SubsumptionTreeRoot(cls, slot), slot2, bl);
    }

    public SubsumptionTreePanel(LazyTreeRoot lazyTreeRoot, Slot slot, boolean bl) {
        this(lazyTreeRoot, slot, bl, new DefaultClassFind((OWLModel)slot.getKnowledgeBase(), 1));
    }

    public SubsumptionTreePanel(LazyTreeRoot lazyTreeRoot, Slot slot, boolean bl, ResultsViewModelFind resultsViewModelFind) {
        this.superclassesSlot = slot;
        this.setPreferredSize(new Dimension(260, 400));
        this.setMinimumSize(new Dimension(100, 100));
        this.owlModel = (OWLModel)slot.getKnowledgeBase();
        this.viewAction = this.createViewClsAction();
        ClassTree classTree = this.createSelectableTree(this.viewAction, lazyTreeRoot);
        classTree.setLargeModel(true);
        classTree.setSelectionRow(0);
        classTree.setAutoscrolls(true);
        this.setSelectable(classTree);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane((Component)((Object)classTree)), "Center");
        FindInDialogAction findInDialogAction = new FindInDialogAction(resultsViewModelFind, Icons.getFindClsIcon(), classTree, true);
        ResourceFinder resourceFinder = new ResourceFinder(findInDialogAction);
        jPanel.add((Component)resourceFinder, "South");
        resourceFinder.addButton(new ToggleSuperclassExplorerAction(this, bl));
        this.lc = new LabeledComponent(this.getTitle(), (Component)jPanel, true);
        WidgetUtilities.addViewButton(this.lc, this.viewAction);
        classTree.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                SubsumptionTreePanel.this.updateActions();
            }
        });
        JLabel jLabel = ComponentFactory.createLabel((String)this.owlModel.getProject().getName(), (Icon)Icons.getProjectIcon(), (int)2);
        this.headerComponent = new HeaderComponent("CLASS BROWSER", "For Project", (JComponent)jLabel);
        this.setLayout(new BorderLayout());
        this.add("North", (Component)this.headerComponent);
        this.add("Center", (Component)this.lc);
        classTree.addMouseListener((MouseListener)new TreePopupMenuMouseListener((JTree)((Object)classTree)){

            public JPopupMenu getPopupMenu() {
                return SubsumptionTreePanel.this.getPopupMenu();
            }
        });
    }

    protected JPopupMenu createPopupMenu(Cls cls) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (cls instanceof RDFResource) {
            ResourceActionManager.addResourceActions(jPopupMenu, (Component)((Object)this), (RDFResource)cls);
        }
        return jPopupMenu;
    }

    protected ClassTree createSelectableTree(Action action, LazyTreeRoot lazyTreeRoot) {
        ClassTree classTree = new ClassTree(action, lazyTreeRoot);
        classTree.setCellRenderer((TreeCellRenderer)((Object)new ResourceRenderer(this.superclassesSlot)));
        return classTree;
    }

    protected Action createViewClsAction() {
        return new ViewAction("View selected class", this){

            public void onView(Object object) {
                SubsumptionTreePanel.this.owlModel.getProject().show((Instance)((Cls)object));
            }
        };
    }

    public void expandRoot() {
        this.setExpandedCls(this.owlModel.getOWLThingClass(), true);
    }

    public void extendSelection(Cls cls) {
        ComponentUtilities.extendSelection((JTree)this.getTree(), (Object)cls);
    }

    public JTree getClsesTree() {
        return this.getTree();
    }

    public Cls getDisplayParent() {
        TreePath treePath = this.getTree().getSelectionModel().getLeadSelectionPath().getParentPath();
        LazyTreeNode lazyTreeNode = (LazyTreeNode)treePath.getLastPathComponent();
        Object object = lazyTreeNode.getUserObject();
        return object instanceof Cls ? (Cls)object : null;
    }

    public HeaderComponent getHeaderComponent() {
        return this.headerComponent;
    }

    private Action getHideClassAction() {
        return new AbstractAction("Hide class", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Cls cls : SubsumptionTreePanel.this.getSelection()) {
                    cls.setVisible(false);
                }
            }
        };
    }

    protected LabeledComponent getLabeledComponent() {
        return this.lc;
    }

    protected OWLModel getOWLModel() {
        return this.owlModel;
    }

    public List getPathToRoot(OWLNamedClass oWLNamedClass) {
        return this.getPathToRoot(oWLNamedClass, new LinkedList());
    }

    private List getPathToRoot(OWLNamedClass oWLNamedClass, LinkedList linkedList) {
        linkedList.add(0, oWLNamedClass);
        OWLNamedClass oWLNamedClass2 = oWLNamedClass.getOWLModel().getOWLThingClass();
        List list = oWLNamedClass.getDirectOwnSlotValues(this.superclassesSlot);
        for (Cls cls : list) {
            if (cls.equals(oWLNamedClass2)) {
                linkedList.add(0, cls);
                return linkedList;
            }
            if (!oWLNamedClass.isVisible() || !(cls instanceof OWLNamedClass)) continue;
            this.getPathToRoot((OWLNamedClass)cls, linkedList);
            break;
        }
        return linkedList;
    }

    public Collection getPathsToRoot(OWLNamedClass oWLNamedClass) {
        ArrayList arrayList = new ArrayList();
        this.getPathsToRoot(oWLNamedClass, new LinkedList(), arrayList);
        return arrayList;
    }

    private void getPathsToRoot(OWLNamedClass oWLNamedClass, List list, Collection collection) {
        list.add(0, oWLNamedClass);
        OWLNamedClass oWLNamedClass2 = oWLNamedClass.getOWLModel().getOWLThingClass();
        List list2 = oWLNamedClass.getDirectOwnSlotValues(this.superclassesSlot);
        for (Cls cls : list2) {
            ArrayList<Cls> arrayList;
            if (cls.equals(oWLNamedClass2)) {
                arrayList = new ArrayList<Cls>(list);
                arrayList.add(0, cls);
                collection.add(arrayList);
                continue;
            }
            if (!oWLNamedClass.isVisible() || !(cls instanceof OWLNamedClass) || list.contains(cls)) continue;
            arrayList = new ArrayList(list);
            this.getPathsToRoot((OWLNamedClass)cls, arrayList, collection);
        }
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu jPopupMenu = null;
        Collection collection = this.getSelection();
        if (collection.size() == 1) {
            Cls cls = (Cls)CollectionUtilities.getFirstItem((Collection)collection);
            jPopupMenu = this.createPopupMenu(cls);
        }
        return jPopupMenu;
    }

    public RDFSClass getSelectedClass() {
        return this.getSelectedCls();
    }

    OWLNamedClass getSelectedCls() {
        TreePath treePath;
        SubsumptionTreeNode subsumptionTreeNode;
        JTree jTree = this.getTree();
        if (jTree.getSelectionCount() == 1 && (subsumptionTreeNode = (SubsumptionTreeNode)((Object)(treePath = jTree.getSelectionPath()).getLastPathComponent())).getCls() instanceof OWLNamedClass) {
            return (OWLNamedClass)subsumptionTreeNode.getCls();
        }
        return null;
    }

    public String getType() {
        return TYPE;
    }

    public JTree getTree() {
        return (JTree)this.getSelectable();
    }

    private Action getUnhideClassAction() {
        return new AbstractAction("Make class visible", Icons.getBlankIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                for (Cls cls : SubsumptionTreePanel.this.getSelection()) {
                    cls.setVisible(true);
                }
            }
        };
    }

    public boolean isDefaultSynchronized() {
        return true;
    }

    public void removeSelection() {
        ComponentUtilities.removeSelection((JTree)this.getTree());
    }

    public void setDisplayParent(Cls cls) {
        AbstractTreeWidget.setDisplayParent((JTree)this.getTree(), (Object)cls);
    }

    public void setExpandedCls(Cls cls, boolean bl) {
        List list = ModelUtilities.getPathToRoot((Cls)cls);
        ComponentUtilities.setExpanded((JTree)this.getTree(), (Collection)list, (boolean)bl);
    }

    public void setFinderComponent(JComponent jComponent) {
        this.add(jComponent, "South");
    }

    public void setRenderer(DefaultRenderer defaultRenderer) {
        this.getTree().setCellRenderer((TreeCellRenderer)defaultRenderer);
    }

    public void setSelectedClass(RDFSClass rDFSClass) {
        OWLUI.setSelectedNodeInTree((SelectableTree)this.getTree(), rDFSClass);
    }

    public String toString() {
        return "SubsumptionTreePanel";
    }

    protected void updateActions() {
    }

    public static interface SuperClsesPanel {
        public void setCls(OWLNamedClass var1);
    }
}

