/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.vocabulary.OWL;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.creator.JenaCreator;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTree;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassesPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreeNode;
import edu.stanford.smi.protegex.owl.ui.subsumption.SubsumptionTreePanel;
import edu.stanford.smi.protegex.owl.ui.widget.ModalProgressBarManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class InferredSubsumptionTreePanel
extends SubsumptionTreePanel {
    private Action assertAction = new AbstractAction("Assert selected change(s)", OWLIcons.getAssertChangeIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            InferredSubsumptionTreePanel.this.assertSelectedChange();
        }
    };
    private Action displayChangedAction = new AbstractAction("Display changed classes in list", OWLIcons.getDisplayChangedClassesIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab((Component)((Object)InferredSubsumptionTreePanel.this));
            if (oWLClassesTab != null) {
                oWLClassesTab.refreshChangedClses();
            }
        }
    };
    private Action saveInferredAction = new AbstractAction("Save inferred version as file...", OWLIcons.getSaveInferredIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            InferredSubsumptionTreePanel.this.saveInferred();
        }
    };
    private static final String TITLE = "Inferred Hierarchy";

    public InferredSubsumptionTreePanel(OWLModel oWLModel) {
        super(oWLModel.getOWLThingClass(), (Slot)((AbstractOWLModel)oWLModel).getProtegeInferredSubclassesProperty(), ((AbstractOWLModel)oWLModel).getProtegeInferredSuperclassesProperty(), true);
        this.assertAction.setEnabled(false);
        this.getLabeledComponent().addHeaderButton(this.assertAction);
        this.getLabeledComponent().addHeaderButton(this.displayChangedAction);
        this.getLabeledComponent().addHeaderButton(this.saveInferredAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertSelectedChange() {
        OWLNamedClass oWLNamedClass = this.getSelectedCls();
        OWLModel oWLModel = this.getOWLModel();
        ChangedClassesPanel changedClassesPanel = ChangedClassesPanel.get(oWLModel);
        try {
            oWLModel.beginTransaction("Assert change for " + oWLNamedClass.getBrowserText());
            changedClassesPanel.getTableModel().assertChange(oWLNamedClass);
        }
        catch (Exception exception) {
            OWLUI.handleError(oWLModel, exception);
        }
        finally {
            oWLModel.endTransaction();
        }
    }

    public Hierarchy createClone() {
        return new InferredSubsumptionTreePanel(this.getOWLModel());
    }

    protected ClassTree createSelectableTree(Action action, LazyTreeRoot lazyTreeRoot) {
        return new InferredChangesClassTree(action, lazyTreeRoot);
    }

    protected Action createViewClsAction() {
        return new AbstractAction("View class", OWLIcons.getViewIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                Collection collection = InferredSubsumptionTreePanel.this.getSelection();
                if (!collection.isEmpty()) {
                    Cls cls = (Cls)collection.iterator().next();
                    cls.getProject().show((Instance)cls);
                }
            }
        };
    }

    public String getTitle() {
        return TITLE;
    }

    public void navigateToResource(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSClass) {
            this.setSelectedClass((RDFSClass)rDFResource);
        }
    }

    private void saveInferred() {
        JFileChooser jFileChooser = new JFileChooser(".");
        if (jFileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            OWLNamedClass oWLNamedClass2;
            File file = jFileChooser.getSelectedFile();
            OWLModel oWLModel = this.getOWLModel();
            ArrayList<OWLNamedClass> arrayList = new ArrayList<OWLNamedClass>();
            for (OWLNamedClass oWLNamedClass2 : oWLModel.getUserDefinedOWLNamedClasses()) {
                if (oWLNamedClass2.isProbeClass()) continue;
                arrayList.add(oWLNamedClass2);
            }
            Object object = oWLModel.getNamespaceManager().getDefaultNamespace();
            if (((String)object).endsWith("#")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            oWLNamedClass2 = new JenaCreator(oWLModel, false, true, arrayList, new ModalProgressBarManager("Preparing File")).createOntModel();
            try {
                String string = oWLModel.getNamespaceManager().getDefaultNamespace();
                Ontology ontology = Jena.getDefaultJenaOntology(string, (OntModel)oWLNamedClass2);
                ontology.addProperty(OWL.versionInfo, (RDFNode)oWLNamedClass2.createTypedLiteral("classified"));
                JenaOWLModel.save(file, (OntModel)oWLNamedClass2, "RDF/XML-ABBREV", string);
                ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "Successfully saved to " + file + ".");
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                ProtegeUI.getModalDialogFactory().showThrowable(oWLModel, exception);
            }
        }
    }

    protected void updateActions() {
        super.updateActions();
        OWLNamedClass oWLNamedClass = this.getSelectedCls();
        this.assertAction.setEnabled(oWLNamedClass != null && oWLNamedClass.getClassificationStatus() == 3 && ChangedClassesPanel.get(this.getOWLModel()).getTableModel().contains(oWLNamedClass));
    }

    private class MovedResourcesRenderer
    extends ResourceRenderer {
        public MovedResourcesRenderer(Slot slot) {
            super(slot);
        }

        protected Color getTextColor() {
            ChangedClassesPanel changedClassesPanel = ChangedClassesPanel.get(InferredSubsumptionTreePanel.this.getOWLModel());
            if (changedClassesPanel.contains(this.loadedClass)) {
                return Color.blue;
            }
            return super.getTextColor();
        }
    }

    private class InferredChangesClassTree
    extends ClassTree {
        public InferredChangesClassTree(Action action, LazyTreeRoot lazyTreeRoot) {
            super(action, lazyTreeRoot);
            RDFProperty rDFProperty = InferredSubsumptionTreePanel.this.getOWLModel().getRDFProperty("protege:inferredSubclassOf");
            this.setCellRenderer((TreeCellRenderer)((Object)new MovedResourcesRenderer(rDFProperty)));
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = this.getPathForRow(n);
            if (treePath != null && treePath.getPathCount() > 0) {
                SubsumptionTreeNode subsumptionTreeNode = (SubsumptionTreeNode)((Object)treePath.getLastPathComponent());
                RDFSClass rDFSClass = (RDFSClass)subsumptionTreeNode.getCls();
                ChangedClassesPanel changedClassesPanel = ChangedClassesPanel.get(InferredSubsumptionTreePanel.this.getOWLModel());
                string = changedClassesPanel.getChangeText(rDFSClass);
                if (string == null) {
                    string = OWLUI.getOWLToolTipText(rDFSClass);
                }
            }
            return string;
        }
    }
}

