/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class ChangedClassItem
implements Comparable {
    private OWLNamedClass cls;
    private Collection addedSuperClses = new ArrayList();
    private Collection removedSuperClses = new ArrayList();

    ChangedClassItem(OWLNamedClass oWLNamedClass) {
        this.cls = oWLNamedClass;
    }

    void addAddedSuperCls(Cls cls) {
        this.addedSuperClses.add(cls);
    }

    void addRemovedSuperCls(Cls cls) {
        this.removedSuperClses.add(cls);
    }

    void assertChange() {
        for (RDFSClass rDFSClass : this.addedSuperClses) {
            this.cls.addSuperclass(rDFSClass);
        }
        for (RDFSClass rDFSClass : this.removedSuperClses) {
            this.cls.removeSuperclass(rDFSClass);
        }
        OWLUtil.setConsistentClassificationStatus(this.cls);
    }

    public int compareTo(Object object) {
        ChangedClassItem changedClassItem = (ChangedClassItem)object;
        return this.cls.compareTo(changedClassItem.cls);
    }

    OWLNamedClass getCls() {
        return this.cls;
    }

    void removeAddedSuperCls(Cls cls) {
        this.removedSuperClses.add(cls);
    }

    public String toString() {
        if (this.cls.getClassificationStatus() == 2) {
            return "Inconsistent";
        }
        if (this.addedSuperClses.size() == 1 && this.removedSuperClses.size() == 1) {
            Cls cls = (Cls)this.removedSuperClses.iterator().next();
            Cls cls2 = (Cls)this.addedSuperClses.iterator().next();
            return "Moved from " + cls.getBrowserText() + " to " + cls2.getBrowserText();
        }
        if (this.addedSuperClses.size() > 0 && this.removedSuperClses.size() > 0) {
            return this.toString("Moved from", this.removedSuperClses.iterator()) + this.toString(" to", this.addedSuperClses.iterator());
        }
        if (this.addedSuperClses.size() > 0) {
            Iterator iterator = this.addedSuperClses.iterator();
            return this.toString("Added", iterator);
        }
        Iterator iterator = this.removedSuperClses.iterator();
        return this.toString("Removed", iterator);
    }

    private String toString(String string, Iterator iterator) {
        int n = 0;
        String string2 = "";
        while (iterator.hasNext()) {
            Cls cls = (Cls)iterator.next();
            string2 = string2 + cls.getBrowserText();
            if (iterator.hasNext()) {
                string2 = string2 + ", ";
            }
            ++n;
        }
        return string + " " + string2;
    }
}

