/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.search.finder.AbstractFindResultsView;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResultsPanel;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchAdapter;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public class RetainFindResultsPanel
extends ResultsPanel {
    private FindResultsPanel resultsPanel;
    private String tabName = "Search";
    private Action refreshAction = new AbstractAction("Refresh", OWLIcons.getImageIcon("Refresh")){

        public void actionPerformed(ActionEvent actionEvent) {
            RetainFindResultsPanel.this.resultsPanel.refresh();
        }
    };

    public RetainFindResultsPanel(Find find, AbstractFindResultsView abstractFindResultsView) {
        super(find.getModel());
        this.resultsPanel = new FindResultsPanel(find, abstractFindResultsView);
        find.addResultListener(new SearchAdapter(){

            public void searchEvent(Find find) {
                RetainFindResultsPanel.this.rename(find.getSummaryText());
            }
        });
        this.setCenterComponent(this.resultsPanel);
        this.addButton(this.refreshAction);
    }

    public RetainFindResultsPanel(OWLModel oWLModel, FindResultsPanel findResultsPanel) {
        super(oWLModel);
        this.resultsPanel = findResultsPanel;
        this.setCenterComponent(this.resultsPanel);
        this.addButton(this.refreshAction);
    }

    public Icon getIcon() {
        return Icons.getFindIcon();
    }

    public String getTabName() {
        return this.tabName;
    }

    private void rename(String string) {
        this.tabName = string;
        OWLModel oWLModel = (OWLModel)ProjectManager.getProjectManager().getCurrentProject().getKnowledgeBase();
        JTabbedPane jTabbedPane = ResultsPanelManager.getTabbedPane(oWLModel);
        if (jTabbedPane != null) {
            for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
                ResultsPanel resultsPanel = (ResultsPanel)jTabbedPane.getComponentAt(i);
                if (resultsPanel != this) continue;
                jTabbedPane.setMnemonicAt(i, 70);
                jTabbedPane.setTitleAt(i, this.tabName);
            }
        }
        this.revalidate();
    }

    public void requestDispose(JComponent jComponent) {
    }
}

