/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResult;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchAdapter;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchListener;
import edu.stanford.smi.protegex.owl.ui.search.finder.ThreadedFind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

public class ResultsViewModelFind
extends AbstractTableModel
implements Find,
ListModel {
    protected List orderedKeys;
    private HashMap map;
    private List listeners = new ArrayList(1);
    private Find findAlg;

    public ResultsViewModelFind(OWLModel oWLModel, int n) {
        this.findAlg = new ThreadedFind(oWLModel, n){

            protected boolean isValidFrameToSearch(Frame frame) {
                return super.isValidFrameToSearch(frame) && ResultsViewModelFind.this.isValidFrameToSearch(frame);
            }
        };
        this.findAlg.addResultListener(new SearchAdapter(){

            public void searchEvent(Find find) {
                ResultsViewModelFind.this.fireDataChanged();
            }
        });
    }

    public int getSize() {
        if (this.orderedKeys != null) {
            return this.orderedKeys.size();
        }
        return 0;
    }

    public synchronized Object getElementAt(int n) {
        return this.orderedKeys.get(n);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listeners.add(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listeners.remove(listDataListener);
    }

    public int getRowCount() {
        return this.getSize();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int n) {
        return FindResult.getColumnName(n);
    }

    public synchronized Object getValueAt(int n, int n2) {
        if (this.orderedKeys.size() > n) {
            Object e = this.orderedKeys.get(n);
            FindResult findResult = (FindResult)this.map.get(e);
            return findResult.get(n2);
        }
        return null;
    }

    private synchronized void fireDataChanged() {
        this.map = new HashMap(this.getResults());
        this.orderedKeys = new LinkedList(this.map.keySet());
        ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, this.getSize());
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ListDataListener)iterator.next()).contentsChanged(listDataEvent);
        }
        this.fireTableDataChanged();
    }

    public void startSearch(String string) {
        this.findAlg.startSearch(string);
    }

    public void startSearch(String string, int n) {
        this.findAlg.startSearch(string, n);
    }

    public void cancelSearch() {
        this.findAlg.cancelSearch();
    }

    public Map getResults() {
        return this.findAlg.getResults();
    }

    public Set getResultResources() {
        return this.findAlg.getResultResources();
    }

    public int getResultCount() {
        return this.findAlg.getResultCount();
    }

    public String getLastSearch() {
        return this.findAlg.getLastSearch();
    }

    public String getSummaryText() {
        return this.findAlg.getSummaryText();
    }

    public String getDescription() {
        return this.findAlg.getDescription();
    }

    public OWLModel getModel() {
        return this.findAlg.getModel();
    }

    public int getNumSearchProperties() {
        return this.findAlg.getNumSearchProperties();
    }

    public int getSearchType() {
        return this.findAlg.getSearchType();
    }

    public void addResultListener(SearchListener searchListener) {
        this.findAlg.addResultListener(searchListener);
    }

    public boolean removeResultListener(SearchListener searchListener) {
        return this.findAlg.removeResultListener(searchListener);
    }

    protected boolean isValidFrameToSearch(Frame frame) {
        return true;
    }
}

