/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SearchNamedClassPanel
extends JPanel {
    private OWLModel owlModel;
    private RDFSNamedClass rootClass;
    private JList propertyList;
    private JTextField textField;

    public SearchNamedClassPanel(RDFSNamedClass rDFSNamedClass) {
        this.owlModel = rDFSNamedClass.getOWLModel();
        this.rootClass = rDFSNamedClass;
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        for (RDFProperty rDFProperty : this.owlModel.getRDFProperties()) {
            if (!(rDFProperty instanceof OWLDatatypeProperty) || rDFProperty.getValueType() != ValueType.STRING) continue;
            arrayList.add(rDFProperty);
        }
        Frame[] frameArray = arrayList.toArray(new Frame[0]);
        Arrays.sort(frameArray, new FrameComparator());
        this.propertyList = new JList<Frame>(frameArray);
        this.propertyList.setCellRenderer(new ResourceRenderer());
        this.propertyList.setSelectedIndex(0);
        this.textField = new JTextField();
        this.setLayout(new BorderLayout(10, 10));
        this.add("Center", (Component)new LabeledComponent("Available Properties", new JScrollPane(this.propertyList)));
        this.add("South", (Component)new LabeledComponent("Search Pattern", (Component)this.textField));
    }

    public List getResult() {
        RDFProperty rDFProperty = (RDFProperty)this.propertyList.getSelectedValue();
        String string = this.textField.getText();
        Collection collection = this.owlModel.getMatchingResources(rDFProperty, string, -1);
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : collection) {
            if (!(frame instanceof RDFSNamedClass) || !((RDFSNamedClass)frame).isSubclassOf(this.rootClass)) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    public static List showDialog(Component component, RDFSNamedClass rDFSNamedClass) {
        SearchNamedClassPanel searchNamedClassPanel = new SearchNamedClassPanel(rDFSNamedClass);
        int n = ProtegeUI.getModalDialogFactory().showDialog(component, searchNamedClassPanel, "Search subclasses of " + rDFSNamedClass.getBrowserText(), 11, null, true);
        if (n == 1) {
            return searchNamedClassPanel.getResult();
        }
        return null;
    }
}

