/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourceselection;

import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.resourceselection.DropDownOverlayIcon;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionComboBox;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public abstract class ResourceSelectionAction
extends AbstractAction
implements ResourceSelectionListener {
    public static boolean activated = true;
    private boolean multipleSelection;
    private boolean showHiddenResources = false;

    public ResourceSelectionAction(String string, Icon icon) {
        this(string, icon, false);
    }

    public ResourceSelectionAction(String string, Icon icon, boolean bl) {
        super(string, icon);
        this.multipleSelection = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.multipleSelection) {
            Collection collection = this.pickResources();
            for (RDFResource rDFResource : collection) {
                this.resourceSelected(rDFResource);
            }
        } else {
            RDFResource rDFResource = this.pickResource();
            if (rDFResource != null) {
                this.resourceSelected(rDFResource);
            }
        }
    }

    public void activateComboBox(final JButton jButton) {
        if (activated) {
            jButton.setRolloverIcon(new DropDownOverlayIcon(jButton.getIcon(), jButton));
            jButton.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && ResourceSelectionAction.this.isEnabled()) {
                        ArrayList<RDFResource> arrayList = null;
                        if (ResourceSelectionAction.this.getShowHiddenResources()) {
                            arrayList = ResourceSelectionAction.this.getSelectableResources();
                        } else {
                            arrayList = new ArrayList<RDFResource>();
                            for (RDFResource rDFResource : ResourceSelectionAction.this.getSelectableResources()) {
                                if (!rDFResource.isVisible() && !rDFResource.isSystem()) continue;
                                arrayList.add(rDFResource);
                            }
                        }
                        ResourceSelectionComboBox.selectResource(arrayList, jButton, 0, ResourceSelectionAction.this, ResourceSelectionAction.this.getRenderer());
                    }
                }
            });
        }
    }

    public ListCellRenderer getRenderer() {
        return new FrameRenderer();
    }

    public abstract Collection getSelectableResources();

    public boolean getShowHiddenResources() {
        return this.showHiddenResources;
    }

    public RDFResource pickResource() {
        return null;
    }

    public Collection pickResources() {
        RDFResource rDFResource = this.pickResource();
        if (rDFResource == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singleton(rDFResource);
    }

    public static void setActivated(boolean bl) {
        activated = bl;
    }

    public void setShowHiddenResources(boolean bl) {
        this.showHiddenResources = bl;
    }
}

