/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.swrl.ui.SWRLProjectPlugin;
import edu.stanford.smi.protegex.owl.swrl.ui.actions.FindRulesAction;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceActionManager;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesComponent;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.AddPropertyWidgetToFormAction;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.EditTypeAction;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.EditTypeFormAction;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.InstanceNameComponent;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.RemovePropertyWidgetFromFormAction;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplayPluginManager;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageAction;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestInstanceAction;
import edu.stanford.smi.protegex.owl.ui.widget.InferredModeWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class ResourceDisplay
extends InstanceDisplay
implements ResourcePanel {
    public static final int DEFAULT_TYPE_CLS = 0;
    public static final int DEFAULT_TYPE_SLOT = 1;
    public static final int DEFAULT_TYPE_INSTANCE = 2;
    private AddPropertyWidgetToFormAction addPropertyWidgetToFormAction;
    private JComponent centerComponent;
    private int defaultType;
    private EditTypeAction editTypeAction;
    private EditTypeFormAction editTypeFormAction;
    private FindUsageAction findUsageAction;
    private FindRulesAction findRulesAction;
    private JCheckBox inferredBox;
    private static boolean inferredBoxVisible = true;
    private InstanceNameComponent instanceNameComponent;
    private JPanel mainPanel;
    private JToolBar northToolBar;
    private OWLModel owlModel;
    private RemovePropertyWidgetFromFormAction removePropertyWidgetFromFormAction;
    private JScrollPane scrollPane;
    public static final int SMALL_BUTTON_WIDTH = 15;
    private JPanel southEastPanel;
    private JToolBar southToolBar;
    private Set suppressedTypes = new HashSet();
    private OWLTestInstanceAction testInstanceAction;
    private TriplesComponent triplesComponent;
    private Set actionRefreshProperties;
    private PropertyValueListener propertyValueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            if (ResourceDisplay.this.actionRefreshProperties.contains(rDFProperty)) {
                ResourceDisplay.this.initInstanceDisplayActions(rDFResource);
            }
        }
    };

    public ResourceDisplay(Project project, boolean bl, boolean bl2) {
        this(project);
    }

    public ResourceDisplay(Project project) {
        this(project, 2);
    }

    public ResourceDisplay(Project project, int n) {
        super(project);
        this.defaultType = n;
        this.owlModel = (OWLModel)project.getKnowledgeBase();
        this.reworkHeaderComponent();
        this.actionRefreshProperties = new HashSet();
        if (n == 0) {
            this.actionRefreshProperties.add(this.owlModel.getRDFSSubClassOfProperty());
        }
        this.centerComponent = (JComponent)this.getComponent(0);
        this.remove(this.centerComponent);
        for (int i = 0; i < this.centerComponent.getComponentCount(); ++i) {
            if (!(this.centerComponent.getComponent(i) instanceof JScrollPane)) continue;
            this.scrollPane = (JScrollPane)this.centerComponent.getComponent(i);
        }
        this.northToolBar = OWLUI.createToolBar();
        this.northToolBar.setOpaque(false);
        Container container = (Container)this.getHeaderComponent().getComponent(0);
        container.add("East", this.northToolBar);
        this.findUsageAction = new FindUsageAction(this);
        this.findRulesAction = new FindRulesAction(this);
        OWLModel oWLModel = this.owlModel;
        this.testInstanceAction = new OWLTestInstanceAction(this.owlModel, oWLModel, this);
        this.testInstanceAction.setEnabled(false);
        this.suppressedTypes.add(this.owlModel.getOWLFunctionalPropertyClass());
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:AnnotationProperty"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:InverseFunctionalProperty"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:SymmetricProperty"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:TransitiveProperty"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:DeprecatedClass"));
        this.suppressedTypes.add(this.owlModel.getRDFSNamedClass("owl:DeprecatedProperty"));
        this.mainPanel = new JPanel(new BorderLayout());
        this.addDefaultComponentsToMainPanel();
        this.add(this.mainPanel);
        this.inferredBox = new JCheckBox("Inferred View");
        this.inferredBox.setVisible(inferredBoxVisible);
        this.inferredBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourceDisplay.this.setInferredMode(ResourceDisplay.this.inferredBox.isSelected());
            }
        });
        this.loadHeader();
    }

    private void addDefaultComponentsToMainPanel() {
        this.mainPanel.add("Center", this.centerComponent);
        this.southToolBar = ComponentFactory.createToolBar();
        this.southEastPanel = new JPanel();
        this.southEastPanel.setLayout(new BoxLayout(this.southEastPanel, 0));
        this.addDefaultToolBarButtons();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", this.southToolBar);
        jPanel.add("East", this.southEastPanel);
        this.mainPanel.add("South", jPanel);
    }

    private void addDefaultToolBarButtons() {
        this.southToolBar.addSeparator(new Dimension(7, 0));
        ComponentFactory.addToolBarButton((JToolBar)this.southToolBar, (Action)((Object)this.findUsageAction));
        if (SWRLProjectPlugin.isSWRLImported(this.owlModel)) {
            this.southToolBar.addSeparator();
            ComponentFactory.addToolBarButton((JToolBar)this.southToolBar, (Action)((Object)this.findRulesAction));
        }
        this.southToolBar.addSeparator();
        ComponentFactory.addToolBarButton((JToolBar)this.southToolBar, (Action)this.testInstanceAction);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
    }

    public void clearSelection() {
    }

    protected void reworkHeaderComponent() {
        if (this.defaultType != 3) {
            this.instanceNameComponent = new InstanceNameComponent();
            HeaderComponent headerComponent = this.getHeaderComponent();
            JComponent jComponent = headerComponent.getComponent();
            Container container = jComponent.getParent();
            container.remove(jComponent);
            container.add("Center", this.instanceNameComponent);
        }
    }

    public boolean displayHostInstance(Instance instance) {
        if (instance instanceof RDFResource) {
            return this.displayHostResource((RDFResource)instance);
        }
        return false;
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        Object object = this;
        while (object != null) {
            if (!((object = ((Component)object).getParent()) instanceof HostResourceDisplay)) continue;
            return ((HostResourceDisplay)object).displayHostResource(rDFResource);
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.triplesComponent != null) {
            this.triplesComponent.dispose();
        }
    }

    protected InstanceNameComponent getInstanceNameComponent() {
        return this.instanceNameComponent;
    }

    public Dimension getPreferredSize() {
        return this.mainPanel.getPreferredSize();
    }

    public RDFResource getResource() {
        Instance instance = this.getCurrentInstance();
        if (instance instanceof RDFResource) {
            return (RDFResource)instance;
        }
        return null;
    }

    public Collection getSelection() {
        if (this.getCurrentInstance() != null) {
            return Collections.singleton(this.getCurrentInstance());
        }
        return Collections.EMPTY_LIST;
    }

    protected ClsWidget getWidget(Cls cls, Instance instance, Cls cls2) {
        if (this.isSuppressedType(cls)) {
            return null;
        }
        return super.getWidget(cls, instance, cls2);
    }

    private void initInstanceDisplayActions(RDFResource rDFResource) {
        this.findUsageAction.setEnabled(rDFResource != null);
        this.findRulesAction.setEnabled(rDFResource != null);
        this.testInstanceAction.setEnabled(rDFResource != null);
        this.southToolBar.removeAll();
        this.southEastPanel.removeAll();
        this.addDefaultToolBarButtons();
        if (rDFResource != null) {
            ResourceActionManager.addResourceActions(this.southToolBar, (Component)((Object)this), rDFResource);
            ResourceDisplayPluginManager.initInstanceDisplay(rDFResource, this.southEastPanel);
        }
        this.removeYellowStickyButtons();
        this.northToolBar.removeAll();
        this.editTypeAction = new EditTypeAction(rDFResource);
        this.editTypeFormAction = new EditTypeFormAction(rDFResource);
        this.addPropertyWidgetToFormAction = new AddPropertyWidgetToFormAction(rDFResource, this);
        this.removePropertyWidgetFromFormAction = new RemovePropertyWidgetFromFormAction(rDFResource, this);
        JButton jButton = ComponentFactory.addToolBarButton((JToolBar)this.northToolBar, (Action)this.addPropertyWidgetToFormAction, (int)15);
        jButton.setOpaque(false);
        this.addPropertyWidgetToFormAction.activateComboBox(jButton);
        JButton jButton2 = ComponentFactory.addToolBarButton((JToolBar)this.northToolBar, (Action)this.removePropertyWidgetFromFormAction, (int)15);
        jButton2.setOpaque(false);
        this.removePropertyWidgetFromFormAction.activateComboBox(jButton2);
        ComponentFactory.addToolBarButton((JToolBar)this.northToolBar, (Action)this.editTypeFormAction, (int)15).setOpaque(false);
        ComponentFactory.addToolBarButton((JToolBar)this.northToolBar, (Action)this.editTypeAction, (int)15).setOpaque(false);
        boolean bl = false;
        if (rDFResource != null) {
            bl = rDFResource.isEditable();
        }
        this.addPropertyWidgetToFormAction.setEnabled(bl);
        this.removePropertyWidgetFromFormAction.setEnabled(bl);
        boolean bl2 = rDFResource != null;
        this.editTypeAction.setEnabled(bl2);
        this.editTypeFormAction.setEnabled(bl2);
    }

    protected boolean isSuppressedType(Cls cls) {
        return this.suppressedTypes.contains(cls);
    }

    public boolean isTriplesDisplayed() {
        return this.scrollPane.getParent() == null;
    }

    protected void loadHeader() {
        if (this.getCurrentInstance() == null) {
            switch (this.defaultType) {
                case 0: {
                    this.loadHeaderWithCls(null);
                    break;
                }
                case 1: {
                    this.loadHeaderWithSlot(null);
                    break;
                }
                case 3: {
                    this.loadHeaderWithOntology(null);
                    break;
                }
                default: {
                    this.loadHeaderWithSimpleInstance(null);
                    break;
                }
            }
        } else {
            if (this.getCurrentInstance() instanceof OWLNamedClass) {
                this.getHeaderComponent().add("East", (Component)this.inferredBox);
            }
            super.loadHeader();
        }
    }

    protected void loadHeaderLabel(Instance instance) {
        RDFResource rDFResource;
        Collection collection;
        if (this.instanceNameComponent != null) {
            this.instanceNameComponent.setInstance(instance);
        } else {
            super.loadHeaderLabel(instance);
        }
        if (instance instanceof RDFResource && !(collection = (rDFResource = (RDFResource)instance).getInferredTypes()).isEmpty()) {
            JLabel jLabel = this.getHeaderLabel();
            String string = "  (inferred types: ";
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RDFSClass rDFSClass = (RDFSClass)iterator.next();
                string = string + rDFSClass.getBrowserText();
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
            string = string + ")";
            jLabel.setText(jLabel.getText() + string);
        }
    }

    protected void loadHeaderWithSimpleInstance(Instance instance) {
        super.loadHeaderWithSimpleInstance(instance);
        this.getHeaderComponent().setTitle("Individual Editor");
        this.getHeaderComponent().setComponentLabel("For Individual:");
    }

    protected void loadHeaderWithSlot(Slot slot) {
        super.loadHeaderWithSlot(slot);
        this.getHeaderComponent().setTitle("Property Editor");
        this.getHeaderComponent().setComponentLabel("For Property:");
    }

    protected void loadHeaderWithOntology(OWLOntology oWLOntology) {
        super.loadHeaderWithSimpleInstance((Instance)oWLOntology);
        this.getHeaderComponent().setTitle("Ontology Editor");
        this.getHeaderComponent().setComponentLabel("For Ontology:");
        this.getHeaderComponent().setColor(Colors.getInstanceColor());
    }

    public void notifySelectionListeners() {
    }

    protected void onDirectTypeAdded(Cls cls) {
        if (!this.isSuppressedType(cls)) {
            super.onDirectTypeAdded(cls);
        } else {
            this.loadHeader();
        }
    }

    protected void onDirectTypeRemoved(Cls cls) {
        if (!this.isSuppressedType(cls)) {
            super.onDirectTypeRemoved(cls);
        } else {
            this.loadHeader();
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
    }

    private void removeYellowStickyButtons() {
        this.getHeaderComponent().getToolBar().removeAll();
    }

    public void setInferredMode(boolean bl) {
        if (bl) {
            this.inferredBox.setVisible(true);
            inferredBoxVisible = true;
        }
        if (this.inferredBox.isSelected() != bl) {
            this.inferredBox.setSelected(bl);
        }
        Container container = (Container)this.getFirstClsWidget();
        this.setInferredMode(bl, container);
    }

    private void setInferredMode(boolean bl, Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof InferredModeWidget) {
                ((InferredModeWidget)((Object)component)).setInferredMode(bl);
            }
            if (!(component instanceof Container)) continue;
            this.setInferredMode(bl, (Container)component);
        }
    }

    public void setMode(boolean bl, boolean bl2) {
        JComponent jComponent = null;
        if (bl) {
            if (bl2) {
                this.updateTriplesComponent();
                JSplitPane jSplitPane = new JSplitPane(0, this.scrollPane, this.triplesComponent);
                jSplitPane.setDividerLocation(0.5);
                jComponent = jSplitPane;
            } else {
                jComponent = this.scrollPane;
            }
        } else {
            this.updateTriplesComponent();
            jComponent = this.triplesComponent;
        }
        this.centerComponent.removeAll();
        this.centerComponent.add("North", (Component)this.getHeaderComponent());
        this.centerComponent.add("Center", jComponent);
        this.revalidate();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.mainPanel.setBounds(0, 0, n3, n4);
    }

    public void setInstance(Instance instance) {
        if (this.getCurrentInstance() instanceof RDFResource) {
            ((RDFResource)this.getCurrentInstance()).removePropertyValueListener(this.propertyValueListener);
        }
        if (instance instanceof RDFResource) {
            ((RDFResource)instance).addPropertyValueListener(this.propertyValueListener);
        }
        super.setInstance(instance);
        if (this.triplesComponent != null) {
            if (instance instanceof RDFResource) {
                this.triplesComponent.setSubject((RDFResource)instance);
                this.triplesComponent.setVisible(true);
            } else {
                this.triplesComponent.setSubject(null);
                this.triplesComponent.setVisible(false);
            }
        }
        this.initInstanceDisplayActions(instance instanceof RDFResource ? (RDFResource)instance : null);
    }

    public void setInstance(Instance instance, Cls cls) {
        super.setInstance(instance, cls);
        this.initInstanceDisplayActions(instance instanceof RDFResource ? (RDFResource)instance : null);
    }

    public void setResource(RDFResource rDFResource) {
        this.setInstance(rDFResource);
    }

    protected boolean shouldDisplaySlot(Cls cls, Slot slot) {
        return !(slot instanceof RDFProperty) || ((RDFProperty)slot).isDomainDefined();
    }

    public void updateInferredModeOfWidgets() {
        this.setInferredMode(this.inferredBox.isSelected(), (Container)((Object)this));
    }

    private void updateTriplesComponent() {
        if (this.triplesComponent == null) {
            this.triplesComponent = new TriplesComponent(this.owlModel.getOWLVersionInfoProperty());
        }
        this.triplesComponent.setSubject((RDFResource)this.getCurrentInstance());
    }
}

