/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.resourcedisplay;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.SpringUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.InstanceNameEditor;
import java.awt.Container;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class InstanceNameComponent
extends JPanel
implements Disposable {
    private FrameListener frameListener = new FrameAdapter(){

        public void nameChanged(FrameEvent frameEvent) {
            InstanceNameComponent.this.updateAll();
        }
    };
    private Instance instance;
    private JLabel leftLabel = ComponentFactory.createLabel();
    private JLabel rightLabel = ComponentFactory.createLabel();
    private InstanceNameEditor textField = new InstanceNameEditor();

    public InstanceNameComponent() {
        SpringLayout springLayout = new SpringLayout();
        this.setLayout(springLayout);
        this.add(this.leftLabel);
        this.add(this.textField);
        this.add(this.rightLabel);
        SpringUtilities.makeCompactGrid((Container)this, (int)1, (int)3, (int)0, (int)0, (int)5, (int)0);
    }

    public void dispose() {
        this.removeListener();
    }

    protected Instance getInstance() {
        return this.instance;
    }

    protected String getTypeText(Instance instance) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = instance.getDirectTypes().iterator();
        while (iterator.hasNext()) {
            Cls cls = (Cls)iterator.next();
            stringBuffer.append(cls.getBrowserText());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    private void removeListener() {
        if (this.instance != null) {
            this.instance.removeFrameListener(this.frameListener);
        }
    }

    public void setInstance(Instance instance) {
        this.removeListener();
        this.textField.setInstance(instance);
        this.instance = instance;
        if (instance != null) {
            instance.addFrameListener(this.frameListener);
        }
        this.updateAll();
    }

    private void updateAll() {
        if (this.instance != null) {
            this.leftLabel.setIcon(this.instance.getIcon());
            String string = this.instance.getBrowserText();
            String string2 = this.instance.getName();
            if (string2.equals(string)) {
                this.leftLabel.setText("");
            } else {
                this.leftLabel.setText(string + " -   Internal name:");
            }
            this.textField.setText(string2);
            String string3 = this.getTypeText(this.instance);
            this.rightLabel.setText("  (instance of " + string3 + ")  ");
            this.setEditable(this.instance.isEditable());
        } else {
            this.leftLabel.setIcon(null);
            this.leftLabel.setText("");
            this.rightLabel.setText("");
            this.textField.setText("");
            this.setEditable(false);
        }
    }

    public void setText(String string) {
        this.textField.setText(string);
    }

    public void selectAll() {
        this.textField.selectAll();
    }

    public void setEditable(boolean bl) {
        this.textField.setEditable(bl);
    }

    protected String getInvalidTextDescription(String string) {
        return this.textField.getInvalidTextDescription(string);
    }

    protected boolean validateText(String string) {
        return this.textField.validateText(string);
    }

    protected void commitChanges() {
        this.textField.attemptCommit();
    }
}

