/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository.action;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.impl.FTPRepository;
import edu.stanford.smi.protegex.owl.ui.repository.AbstractRepositoriesPanel;
import edu.stanford.smi.protegex.owl.ui.repository.action.RepositoryAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class RepositoryActionManager {
    private static RepositoryActionManager instance;
    private HashSet actions = new HashSet();

    private RepositoryActionManager() {
        this.actions.add(new RepositoryAction(){

            public String getName() {
                return "Refresh repository";
            }

            public boolean isSuitable(Repository repository, OWLModel oWLModel) {
                return true;
            }

            public void actionPerformed(Repository repository, AbstractRepositoriesPanel abstractRepositoriesPanel, OWLModel oWLModel) {
                repository.refresh();
                abstractRepositoriesPanel.reloadUI();
            }
        });
        this.actions.add(new RepositoryAction(){

            public String getName() {
                return "Upload using FTP";
            }

            public boolean isSuitable(Repository repository, OWLModel oWLModel) {
                return repository instanceof FTPRepository;
            }

            public void actionPerformed(Repository repository, AbstractRepositoriesPanel abstractRepositoriesPanel, OWLModel oWLModel) {
                FTPRepository fTPRepository = (FTPRepository)repository;
                fTPRepository.ftpPut();
            }
        });
    }

    public static synchronized RepositoryActionManager getInstance() {
        if (instance == null) {
            instance = new RepositoryActionManager();
        }
        return instance;
    }

    public Collection getActions(Repository repository, OWLModel oWLModel) {
        ArrayList<RepositoryAction> arrayList = new ArrayList<RepositoryAction>();
        for (RepositoryAction repositoryAction : this.actions) {
            if (!repositoryAction.isSuitable(repository, oWLModel)) continue;
            arrayList.add(repositoryAction);
        }
        return arrayList;
    }
}

