/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.query;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLResultsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SPARQLQueryPanel
extends JPanel {
    private OWLModel owlModel;
    private JTextArea textArea;
    private static String TEXT = "SELECT ?subject ?object\nWHERE { ?subject rdfs:subClassOf ?object }";

    public SPARQLQueryPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.textArea = new JTextArea(TEXT);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Query", new JScrollPane(this.textArea));
        JButton jButton = new JButton("Execute Query");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SPARQLQueryPanel.this.executeQuery();
            }
        });
        oWLLabeledComponent.addHeaderButton(new AbstractAction("Assert matches for this query", OWLIcons.getImageIcon("AssertTrue")){

            public void actionPerformed(ActionEvent actionEvent) {
                SPARQLQueryPanel.this.handleAssertMatches("http://www.owl-ontologies.com/assert.owl#notEmpty", "http://www.owl-ontologies.com/assert.owl#empty");
            }
        });
        oWLLabeledComponent.addHeaderButton(new AbstractAction("Assert no matches for this query", OWLIcons.getImageIcon("AssertFalse")){

            public void actionPerformed(ActionEvent actionEvent) {
                SPARQLQueryPanel.this.handleAssertMatches("http://www.owl-ontologies.com/assert.owl#empty", "http://www.owl-ontologies.com/assert.owl#notEmpty");
            }
        });
        oWLLabeledComponent.setPreferredSize(new Dimension(300, 50));
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
        this.add("South", jButton);
    }

    private boolean canAssert(String string) {
        String string2 = this.owlModel.getResourceNameForURI(string);
        if (string2 != null && this.owlModel.getRDFProperty(string2) != null) {
            if (ProtegeUI.getProjectView(this.owlModel.getProject()).getTabbedPane().getSelectedComponent() instanceof OWLClassesTab) {
                return true;
            }
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "You need to select a class in the OWLClasses tab\nbefore you can assert a query.");
            return false;
        }
        if (this.owlModel instanceof JenaOWLModel && ProtegeUI.getModalDialogFactory().showConfirmDialog(this, "You need to import the following ontology before you\ncan use the assert queries support:\nhttp://www.owl-ontologies.com/assert.owl\nShall this be added now?", "Missing import")) {
            try {
                this.owlModel.getNamespaceManager().setPrefix("http://www.owl-ontologies.com/assert.owl#", "assert");
                ImportHelper importHelper = new ImportHelper((JenaOWLModel)this.owlModel);
                importHelper.addImport(URI.create("http://www.owl-ontologies.com/assert.owl"));
                importHelper.importOntologies();
            }
            catch (Exception exception) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Import failed: " + exception);
            }
        }
        return false;
    }

    private void executeQuery() {
        SPARQLResultsPanel sPARQLResultsPanel = SPARQLOWLModelAction.show(this.owlModel, false);
        String string = this.getQueryText();
        sPARQLResultsPanel.executeQuery(string);
    }

    public String getQueryText() {
        return this.textArea.getText();
    }

    private void handleAssertMatches(String string, String string2) {
        OWLClassesTab oWLClassesTab;
        RDFSNamedClass rDFSNamedClass;
        if (this.canAssert(string) && (rDFSNamedClass = (oWLClassesTab = (OWLClassesTab)ProtegeUI.getProjectView(this.owlModel.getProject()).getTabByClassName(OWLClassesTab.class.getName())).getSelectedClass()) != null) {
            String string3;
            RDFProperty rDFProperty;
            String string4 = this.owlModel.getResourceNameForURI(string);
            RDFProperty rDFProperty2 = this.owlModel.getRDFProperty(string4);
            String string5 = this.getQueryText();
            if (!rDFSNamedClass.getPropertyValues(rDFProperty2).contains(string5)) {
                rDFSNamedClass.addPropertyValue(rDFProperty2, string5);
            }
            if ((rDFProperty = this.owlModel.getRDFProperty(string3 = this.owlModel.getResourceNameForURI(string2))) != null) {
                rDFSNamedClass.removePropertyValue(rDFProperty, string5);
            }
        }
    }

    public void rememberQueryText() {
        TEXT = this.getQueryText();
    }

    public void setQueryText(String string) {
        this.textArea.setText(string);
    }
}

