/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.types;

import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;

public abstract class AbstractPropertyTypesWidget
extends AbstractPropertyWidget {
    private TypeCheckBox[] checkBoxes;

    private RDFProperty getEditedProperty() {
        return (RDFProperty)this.getEditedResource();
    }

    private RDFProperty getSuperpropertyWithType(RDFSNamedClass rDFSNamedClass) {
        for (RDFProperty rDFProperty : this.getEditedProperty().getSuperproperties(true)) {
            if (!rDFProperty.hasProtegeType(rDFSNamedClass)) continue;
            return rDFProperty;
        }
        return null;
    }

    private String getTypeLabel(RDFSNamedClass rDFSNamedClass) {
        return rDFSNamedClass.getName();
    }

    protected void initialize(RDFSNamedClass[] rDFSNamedClassArray) {
        this.checkBoxes = new TypeCheckBox[rDFSNamedClassArray.length];
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        for (int i = 0; i < rDFSNamedClassArray.length; ++i) {
            RDFSNamedClass rDFSNamedClass = rDFSNamedClassArray[i];
            this.checkBoxes[i] = new TypeCheckBox(rDFSNamedClass);
            this.add(this.checkBoxes[i]);
            this.add(Box.createVerticalStrut(4));
        }
    }

    private boolean isPropagatedType(RDFSClass rDFSClass) {
        return rDFSClass.equals(rDFSClass.getOWLModel().getOWLFunctionalPropertyClass()) || rDFSClass.equals(rDFSClass.getOWLModel().getOWLInverseFunctionalPropertyClass());
    }

    protected boolean isValidChange(RDFSNamedClass rDFSNamedClass, boolean bl) {
        RDFProperty rDFProperty;
        if (!bl && this.isPropagatedType(rDFSNamedClass) && (rDFProperty = this.getSuperpropertyWithType(rDFSNamedClass)) != null) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(rDFSNamedClass.getOWLModel(), "This property already has the " + this.getTypeLabel(rDFSNamedClass) + "\n" + "super-property " + rDFProperty.getBrowserText() + " and therefore\n" + "must also remain " + this.getTypeLabel(rDFSNamedClass) + ".", "Warning");
            return false;
        }
        return true;
    }

    protected void postProcessChange(RDFSNamedClass rDFSNamedClass) {
        RDFProperty rDFProperty = this.getEditedProperty();
        RDFProperty rDFProperty2 = rDFProperty.getInverseProperty();
        if (rDFProperty2 != null) {
            RDFSNamedClass rDFSNamedClass2 = rDFSNamedClass.getOWLModel().getOWLFunctionalPropertyClass();
            RDFSNamedClass rDFSNamedClass3 = rDFSNamedClass.getOWLModel().getOWLInverseFunctionalPropertyClass();
            if (rDFSNamedClass.equals(rDFSNamedClass2)) {
                if (rDFProperty.hasRDFType(rDFSNamedClass2)) {
                    if (!rDFProperty2.hasRDFType(rDFSNamedClass3)) {
                        rDFProperty2.addRDFType(rDFSNamedClass3);
                    }
                } else if (rDFProperty2.hasRDFType(rDFSNamedClass3)) {
                    rDFProperty2.removeRDFType(rDFSNamedClass3);
                }
            } else if (rDFProperty.hasRDFType(rDFSNamedClass3)) {
                if (!rDFProperty2.hasRDFType(rDFSNamedClass2)) {
                    rDFProperty2.addRDFType(rDFSNamedClass2);
                }
            } else if (rDFProperty2.hasRDFType(rDFSNamedClass2)) {
                rDFProperty2.removeRDFType(rDFSNamedClass2);
            }
        }
    }

    public void setEditable(boolean bl) {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            boolean bl2 = bl;
            TypeCheckBox typeCheckBox = this.checkBoxes[i];
            if (this.isPropagatedType(typeCheckBox.type)) {
                Collection collection = this.getEditedProperty().getSuperproperties(true);
                for (RDFProperty rDFProperty : collection) {
                    if (!rDFProperty.hasRDFType(typeCheckBox.type)) continue;
                    bl2 = false;
                    break;
                }
            }
            typeCheckBox.setEnabled(bl2);
        }
    }

    public void setValues(Collection collection) {
        this.updateCheckBoxes();
    }

    private void updateCheckBoxes() {
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            TypeCheckBox typeCheckBox = this.checkBoxes[i];
            typeCheckBox.updateSelection();
        }
    }

    private class TypeCheckBox
    extends JCheckBox {
        private RDFSNamedClass type;

        TypeCheckBox(RDFSNamedClass rDFSNamedClass) {
            String string = rDFSNamedClass.getLocalName();
            this.setText(string.substring(0, string.length() - "Property".length()));
            this.type = rDFSNamedClass;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TypeCheckBox.this.addOrRemoveType();
                }
            });
        }

        private void addOrRemoveType() {
            RDFProperty rDFProperty = AbstractPropertyTypesWidget.this.getEditedProperty();
            if (this.isSelected() && !rDFProperty.hasProtegeType(this.type)) {
                if (AbstractPropertyTypesWidget.this.isValidChange(this.type, true)) {
                    rDFProperty.addProtegeType(this.type);
                    AbstractPropertyTypesWidget.this.postProcessChange(this.type);
                } else {
                    this.setSelected(false);
                }
            } else if (!this.isSelected() && rDFProperty.hasProtegeType(this.type)) {
                if (AbstractPropertyTypesWidget.this.isValidChange(this.type, false)) {
                    rDFProperty.removeProtegeType(this.type);
                    AbstractPropertyTypesWidget.this.postProcessChange(this.type);
                } else {
                    this.setSelected(true);
                }
            }
        }

        void updateSelection() {
            boolean bl = AbstractPropertyTypesWidget.this.getEditedProperty().hasProtegeType(this.type);
            if (!bl && AbstractPropertyTypesWidget.this.isPropagatedType(this.type)) {
                bl = AbstractPropertyTypesWidget.this.getSuperpropertyWithType(this.type) != null;
            }
            this.setSelected(bl);
        }
    }
}

