/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.properties.OWLSubpropertyPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class OWLSuperpropertiesPanel
extends SelectableContainer {
    private AbstractAction addAction;
    private SelectableList list;
    private OWLModel owlModel;
    private RDFProperty property;
    private PropertyListener propertyListener = new PropertyAdapter(){

        public void superpropertyAdded(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
            ComponentUtilities.addListValue((JList)OWLSuperpropertiesPanel.this.list, (Object)rDFProperty2);
        }

        public void superpropertyRemoved(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
            boolean bl = OWLSuperpropertiesPanel.this.setNotificationsEnabled(false);
            ComponentUtilities.removeListValue((JList)OWLSuperpropertiesPanel.this.list, (Object)rDFProperty2);
            OWLSuperpropertiesPanel.this.setNotificationsEnabled(bl);
        }
    };
    private AbstractAction removeAction;
    private OWLSubpropertyPane subpropertyPane;

    public OWLSuperpropertiesPanel(OWLSubpropertyPane oWLSubpropertyPane, Project project) {
        this(oWLSubpropertyPane, (OWLModel)project.getKnowledgeBase());
    }

    public OWLSuperpropertiesPanel(OWLSubpropertyPane oWLSubpropertyPane, OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.createComponents();
        this.layoutComponents();
        this.setSelectable((Selectable)this.list);
        this.setPreferredSize(new Dimension(0, 100));
        this.subpropertyPane = oWLSubpropertyPane;
    }

    private void addProperties() {
        ArrayList arrayList = new ArrayList(this.owlModel.getRDFProperties());
        arrayList.remove(this.property);
        arrayList.removeAll(this.property.getSubproperties(true));
        arrayList.removeAll(this.property.getSuperproperties(true));
        for (RDFProperty rDFProperty : this.selectProperties(arrayList)) {
            this.property.addSuperproperty(rDFProperty);
        }
        this.updateModel();
    }

    private void createComponents() {
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setCellRenderer((ListCellRenderer)((Object)new ResourceRenderer()));
        this.addAction = this.createAddAction();
        this.removeAction = this.createRemoveAction();
    }

    private AbstractAction createAddAction() {
        return new AddAction("Add super properties...", OWLIcons.getAddIcon("RDFProperty")){

            public void onAdd() {
                if (OWLSuperpropertiesPanel.this.property != null) {
                    OWLSuperpropertiesPanel.this.addProperties();
                }
            }
        };
    }

    private AbstractAction createRemoveAction() {
        return new RemoveAction("Remove super property", (Selectable)this.list, OWLIcons.getRemoveIcon("RDFProperty")){

            public void onRemove(Collection collection) {
                OWLSuperpropertiesPanel.this.removeProperties(collection);
            }
        };
    }

    public void setAddActionIconBase(String string) {
        this.addAction.putValue("SmallIcon", OWLIcons.getAddIcon(string));
    }

    public void setRemoveActionIconBase(String string) {
        this.removeAction.putValue("SmallIcon", OWLIcons.getRemoveIcon(string));
    }

    private void layoutComponents() {
        JScrollPane jScrollPane = ComponentFactory.createScrollPane((JComponent)this.list);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Super Properties", jScrollPane);
        oWLLabeledComponent.addHeaderButton(this.addAction);
        oWLLabeledComponent.addHeaderButton(this.removeAction);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)oWLLabeledComponent), "Center");
    }

    private Collection selectProperties(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDFProperty rDFProperty = (RDFProperty)iterator.next();
            if (this.subpropertyPane.contains(rDFProperty)) {
                if (!rDFProperty.isAnnotationProperty()) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        return ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection((Component)((Object)this), this.owlModel, collection, "Select Properties");
    }

    private void removeProperties(Collection collection) {
        this.owlModel.beginTransaction("Remove superproperties from " + this.property);
        for (RDFProperty rDFProperty : collection) {
            this.property.removeSuperproperty(rDFProperty);
        }
        this.updateModel();
    }

    public void setProperty(RDFProperty rDFProperty, RDFProperty rDFProperty2) {
        if (this.property != null) {
            this.property.removePropertyListener(this.propertyListener);
        }
        this.property = rDFProperty;
        if (this.property != null) {
            this.property.addPropertyListener(this.propertyListener);
        }
        this.updateModel();
        this.addAction.setEnabled(rDFProperty != null && rDFProperty.isEditable());
        this.list.setSelectedValue((Object)rDFProperty2, true);
    }

    public void setDisplayParent(RDFProperty rDFProperty) {
        this.list.setSelectedValue((Object)rDFProperty, true);
    }

    private void updateModel() {
        List list = this.property == null ? Collections.EMPTY_LIST : this.property.getSuperproperties(false);
        SimpleListModel simpleListModel = new SimpleListModel((Collection)list);
        this.list.setModel((ListModel)simpleListModel);
        this.repaint();
    }
}

