/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.profiles;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.icons.OverlayIcon;
import edu.stanford.smi.protegex.owl.ui.profiles.EditProfilePanel;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class ProfileSelectionPanel
extends JPanel {
    private boolean changed = false;
    private Action createFileAction = new AbstractAction("Create new profile file...", OWLIcons.getCreateIcon("File")){

        public void actionPerformed(ActionEvent actionEvent) {
            ProfileSelectionPanel.this.createFile();
        }
    };
    private JRadioButton customRadioButton;
    private JTextField customTextField;
    private OntModel defaultOntModel;
    private JRadioButton defaultRadioButton;
    public static final String[] DEFAULT_PROFILES = new String[]{OWLProfiles.RDF.getURI(), OWLProfiles.RDF_but_not_OWL.getURI(), OWLProfiles.OWL_Full.getURI(), OWLProfiles.OWL_DL.getURI(), OWLProfiles.OWL_Lite.getURI()};
    private Action editProfileAction = new AbstractAction("Edit profile...", OWLIcons.getImageIcon("EditProfile")){

        public void actionPerformed(ActionEvent actionEvent) {
            ProfileSelectionPanel.this.editProfile();
        }
    };
    private static JFileChooser fileChooser;
    private String oldProfileURI;
    private OWLModel owlModel;
    private JComboBox predefinedProfileComboBox;
    private Action selectFileAction = new AbstractAction("Select file...", OWLIcons.getAddIcon("File")){

        public void actionPerformed(ActionEvent actionEvent) {
            ProfileSelectionPanel.this.selectFile();
        }
    };

    public ProfileSelectionPanel(OWLModel oWLModel) {
        this.oldProfileURI = ProfilesManager.getProfile(oWLModel);
        this.defaultOntModel = ProfilesManager.getDefaultProfileOntModel();
        if (this.defaultOntModel == null) {
            return;
        }
        this.owlModel = oWLModel;
        this.predefinedProfileComboBox = this.createComboBox(oWLModel);
        this.defaultRadioButton = new JRadioButton("Use standard profile:");
        this.defaultRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectionPanel.this.updateComponents(true);
            }
        });
        this.customRadioButton = new JRadioButton("Use custom profile:");
        this.customRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfileSelectionPanel.this.updateComponents(false);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.customRadioButton);
        buttonGroup.add(this.defaultRadioButton);
        this.setBorder(BorderFactory.createTitledBorder("Language Profile"));
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.defaultRadioButton);
        jPanel.add(this.predefinedProfileComboBox);
        this.customTextField = new JTextField();
        String string = ProfilesManager.getCustomProfileURI(oWLModel);
        if (string != null) {
            this.customTextField.setText(string);
        }
        this.customTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ProfileSelectionPanel.this.assignCustomTextFieldValue();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(this.customRadioButton);
        jPanel2.add(this.customTextField);
        this.customTextField.setPreferredSize(new Dimension(300, this.customTextField.getPreferredSize().height));
        JToolBar jToolBar = ComponentFactory.createToolBar();
        this.addToolBarButton(jToolBar, this.createFileAction);
        this.addToolBarButton(jToolBar, this.selectFileAction);
        this.addToolBarButton(jToolBar, this.editProfileAction);
        jPanel2.add(jToolBar);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createLeftAlignedPanel(jPanel));
        this.add(this.createLeftAlignedPanel(jPanel2));
        this.updateComponents(ProfilesManager.getCustomProfileURI(oWLModel) == null);
    }

    private void assignCustomTextFieldValue() {
        String string = this.customTextField.getText().trim();
        String string2 = null;
        string2 = string.length() == 0 ? ProfilesManager.getPredefinedProfile(this.owlModel) : string;
        ProfilesManager.setProfile(this.owlModel, string2);
    }

    private void addToolBarButton(JToolBar jToolBar, Action action) {
        JButton jButton = ComponentFactory.addToolBarButton((JToolBar)jToolBar, (Action)action);
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon instanceof OverlayIcon) {
            jButton.setDisabledIcon(((OverlayIcon)icon).getGrayedIcon());
        }
    }

    private JComboBox createComboBox(final OWLModel oWLModel) {
        final OntClass[] ontClassArray = new OntClass[DEFAULT_PROFILES.length];
        for (int i = 0; i < ontClassArray.length; ++i) {
            ontClassArray[i] = this.defaultOntModel.getOntClass(DEFAULT_PROFILES[i]);
        }
        final JComboBox<OntClass> jComboBox = new JComboBox<OntClass>(ontClassArray);
        String string = ProfilesManager.getPredefinedProfile(oWLModel);
        int n = 0;
        while (!string.equals(ontClassArray[n].getURI())) {
            ++n;
        }
        jComboBox.setSelectedIndex(n);
        jComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                OntClass ontClass = (OntClass)object;
                String string = ontClass.getLabel("");
                return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            }
        });
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProfilesManager.setProfile(oWLModel, ontClassArray[jComboBox.getSelectedIndex()].getURI());
                oWLModel.setOWLTestGroupEnabled("OWL-DL Tests", ProfilesManager.isFeatureSupported(oWLModel, OWLProfiles.OWL_DL));
            }
        });
        return jComboBox;
    }

    private void createFile() {
        String string = "MyProfile";
        String string2 = ".owl";
        String string3 = string + string2;
        int n = 1;
        while (new File(string3).exists()) {
            string3 = string + "_" + n + string2;
            ++n;
        }
        String string4 = ProfilesManager.getPredefinedProfile(this.owlModel);
        String string5 = "http://www.owl-ontologies.com/" + string3 + "#";
        OntModel ontModel = ProfilesManager.createProfile(string5);
        OntClass ontClass = ontModel.createClass(string5 + "MyProfile");
        Resource resource = ontModel.getResource(string4);
        ontModel.add(resource, RDFS.subClassOf, (RDFNode)ontClass);
        try {
            ProfilesManager.saveOntModel(ontModel, string3);
            this.customTextField.setText(string3);
            this.changed = true;
            ProfilesManager.setProfile(this.owlModel, string3);
            ProfilesManager.clearCache(string3);
            OntModel ontModel2 = ProfilesManager.getProfileOntModel(this.owlModel);
            if (EditProfilePanel.showProfilePanelDialog(this.owlModel, ontModel2, string3)) {
                this.customTextField.setText(ProfilesManager.getCustomProfileURI(this.owlModel));
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            OWLUI.showErrorMessageDialog("Could not create profile file " + string3 + ":\n" + exception, "Error");
        }
    }

    private JPanel createLeftAlignedPanel(Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("West", component);
        jPanel.add("Center", new JPanel());
        return jPanel;
    }

    private void editProfile() {
        if (ProfilesManager.getCustomProfileURI(this.owlModel) != null) {
            if (EditProfilePanel.showProfilePanelDialog(this.owlModel)) {
                this.customTextField.setText(ProfilesManager.getCustomProfileURI(this.owlModel));
                this.changed = true;
            }
        } else {
            this.createFile();
        }
    }

    public boolean getRequiresReloadUI() {
        return !this.oldProfileURI.equals(ProfilesManager.getProfile(this.owlModel)) || this.changed;
    }

    private void selectFile() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            this.customTextField.setText(file.getAbsolutePath());
        }
    }

    private void updateComponents(boolean bl) {
        this.defaultRadioButton.setSelected(bl);
        this.predefinedProfileComboBox.setEnabled(bl);
        this.customRadioButton.setSelected(!bl);
        this.customTextField.setEnabled(!bl);
        this.selectFileAction.setEnabled(!bl);
        this.createFileAction.setEnabled(!bl);
        this.editProfileAction.setEnabled(!bl);
    }
}

