/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public abstract class OWLTableTransferHandler
extends TransferHandler {
    private boolean inTransaction = false;
    private OWLModel owlModel;
    protected int[] rows = null;

    public OWLTableTransferHandler(OWLModel oWLModel) {
        this.owlModel = oWLModel;
    }

    protected boolean addRow(OWLTableModel oWLTableModel, RDFSClass rDFSClass, int n) {
        return oWLTableModel.addRow(rDFSClass, n);
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        OWLTable oWLTable = (OWLTable)((Object)jComponent);
        if (oWLTable.getOWLTableModel().isEditable()) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                DataFlavor dataFlavor = dataFlavorArray[i];
                if (!DataFlavor.stringFlavor.equals(dataFlavor)) continue;
                return true;
            }
        }
        return false;
    }

    protected void cleanup(JComponent jComponent, boolean bl) {
        this.rows = null;
        if (this.inTransaction) {
            this.inTransaction = false;
            this.owlModel.endTransaction();
        }
    }

    protected Transferable createTransferable(JComponent jComponent) {
        JTable jTable = (JTable)jComponent;
        int[] nArray = jTable.getSelectedRows();
        if (nArray.length > 0) {
            return this.exportOWLClses(jTable);
        }
        return null;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        this.cleanup(jComponent, n == 2);
    }

    protected Transferable exportOWLClses(JComponent jComponent) {
        JTable jTable = (JTable)jComponent;
        OWLTableModel oWLTableModel = (OWLTableModel)jTable.getModel();
        this.rows = jTable.getSelectedRows();
        String string = "";
        for (int i = 0; i < this.rows.length; ++i) {
            RDFSClass rDFSClass = oWLTableModel.getClass(this.rows[i]);
            if (rDFSClass != null) {
                string = string + rDFSClass.getBrowserText();
                if (i >= this.rows.length - 1) continue;
                string = string + "\n";
                continue;
            }
            this.rows = null;
            return null;
        }
        return new StringSelection(string);
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    protected OWLNamedClass getRootCls() {
        return this.owlModel.getOWLThingClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int importOWLClses(JComponent jComponent, String string) {
        OWLTable oWLTable = (OWLTable)((Object)jComponent);
        OWLTableModel oWLTableModel = (OWLTableModel)oWLTable.getModel();
        int n = oWLTable.getSelectedRow();
        if (this.rows != null && n >= this.rows[0] && n <= this.rows[this.rows.length - 1]) {
            this.rows = null;
            return -1;
        }
        if (n < 0) {
            n = oWLTableModel.getRowCount();
        }
        int n2 = n;
        try {
            this.owlModel.beginTransaction("Drag and drop in classes/conditions");
            String[] stringArray = string.split("\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                RDFSClass rDFSClass = this.owlModel.getOWLClassDisplay().getParser().parseClass(this.owlModel, string2);
                boolean bl = this.addRow(oWLTableModel, rDFSClass, n);
                if (bl) {
                    oWLTable.setSelectedRow(rDFSClass);
                } else {
                    this.rows = null;
                    n2 = -1;
                }
                ++n;
                if (bl || !(rDFSClass instanceof OWLAnonymousClass)) continue;
                rDFSClass.delete();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.inTransaction = true;
        }
        return n2;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return this.importOWLClses(jComponent, string) >= 0;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

