/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class DeleteRowAction
extends AbstractOWLTableAction {
    private OWLTable table;

    public DeleteRowAction(OWLTable oWLTable) {
        super("Delete selected row", OWLIcons.getDeleteIcon("OWLAnonymousClass"));
        this.table = oWLTable;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OWLTableModel oWLTableModel;
        OWLClassesTab oWLClassesTab = OWLClassesTab.getOWLClassesTab((Component)((Object)this.table));
        OWLNamedClass oWLNamedClass = this.table.getEditedCls();
        int n = this.table.getSelectedRow();
        if (n >= 0 && (oWLTableModel = (OWLTableModel)this.table.getModel()).isCellEditable(n, oWLTableModel.getSymbolColumnIndex())) {
            oWLTableModel.deleteRow(n);
            this.table.getSelectionModel().setSelectionInterval(n, n);
            if (oWLClassesTab != null) {
                oWLClassesTab.ensureClassSelected(oWLNamedClass, -1);
            }
        }
    }

    public boolean isEnabledFor(RDFSClass rDFSClass, int n) {
        OWLTableModel oWLTableModel = (OWLTableModel)this.table.getModel();
        return rDFSClass != null && oWLTableModel.isDeleteEnabledFor(rDFSClass);
    }
}

