/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metrics.lang;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.util.DLExpressivityChecker;
import edu.stanford.smi.protegex.owl.ui.metrics.lang.DLExpressivityTableModel;
import edu.stanford.smi.protegex.owl.ui.metrics.lang.DLNamePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;

public class DLExpressivityPanel
extends JPanel {
    private OWLModel owlModel;

    public DLExpressivityPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout(12, 12));
        DLExpressivityChecker dLExpressivityChecker = new DLExpressivityChecker(this.owlModel);
        dLExpressivityChecker.check();
        JPanel jPanel = new JPanel(new BorderLayout(7, 7));
        jPanel.add((Component)new JLabel("The DL expressivity of this ontology is:"), "North");
        ArrayList arrayList = new ArrayList(dLExpressivityChecker.getDL());
        DLNamePanel dLNamePanel = new DLNamePanel(arrayList);
        dLNamePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        jPanel.add((Component)dLNamePanel, "South");
        this.add((Component)jPanel, "North");
        JTable jTable = new JTable(new DLExpressivityTableModel(arrayList));
        jTable.setRowHeight(55);
        jTable.setAutoResizeMode(4);
        jTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        jTable.getColumnModel().getColumn(1).setPreferredWidth(600);
        jTable.getColumnModel().getColumn(1).setCellRenderer(new ExplanationRenderer());
        jTable.setShowGrid(true);
        jTable.setGridColor(Color.LIGHT_GRAY);
        this.add(new JScrollPane(jTable));
    }

    private class ExplanationRenderer
    implements TableCellRenderer {
        private JTextArea textArea = new JTextArea();

        public ExplanationRenderer() {
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.textArea.setText(object != null ? object.toString() : "");
            return this.textArea;
        }
    }
}

