/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.alldifferent;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceComparator;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metadatatab.alldifferent.AllDifferentMemberChangedListener;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AllDifferentEditorPanel
extends JPanel
implements Disposable {
    private Action addAction = new AbstractAction("Add Instance", OWLIcons.getAddIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent actionEvent) {
            AllDifferentEditorPanel.this.addInstance();
        }
    };
    private Action addInstancesOfClsAction = new AbstractAction("Add all Instances from a given class", OWLIcons.getAddIcon("PrimitiveClass")){

        public void actionPerformed(ActionEvent actionEvent) {
            AllDifferentEditorPanel.this.addInstancesOfCls();
        }
    };
    private AllDifferentMemberChangedListener allDifferentMemberChangedListener;
    private OWLAllDifferent currentOWLAllDifferent;
    private boolean isAllDifferentItemSelected;
    private JList list;
    private DefaultListModel listModel;
    private PropertyValueListener membersListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
            AllDifferentEditorPanel.this.updateValues();
        }
    };
    private OWLModel owlModel;
    private Action removeAction = new AbstractAction("Remove Instance", OWLIcons.getRemoveIcon("RDFIndividual")){

        public void actionPerformed(ActionEvent actionEvent) {
            AllDifferentEditorPanel.this.removeInstance();
        }
    };
    private Action viewAction = new AbstractAction("View Instance", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            Instance instance = (Instance)AllDifferentEditorPanel.this.list.getSelectedValue();
            AllDifferentEditorPanel.this.owlModel.getProject().show(instance);
        }
    };

    public AllDifferentEditorPanel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.isAllDifferentItemSelected = false;
        this.viewAction.setEnabled(false);
        this.addAction.setEnabled(false);
        this.addInstancesOfClsAction.setEnabled(false);
        this.removeAction.setEnabled(false);
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AllDifferentEditorPanel.this.enableViewAndRemoveAction();
            }
        });
        FrameRenderer frameRenderer = FrameRenderer.createInstance();
        this.list.setCellRenderer(frameRenderer);
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Distinct Members of Selected Set", new JScrollPane(this.list));
        WidgetUtilities.addViewButton(oWLLabeledComponent, this.viewAction);
        oWLLabeledComponent.addHeaderButton(this.addAction);
        oWLLabeledComponent.addHeaderButton(this.addInstancesOfClsAction);
        oWLLabeledComponent.addHeaderButton(this.removeAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    private void addInstance() {
        if (!this.isAllDifferentItemSelected) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(this.owlModel, "Select an All-Different Element first", "No Item Selected");
            return;
        }
        Set set = ProtegeUI.getSelectionDialogFactory().selectResourcesByType(this, this.owlModel, Collections.singleton(this.owlModel.getOWLThingClass()), "Add individuals");
        HashSet hashSet = new HashSet(this.currentOWLAllDifferent.getDistinctMembers());
        hashSet.addAll(set);
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, new ResourceComparator());
        this.currentOWLAllDifferent.setDistinctMembers(arrayList);
        this.allDifferentMemberChangedListener.allDifferentMemberChanged();
        this.updateValues();
    }

    private void addInstancesOfCls() {
        RDFSNamedClass rDFSNamedClass = ProtegeUI.getSelectionDialogFactory().selectClass(this, this.owlModel);
        if (rDFSNamedClass != null) {
            for (Instance instance : rDFSNamedClass.getDirectInstances()) {
                if (!(instance instanceof RDFResource)) continue;
                this.currentOWLAllDifferent.addDistinctMember((RDFIndividual)instance);
            }
            this.allDifferentMemberChangedListener.allDifferentMemberChanged();
            this.updateValues();
        }
    }

    private void enableViewAndRemoveAction() {
        boolean bl = this.list.getSelectedIndex() >= 0;
        this.viewAction.setEnabled(bl);
        this.removeAction.setEnabled(bl);
    }

    void disableAddAction() {
        this.addAction.setEnabled(false);
        this.addInstancesOfClsAction.setEnabled(false);
    }

    public void dispose() {
        if (this.currentOWLAllDifferent != null) {
            this.currentOWLAllDifferent.removePropertyValueListener(this.membersListener);
        }
    }

    private void removeInstance() {
        RDFIndividual rDFIndividual = (RDFIndividual)this.list.getSelectedValue();
        if (rDFIndividual == null) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(this.owlModel, "Select an All-Different Member first", "No Item Selected");
            return;
        }
        this.currentOWLAllDifferent.removeDistinctMember(rDFIndividual);
        this.updateValues();
        this.allDifferentMemberChangedListener.allDifferentMemberChanged();
    }

    protected void setIsAllDifferentItemSelected(boolean bl) {
        this.isAllDifferentItemSelected = bl;
        this.addAction.setEnabled(true);
        this.addInstancesOfClsAction.setEnabled(true);
    }

    public void setAllDifferentMemberChangedListener(AllDifferentMemberChangedListener allDifferentMemberChangedListener) {
        this.allDifferentMemberChangedListener = allDifferentMemberChangedListener;
    }

    void setSelectedAllDifferentInstance(OWLAllDifferent oWLAllDifferent) {
        if (this.currentOWLAllDifferent != null) {
            this.currentOWLAllDifferent.removePropertyValueListener(this.membersListener);
        }
        this.currentOWLAllDifferent = oWLAllDifferent;
        if (this.currentOWLAllDifferent != null) {
            this.currentOWLAllDifferent.addPropertyValueListener(this.membersListener);
        }
        this.updateValues();
    }

    private void updateValues() {
        this.listModel.removeAllElements();
        if (this.currentOWLAllDifferent != null) {
            Iterator iterator = this.currentOWLAllDifferent.listDistinctMembers();
            while (iterator.hasNext()) {
                RDFIndividual rDFIndividual = (RDFIndividual)iterator.next();
                this.listModel.addElement(rDFIndividual);
            }
        }
    }
}

