/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreePanel;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractTabWidget;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JSplitPane;

public class OWLMetadataTab
extends AbstractTabWidget
implements HostResourceDisplay {
    private ResourcePanel resourceDisplay;
    private ImportsTreePanel importsTreePanel;
    private SelectionListener treeSelectionListener;

    private JComponent createMainPanel() {
        this.treeSelectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                Set set = OWLMetadataTab.this.importsTreePanel.getImportsTree().getSelectedResources();
                RDFResource rDFResource = (RDFResource)CollectionUtilities.getFirstItem((Collection)set);
                OWLMetadataTab.this.resourceDisplay.setResource(rDFResource);
            }
        };
        this.importsTreePanel = new ImportsTreePanel(this.getOWLModel().getDefaultOWLOntology());
        this.importsTreePanel.getImportsTree().addSelectionListener(this.treeSelectionListener);
        this.resourceDisplay = ProtegeUI.getResourcePanelFactory().createResourcePanel(this.getOWLModel(), 3);
        OWLOntology oWLOntology = OWLUtil.getActiveOntology(this.getOWLModel());
        if (oWLOntology != null) {
            this.displayHostResource(oWLOntology);
        }
        JSplitPane jSplitPane = this.createLeftRightSplitPane("SlotsTab.left_right", 250);
        jSplitPane.setLeftComponent(this.importsTreePanel);
        jSplitPane.setRightComponent((Component)((Object)this.resourceDisplay));
        jSplitPane.setDividerLocation(250);
        return jSplitPane;
    }

    public void dispose() {
        super.dispose();
        this.importsTreePanel.getImportsTree().removeSelectionListener(this.treeSelectionListener);
        this.resourceDisplay = null;
        this.importsTreePanel = null;
        this.treeSelectionListener = null;
    }

    public void initialize() {
        this.setIcon(OWLIcons.getImageIcon("Metadata"));
        JComponent jComponent = this.createMainPanel();
        this.add(jComponent);
    }

    public String getLabel() {
        String string = "Metadata";
        TripleStore tripleStore = this.getOWLModel().getTripleStoreModel().getActiveTripleStore();
        OWLOntology oWLOntology = (OWLOntology)TripleStoreUtil.getFirstOntology(this.getOWLModel(), tripleStore);
        if (oWLOntology != null) {
            String string2 = oWLOntology.getURI();
            int n = string2.lastIndexOf(47);
            if (n < 0) {
                n = string2.lastIndexOf(92);
            }
            if (n >= 0) {
                string2 = string2.substring(n + 1);
            }
            if (string2.length() > 25) {
                int n2 = string2.length();
                string2 = string2.substring(0, 10) + "..." + string2.substring(n2 - 10, n2);
            }
            string = string + " (" + string2 + ")";
        }
        return string;
    }

    public static boolean isSuitable(Project project, Collection collection) {
        return OWLClassesTab.isSuitable(project, collection);
    }

    public void setOntologyInstance(OWLOntology oWLOntology) {
        this.setOntology(oWLOntology);
    }

    public void setOntology(OWLOntology oWLOntology) {
        this.displayHostResource(oWLOntology);
    }

    public boolean displayHostResource(RDFResource rDFResource) {
        return this.importsTreePanel.displayHostResource(rDFResource);
    }
}

