/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.preferences;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ValidatableTabComponent;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerPreferences;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.forms.AbsoluteFormsGenerator;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.DatatypeSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.FormsSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.ProtegeSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.SearchSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.UISettingsPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.VisibilityPanel;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.WriterSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfileSelectionPanel;
import edu.stanford.smi.protegex.owl.ui.projectview.ConfigureTabsPanel;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestSettingsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PreferencesPanel
extends ValidatableTabComponent {
    private DatatypeSettingsPanel datatypeSettingsPanel;
    private JCheckBox encodeTagCheckBox;
    private ProfileSelectionPanel owlProfilePanel;
    private ConfigureTabsPanel configureTabsPanel;
    private UISettingsPanel uiSettingsPanel;
    private VisibilityPanel visibilityPanel;
    private OWLTestSettingsPanel testsPanel;

    public PreferencesPanel(OWLModel oWLModel) {
        this.addComponents(oWLModel);
    }

    private void addComponents(OWLModel oWLModel) {
        JPanel jPanel = this.createGeneralTab(oWLModel);
        JPanel jPanel2 = this.createEncodingTab();
        this.visibilityPanel = new VisibilityPanel(oWLModel);
        this.datatypeSettingsPanel = new DatatypeSettingsPanel(oWLModel);
        this.configureTabsPanel = new ConfigureTabsPanel(ProtegeUI.getProjectView(oWLModel.getProject()));
        this.testsPanel = new OWLTestSettingsPanel(oWLModel);
        this.addTab("General", jPanel);
        this.addTab("Visibility", this.visibilityPanel);
        this.addTab("Datatypes", this.datatypeSettingsPanel);
        this.addTab("Searching", new SearchSettingsPanel(oWLModel));
        this.addTab("Encoding", jPanel2);
        this.addTab("Tabs", (Component)((Object)this.configureTabsPanel));
        this.addTab("Tests", this.testsPanel);
    }

    private JPanel createGeneralTab(OWLModel oWLModel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.uiSettingsPanel = new UISettingsPanel(oWLModel);
        jPanel.add(this.uiSettingsPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 8));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Reasoning"));
        jPanel2.add("Center", (Component)new LabeledComponent("Reasoner URL", (Component)this.createValidatorField(), false));
        jPanel.add(jPanel2);
        if (oWLModel instanceof JenaOWLModel) {
            jPanel.add(Box.createVerticalStrut(8));
            jPanel.add(new ProtegeSettingsPanel((JenaOWLModel)oWLModel));
        }
        this.owlProfilePanel = new ProfileSelectionPanel(oWLModel);
        jPanel.add(Box.createVerticalStrut(8));
        jPanel.add(this.owlProfilePanel);
        if (oWLModel instanceof JenaOWLModel) {
            jPanel.add(Box.createVerticalStrut(8));
            jPanel.add(new WriterSettingsPanel((JenaOWLModel)oWLModel));
        }
        if (AbsoluteFormsGenerator.optional) {
            jPanel.add(Box.createVerticalStrut(8));
            jPanel.add(new FormsSettingsPanel(oWLModel));
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", jPanel);
        jPanel3.add("Center", new JPanel());
        return jPanel3;
    }

    private JPanel createEncodingTab() {
        this.encodeTagCheckBox = new JCheckBox("Don't write <?xml...> tag into RDF files", Jena.isXMLTagHidden());
        this.encodeTagCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Jena.setXMLTagHidden(PreferencesPanel.this.encodeTagCheckBox.isSelected());
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.encodeTagCheckBox);
        return jPanel;
    }

    private JTextField createValidatorField() {
        String string = ReasonerPreferences.getInstance().getReasonerURL();
        final JTextField jTextField = new JTextField(string);
        jTextField.setPreferredSize(new Dimension(300, 25));
        jTextField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = jTextField.getText();
                ReasonerPreferences.getInstance().setReasonerURL(string);
            }
        });
        return jTextField;
    }

    public boolean getRequiresReloadUI() {
        return this.visibilityPanel.getRequiresReloadUI() || this.owlProfilePanel.getRequiresReloadUI() || this.datatypeSettingsPanel.getRequiresReloadUI() || this.uiSettingsPanel.getRequiresReloadUI() || this.configureTabsPanel.getRequiresReloadUI();
    }

    public void ok() {
        this.configureTabsPanel.saveContents();
    }
}

