/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu.code;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.emf.EMFGenerator;
import edu.stanford.smi.protegex.owl.emf.ProjectBasedEMFGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import edu.stanford.smi.protegex.owl.ui.menu.code.EMFPanel;
import java.util.logging.Level;

public class EMFAction
extends AbstractOWLModelAction {
    public String getMenubarPath() {
        return CODE_MENU + "/" + "Java";
    }

    public String getName() {
        return "Generate EMF Java Interfaces...";
    }

    public void run(OWLModel oWLModel) {
        ProjectBasedEMFGeneratorOptions projectBasedEMFGeneratorOptions = new ProjectBasedEMFGeneratorOptions(oWLModel);
        EMFPanel eMFPanel = new EMFPanel(projectBasedEMFGeneratorOptions);
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(oWLModel.getProject()), eMFPanel, this.getName(), 11) == 1) {
            eMFPanel.ok();
            EMFGenerator eMFGenerator = new EMFGenerator(oWLModel, projectBasedEMFGeneratorOptions);
            try {
                eMFGenerator.createAllInterfaces();
                ProtegeUI.getModalDialogFactory().showMessageDialog(oWLModel, "EMF Interfaces generated.");
            }
            catch (Exception exception) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Could not create EMF code:\n" + exception);
            }
        }
    }
}

