/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.menu;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.actions.OWLModelAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class OWLModelActionAction
extends AbstractAction
implements Disposable {
    private OWLModel owlModel;
    private OWLModelAction owlModelAction;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            OWLModelActionAction.this.setEnabled(OWLModelActionAction.this.owlModelAction.isSuitable(OWLModelActionAction.this.owlModel));
        }
    };

    public OWLModelActionAction(OWLModelAction oWLModelAction, OWLModel oWLModel) {
        super(oWLModelAction.getName(), OWLModelActionAction.getIcon(oWLModelAction));
        this.owlModelAction = oWLModelAction;
        this.owlModel = oWLModel;
        this.setEnabled(oWLModelAction.isSuitable(oWLModel));
        oWLModelAction.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.owlModelAction.run(this.owlModel);
    }

    public void dispose() {
        this.owlModelAction.removePropertyChangeListener(this.propertyChangeListener);
    }

    public static Icon getIcon(OWLModelAction oWLModelAction) {
        Icon icon = Icons.getBlankIcon();
        String string = oWLModelAction.getIconFileName();
        if (string != null) {
            Class<OWLIcons> clazz = oWLModelAction.getIconResourceClass();
            if (clazz == null) {
                clazz = OWLIcons.class;
            }
            if (!string.endsWith(".gif") && !string.endsWith(".png")) {
                string = string + ".gif";
            }
            icon = OWLIcons.getImageIcon(string, clazz);
        }
        return icon;
    }
}

